/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin;

import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediareader.h264.MediaReaderH264;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.stream.IMediaReader;
import com.wowza.wms.stream.IMediaReaderActionNotify;
import com.wowza.wms.stream.IMediaStream;

public class ModuleMultiTrackVOD
extends ModuleBase
implements IMediaReaderActionNotify {
    public static final String MODULE_NAME = "ModuleMultiTrackVOD";
    public static final String PROP_NAME_PREFIX = "multiTrackVOD";
    public static final String PROPERTY_AUDIOINDEX = "audioindex";
    public static final String PROPERTY_VIDEOINDEX = "videoindex";
    public static final String PROPERTY_DATAINDEX = "dataindex";
    public static final String[] PROPERTY_INDEXES = new String[]{"audioindex", "videoindex", "dataindex"};
    public static final String MULTI_TRACK_VOD_RANDOM_ACCESS_READER_CLASS = "com.wowza.wms.plugin.RandomAccessReaderMultiTrackVOD";

    public void onAppStart(IApplicationInstance iApplicationInstance) {
        String string = iApplicationInstance.getMediaReaderProperties().getPropertyStr("randomAccessReaderClass");
        if (!MULTI_TRACK_VOD_RANDOM_ACCESS_READER_CLASS.equals(string)) {
            iApplicationInstance.getMediaReaderProperties().setProperty("randomAccessReaderClass", (Object)MULTI_TRACK_VOD_RANDOM_ACCESS_READER_CLASS);
        }
        iApplicationInstance.getProperties().setProperty("multiTrackVODRandomAccessReaderClass", (Object)string);
        iApplicationInstance.addMediaReaderListener((IMediaReaderActionNotify)this);
        WMSLoggerFactory.getLoggerObj((IApplicationInstance)iApplicationInstance).info("ModuleMultiTrackVOD version 2");
    }

    public void onMediaReaderCreate(IMediaReader iMediaReader) {
    }

    public void onMediaReaderInit(IMediaReader iMediaReader, IMediaStream iMediaStream) {
    }

    public void onMediaReaderOpen(IMediaReader iMediaReader, IMediaStream iMediaStream) {
        WMSProperties wMSProperties = iMediaStream.getProperties();
        if (iMediaReader instanceof MediaReaderH264) {
            int n;
            int n2;
            int n3 = wMSProperties.getPropertyInt(PROPERTY_AUDIOINDEX, -1);
            if (n3 > -1) {
                ((MediaReaderH264)iMediaReader).setTrackIndexAudio(n3);
            }
            if ((n2 = wMSProperties.getPropertyInt(PROPERTY_VIDEOINDEX, -1)) > -1) {
                ((MediaReaderH264)iMediaReader).setTrackIndexVideo(n2);
            }
            if ((n = wMSProperties.getPropertyInt(PROPERTY_DATAINDEX, -1)) > -1) {
                ((MediaReaderH264)iMediaReader).setTrackIndexData(n);
            }
        }
    }

    public void onMediaReaderExtractMetaData(IMediaReader iMediaReader, IMediaStream iMediaStream) {
    }

    public void onMediaReaderClose(IMediaReader iMediaReader, IMediaStream iMediaStream) {
    }
}

