/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin;

import com.wowza.io.DirectRandomAccessReader;
import com.wowza.io.IRandomAccessReader;
import com.wowza.io.ITrackRandomAccessReaderPerformance;
import com.wowza.util.HTTPUtils;
import com.wowza.util.IOPerformanceCounter;
import com.wowza.util.StringUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.plugin.ModuleMultiTrackVOD;
import com.wowza.wms.stream.IMediaStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;

public class RandomAccessReaderMultiTrackVOD
implements IRandomAccessReader,
ITrackRandomAccessReaderPerformance {
    public static final String CLASS_NAME = "RandomAccessReaderMultiTrackVOD";
    private IRandomAccessReader reader = null;

    private IRandomAccessReader getReader(IApplicationInstance iApplicationInstance) {
        DirectRandomAccessReader directRandomAccessReader = new DirectRandomAccessReader();
        String string = iApplicationInstance.getProperties().getPropertyStr("multiTrackVODRandomAccessReaderClass", "com.wowza.wms.plugin.RandomAccessReaderMultiTrackVOD");
        if (!string.equals("com.wowza.wms.plugin.RandomAccessReaderMultiTrackVOD")) {
            try {
                Class<?> clazz = Class.forName(string);
                if (clazz != null) {
                    directRandomAccessReader = (IRandomAccessReader)clazz.newInstance();
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLoggerObj((IApplicationInstance)iApplicationInstance).error("RandomAccessReaderMultiTrackVOD.getReader() Cannot load randomAccessReaderClass :" + string);
            }
        }
        return directRandomAccessReader;
    }

    public void init(IApplicationInstance iApplicationInstance, IMediaStream iMediaStream, String string, String string2, String string3) {
        this.reader = this.getReader(iApplicationInstance);
        try {
            System.out.println("Decoding mediaName: " + string2);
            string2 = string2.replaceAll("%(?![0-9a-fA-F]{2})", "%25");
            string2 = string2.replaceAll("\\+", "%2B");
            string2 = URLDecoder.decode(string2, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLoggerObj((IApplicationInstance)iApplicationInstance).warn("RandomAccessReaderMultiTrackVOD.init() Cannot url decode media name: " + string2 + ". Error: " + exception.getMessage());
        }
        if (iApplicationInstance.getMediaReaderContentType(string3) != 2) {
            int n;
            HashMap hashMap = new HashMap();
            String string4 = "";
            if (iMediaStream.getClient() != null && !StringUtils.isEmpty((String)iMediaStream.getClient().getQueryStr())) {
                string4 = iMediaStream.getClient().getQueryStr();
            }
            if (iMediaStream.getHTTPStreamerSession() != null && !StringUtils.isEmpty((String)iMediaStream.getHTTPStreamerSession().getQueryStr())) {
                string4 = iMediaStream.getHTTPStreamerSession().getQueryStr();
            }
            if (iMediaStream.getRTPStream() != null && iMediaStream.getRTPStream().getSession() != null && !StringUtils.isEmpty((String)iMediaStream.getRTPStream().getSession().getQueryStr())) {
                string4 = iMediaStream.getRTPStream().getSession().getQueryStr();
            }
            if (!string4.equals("")) {
                hashMap.putAll(HTTPUtils.splitQueryStr((String)string4));
            }
            if (!StringUtils.isEmpty((String)iMediaStream.getQueryStr())) {
                hashMap.putAll(HTTPUtils.splitQueryStr((String)iMediaStream.getQueryStr()));
            }
            if ((n = string2.indexOf("?")) >= 0) {
                String string5 = string2.substring(n + 1);
                hashMap.putAll(HTTPUtils.splitQueryStr((String)string5));
                string2 = string2.substring(0, n);
            }
            if (!hashMap.isEmpty()) {
                for (int i = 0; i < ModuleMultiTrackVOD.PROPERTY_INDEXES.length; ++i) {
                    String string6 = ModuleMultiTrackVOD.PROPERTY_INDEXES[i];
                    if (!hashMap.containsKey(string6)) continue;
                    try {
                        int n2 = Integer.parseInt((String)hashMap.get(string6));
                        iMediaStream.getProperties().setProperty(string6, (Object)n2);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        this.reader.init(iApplicationInstance, iMediaStream, string, string2, string3);
    }

    public void setStreamIOTracker(IOPerformanceCounter iOPerformanceCounter) {
        if (this.reader instanceof ITrackRandomAccessReaderPerformance) {
            ((ITrackRandomAccessReaderPerformance)this.reader).setStreamIOTracker(iOPerformanceCounter);
        }
    }

    public void setClientIOTracker(IOPerformanceCounter iOPerformanceCounter) {
        if (this.reader instanceof ITrackRandomAccessReaderPerformance) {
            ((ITrackRandomAccessReaderPerformance)this.reader).setClientIOTracker(iOPerformanceCounter);
        }
    }

    public void open() throws IOException {
        this.reader.open();
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public boolean isOpen() {
        return this.reader.isOpen();
    }

    public long getFilePointer() {
        return this.reader.getFilePointer();
    }

    public void seek(long l) {
        this.reader.seek(l);
    }

    public int read(byte[] byArray, int n, int n2) {
        return this.reader.read(byArray, n, n2);
    }

    public int getDirecton() {
        return this.reader.getDirecton();
    }

    public void setDirecton(int n) {
        this.reader.setDirecton(n);
    }

    public String getBasePath() {
        return this.reader.getBasePath();
    }

    public String getMediaName() {
        return this.reader.getMediaName();
    }

    public String getMediaExtension() {
        return this.reader.getMediaExtension();
    }

    public boolean exists() {
        return this.reader.exists();
    }

    public long lastModified() {
        return this.reader.lastModified();
    }

    public long length() {
        return this.reader.length();
    }

    public String getPath() {
        return this.reader.getPath();
    }
}

