/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin;

import com.wowza.util.StringUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.livepacketizer.ILiveStreamPacketizerControl;

public class PacketizerControl
extends ModuleBase {
    public static final String MODULE_NAME = "ModulePacketizerControl";
    public static final String PROP_NAME_PREFIX = "packetizerControl";
    private WMSLogger logger;
    private String suffixes = "*";
    private boolean matchAllow = true;
    private boolean noMatchAllow = false;

    public void onAppStart(IApplicationInstance iApplicationInstance) {
        this.logger = WMSLoggerFactory.getLoggerObj((IApplicationInstance)iApplicationInstance);
        this.suffixes = iApplicationInstance.getProperties().getPropertyStr("packetizerControlSuffixes", this.suffixes);
        this.matchAllow = iApplicationInstance.getProperties().getPropertyBoolean("packetizerControlMatchAllow", this.matchAllow);
        this.noMatchAllow = iApplicationInstance.getProperties().getPropertyBoolean("packetizerControlNoMatchAllow", this.noMatchAllow);
        iApplicationInstance.setLiveStreamPacketizerControl((ILiveStreamPacketizerControl)new PacketizerHandler());
    }

    private class PacketizerHandler
    implements ILiveStreamPacketizerControl {
        private PacketizerHandler() {
        }

        public boolean isLiveStreamPacketize(String string, IMediaStream iMediaStream) {
            String[] stringArray;
            PacketizerControl.this.logger.info("ModulePacketizerControl.isLiveStreamPacketize [" + string + " : " + iMediaStream.getName() + " : " + PacketizerControl.this.suffixes + "]", iMediaStream);
            if (PacketizerControl.this.suffixes.equals("*")) {
                PacketizerControl.this.logger.info("ModulePacketizerControl.isLiveStreamPacketize [" + string + " : " + iMediaStream.getName() + " :  suffixes is wildcard. returning " + PacketizerControl.this.matchAllow + "]", iMediaStream);
                return PacketizerControl.this.matchAllow;
            }
            if (StringUtils.isEmpty((String)PacketizerControl.this.suffixes)) {
                PacketizerControl.this.logger.info("ModulePacketizerControl.isLiveStreamPacketize [" + string + " : " + iMediaStream.getName() + " : suffixes is empty. returning " + PacketizerControl.this.noMatchAllow + "]", iMediaStream);
                return PacketizerControl.this.noMatchAllow;
            }
            for (String string2 : stringArray = PacketizerControl.this.suffixes.split(",")) {
                if (!iMediaStream.getName().endsWith(string2.trim())) continue;
                PacketizerControl.this.logger.info("ModulePacketizerControl.isLiveStreamPacketize [" + string + " : " + iMediaStream.getName() + " : match found : " + string2.trim() + " : returning " + PacketizerControl.this.matchAllow + "]", iMediaStream);
                return PacketizerControl.this.matchAllow;
            }
            PacketizerControl.this.logger.info("ModulePacketizerControl.isLiveStreamPacketize [" + string + " : " + iMediaStream.getName() + " : No match found : returning " + PacketizerControl.this.noMatchAllow + "]", iMediaStream);
            return PacketizerControl.this.noMatchAllow;
        }
    }
}

