/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.pathselector;

import com.wowza.io.DirectRandomAccessReader;
import com.wowza.io.IRandomAccessReader;
import com.wowza.io.ITrackRandomAccessReaderPerformance;
import com.wowza.util.IOPerformanceCounter;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.stream.IMediaStream;
import java.io.IOException;

public class RandomAccessReaderMediaListPathSelector
implements IRandomAccessReader,
ITrackRandomAccessReaderPerformance {
    public static final String CLASS_NAME = "RandomAccessReaderMediaListPathSelector";
    private IRandomAccessReader reader = null;
    private String prefixes = "";

    private IRandomAccessReader getReader(IApplicationInstance iApplicationInstance) {
        DirectRandomAccessReader directRandomAccessReader = null;
        String string = iApplicationInstance.getProperties().getPropertyStr("pathSelectorRandomAccessReaderClass", "com.wowza.wms.plugin.pathselector.RandomAccessReaderMediaListPathSelector");
        if (!string.equals("com.wowza.wms.plugin.pathselector.RandomAccessReaderMediaListPathSelector")) {
            try {
                Class<?> clazz = Class.forName(string);
                directRandomAccessReader = (IRandomAccessReader)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLoggerObj((IApplicationInstance)iApplicationInstance).error("RandomAccessReaderMediaListPathSelector.getReader() Cannot load randomAccessReaderClass :" + string);
            }
        } else {
            directRandomAccessReader = new DirectRandomAccessReader();
        }
        return directRandomAccessReader;
    }

    public void init(IApplicationInstance iApplicationInstance, IMediaStream iMediaStream, String string, String string2, String string3) {
        this.reader = this.getReader(iApplicationInstance);
        this.prefixes = iApplicationInstance.getProperties().getPropertyStr("pathSelectorPrefixes", this.prefixes);
        if (iApplicationInstance.getMediaReaderContentType(string3) != 2) {
            for (String string4 : this.prefixes.split(",")) {
                int n = string2.indexOf(string4 = string4.trim());
                if (n < 0) continue;
                string2 = string2.substring(n);
                break;
            }
        }
        this.reader.init(iApplicationInstance, iMediaStream, string, string2, string3);
    }

    public void setStreamIOTracker(IOPerformanceCounter iOPerformanceCounter) {
        if (this.reader instanceof ITrackRandomAccessReaderPerformance) {
            ((ITrackRandomAccessReaderPerformance)this.reader).setStreamIOTracker(iOPerformanceCounter);
        }
    }

    public void setClientIOTracker(IOPerformanceCounter iOPerformanceCounter) {
        if (this.reader instanceof ITrackRandomAccessReaderPerformance) {
            ((ITrackRandomAccessReaderPerformance)this.reader).setClientIOTracker(iOPerformanceCounter);
        }
    }

    public void open() throws IOException {
        this.reader.open();
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public boolean isOpen() {
        return this.reader.isOpen();
    }

    public long getFilePointer() {
        return this.reader.getFilePointer();
    }

    public void seek(long l) {
        this.reader.seek(l);
    }

    public int read(byte[] byArray, int n, int n2) {
        return this.reader.read(byArray, n, n2);
    }

    public int getDirecton() {
        return this.reader.getDirecton();
    }

    public void setDirecton(int n) {
        this.reader.setDirecton(n);
    }

    public String getBasePath() {
        return this.reader.getBasePath();
    }

    public String getMediaName() {
        return this.reader.getMediaName();
    }

    public String getMediaExtension() {
        return this.reader.getMediaExtension();
    }

    public boolean exists() {
        return this.reader.exists();
    }

    public long lastModified() {
        return this.reader.lastModified();
    }

    public long length() {
        return this.reader.length();
    }

    public String getPath() {
        return this.reader.getPath();
    }
}

