/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin;

import com.wowza.util.Base64;
import com.wowza.util.StringUtils;
import com.wowza.util.SystemUtils;
import com.wowza.wms.application.ApplicationInstance;
import com.wowza.wms.application.IApplication;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.client.IClient;
import com.wowza.wms.http.HTTProvider2Base;
import com.wowza.wms.http.IHTTPRequest;
import com.wowza.wms.http.IHTTPResponse;
import com.wowza.wms.httpstreamer.cupertinostreaming.httpstreamer.CupertinoStreamingURL;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.plugin.RefererValidate;
import com.wowza.wms.plugin.SessionInfo;
import com.wowza.wms.rtp.model.RTPSession;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.vhost.HostPort;
import com.wowza.wms.vhost.IVHost;
import edu.emory.mathcs.backport.java.util.concurrent.locks.WMSReadWriteLock;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;

public class HttpRefererValidate
extends HTTProvider2Base {
    public static final String CLASS_NAME = "HttpRefererValidate";
    public static final String PROP_HTTP_REFERER_VALIDATE = "httpRefererValidate";
    private static final String PIXEL_B64 = "R0lGODlhAQABAPAAAAAAAAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==";
    private static final byte[] PIXEL_BYTES = Base64.decode((String)"R0lGODlhAQABAPAAAAAAAAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==");
    private HttpRefererValidate validator;
    private List<SessionInfo> sessionInfoList;
    private Object lock;
    private WMSLogger logger;
    private Timer timer;
    private long sessionCheckInterval = 60000L;
    private boolean debugLog = false;

    public void onBind(IVHost iVHost, HostPort hostPort) {
        super.onBind(iVHost, hostPort);
        this.logger = WMSLoggerFactory.getLoggerObj((IVHost)iVHost);
        this.sessionCheckInterval = iVHost.getProperties().getPropertyLong("httpRefererValidateSessionCheckInterval", this.sessionCheckInterval);
        this.debugLog = iVHost.getProperties().getPropertyBoolean("httpRefererValidateDebugLog", this.debugLog);
        if (this.logger.isDebugEnabled()) {
            this.debugLog = true;
        }
        if (iVHost.getProperties().getProperty(PROP_HTTP_REFERER_VALIDATE) != null) {
            this.validator = (HttpRefererValidate)((Object)iVHost.getProperties().getProperty(PROP_HTTP_REFERER_VALIDATE));
            if (this.debugLog) {
                this.logger.info("HttpRefererValidateHTTP vhost validator [" + this.validator + "] already added", "vhost", "comment");
            }
        } else {
            if (this.debugLog) {
                this.logger.info("HttpRefererValidateHTTP vhost validator [" + this + "] added [" + hostPort.getPort() + "]", "vhost", "comment");
            }
            iVHost.getProperties().setProperty(PROP_HTTP_REFERER_VALIDATE, (Object)this);
            this.validator = this;
            this.sessionInfoList = new ArrayList<SessionInfo>();
            this.lock = new Object();
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new ExpireTimer(iVHost), 0L, this.sessionCheckInterval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SessionInfo> getSessionInfoList() {
        Object object = this.validator.lock;
        synchronized (object) {
            if (this.debugLog) {
                this.logger.info("HttpRefererValidateHTTP vhost validator get session list from [" + this.validator.sessionInfoList + "]", "vhost", "comment");
            }
            ArrayList<SessionInfo> arrayList = new ArrayList<SessionInfo>();
            arrayList.addAll(this.validator.sessionInfoList);
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onHTTPRequest(IVHost iVHost, IHTTPRequest iHTTPRequest, IHTTPResponse iHTTPResponse) {
        boolean bl;
        Object object;
        byte[] byArray;
        String string;
        String string2;
        WMSProperties wMSProperties;
        IApplicationInstance iApplicationInstance;
        boolean bl2;
        block37: {
            String string3 = "localhost, 127.0.0.1";
            bl2 = false;
            boolean bl3 = false;
            long l = 600000L;
            iApplicationInstance = null;
            wMSProperties = null;
            String string4 = "";
            String string5 = "";
            string2 = "";
            string = "";
            byArray = null;
            if (!this.doHTTPAuthentication(iVHost, iHTTPRequest, iHTTPResponse)) {
                return;
            }
            String string6 = iHTTPRequest.getHeader("context");
            if (string6 != null) {
                String[] stringArray;
                Object object2;
                String string7;
                String string8;
                block38: {
                    int n = string6.indexOf("?");
                    if (n >= 0) {
                        string6 = string6.substring(0, n);
                    }
                    object = new CupertinoStreamingURL(string6, true);
                    string4 = object.getAppName();
                    string5 = object.getAppInstanceName();
                    string2 = object.getStreamName();
                    string8 = iHTTPRequest.getRemoteAddr();
                    string7 = "";
                    if (iHTTPRequest.getHeaderNames().contains("referer")) {
                        try {
                            object2 = new URL(iHTTPRequest.getHeader("referer"));
                            string7 = ((URL)object2).getHost();
                        }
                        catch (MalformedURLException malformedURLException) {
                            this.logger.error("HttpRefererValidate.onHttpRequest Exception getting referer: ", (Throwable)malformedURLException);
                        }
                    }
                    object2 = iHTTPRequest.getQueryString();
                    if (this.debugLog) {
                        this.logger.info("HttpRefererValidate.onHttpRequest [appName: " + string4 + ", appInstName: " + string5 + ", streamName: " + string2 + ", ipAddress: " + string8 + ", referer: " + string7 + ", queryStr: " + (String)object2 + "]", "vhost", "comment");
                    }
                    WMSReadWriteLock wMSReadWriteLock = iVHost.getApplicationLock();
                    wMSReadWriteLock.writeLock().lock();
                    try {
                        stringArray = iVHost.getApplication(string4);
                        if (stringArray == null) {
                            this.logger.error("HttpRefererValidate.onHttpRequest application cannot be loaded: " + string4, "vhost", "comment");
                            break block37;
                        }
                        iApplicationInstance = stringArray.getAppInstance(string5);
                        if (iApplicationInstance != null) break block38;
                        this.logger.error("HttpRefererValidate.onHttpRequest application instance cannot be loaded: " + string4 + "/" + string5, "vhost", "comment");
                        break block37;
                    }
                    catch (Exception exception) {
                        this.logger.error("HttpRefererValidate.onHttpRequest Exception loading appInstance: " + string4 + "/" + string5, (Throwable)exception);
                        break block37;
                    }
                    finally {
                        wMSReadWriteLock.writeLock().unlock();
                    }
                }
                wMSProperties = iApplicationInstance.getProperties();
                string3 = wMSProperties.getPropertyStr("refererValidateReferers", string3);
                if (this.debugLog) {
                    this.logger.info("HttpRefererValidate.onHttpRequest [appName: " + string4 + ", appInstName: " + string5 + ", referers: " + string3 + "]", "vhost", "comment");
                }
                if (StringUtils.isEmpty((String)string3)) {
                    if (this.debugLog) {
                        this.logger.info("HttpRefererValidate.onHttpRequest [appName: " + string4 + ", appInstName: " + string5 + "] referers is empty. Allowing connections", "vhost", "comment");
                    }
                    bl2 = true;
                } else {
                    bl3 = wMSProperties.getPropertyBoolean("refererValidateAllowBlankReferers", bl3);
                    if (this.debugLog) {
                        this.logger.info("HttpRefererValidate.onHttpRequest [appName: " + string4 + ", appInstName: " + string5 + ", allowBlankReferers: " + bl3 + "]", "vhost", "comment");
                    }
                    if (StringUtils.isEmpty((String)string7) && bl3) {
                        if (this.debugLog) {
                            this.logger.info("HttpRefererValidate.onHttpRequest [appName: " + string4 + ", appInstName: " + string5 + "] Session referer is empty and blank referers allowed. Allowing connection", "vhost", "comment");
                        }
                        bl2 = true;
                    } else if (StringUtils.isEmpty((String)string7)) {
                        if (this.debugLog) {
                            this.logger.info("HttpRefererValidate.onHttpRequest [appName: " + string4 + ", appInstName: " + string5 + "] Session referer is empty and blank referers not allowed. Blocking connection", "vhost", "comment");
                        }
                    } else {
                        stringArray = string3.split(",");
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (this.debugLog) {
                                this.logger.info("HttpRefererValidate.onHttpRequest [appName: " + string4 + ", appInstName: " + string5 + "] checking  " + string7 + " against " + stringArray[i].trim(), "vhost", "comment");
                            }
                            if (stringArray[i].trim().startsWith("*")) {
                                String string9 = stringArray[i].trim().substring(1);
                                if (!string7.endsWith(string9)) continue;
                                if (this.debugLog) {
                                    this.logger.info("HttpRefererValidate.onHttpRequest [appName: " + string4 + ", appInstName: " + string5 + "] match found. referer: " + string7 + " against " + stringArray[i].trim(), "vhost", "comment");
                                }
                                bl2 = true;
                                break;
                            }
                            if (!string7.equalsIgnoreCase(stringArray[i].trim())) continue;
                            if (this.debugLog) {
                                this.logger.info("HttpRefererValidate.onHttpRequest [appName: " + string4 + ", appInstName: " + string5 + "] match found. referer: " + string7 + " against " + stringArray[i].trim(), "vhost", "comment");
                            }
                            bl2 = true;
                            break;
                        }
                        if (bl2) {
                            l = wMSProperties.getPropertyLong("refererValidateSessionValidDuration", l);
                            String string10 = RefererValidate.decodeStreamName(((ApplicationInstance)iApplicationInstance).internalResolvePlayAlias(string2));
                            this.addNewSession(string4, string5, string10, string8, (String)object2, string7, l);
                        }
                    }
                }
            }
        }
        boolean bl4 = bl = wMSProperties != null ? wMSProperties.getPropertyBoolean("refererValidateReturn404OnNotValidated", true) : true;
        if (!bl2 && bl) {
            iHTTPResponse.setResponseCode(404);
            return;
        }
        string = wMSProperties.getPropertyStr("refererValidateImagePath", "");
        if (!StringUtils.isEmpty((String)string)) {
            string = this.decodeImagePath(iApplicationInstance, RefererValidate.decodeStreamName(string2), bl2, string);
            byArray = this.getImageBytes(string);
        }
        String string11 = "image/gif";
        if (byArray != null) {
            string11 = this.getMimeType(string);
        } else {
            byArray = PIXEL_BYTES;
        }
        try {
            iHTTPResponse.setHeader("Content-Type", string11);
            object = iHTTPResponse.getOutputStream();
            ((OutputStream)object).write(byArray);
        }
        catch (Exception exception) {
            this.logger.error("HttpRefererValidateonHttpRequest Exception: " + exception.toString(), (Throwable)exception);
        }
    }

    public void onUnbind(IVHost iVHost, HostPort hostPort) {
        if (this.validator == this) {
            if (this.timer != null) {
                this.timer.cancel();
            }
            this.timer = null;
            this.sessionInfoList = null;
            this.lock = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewSession(String string, String string2, String string3, String string4, String string5, String string6, long l) {
        Object object = this.validator.lock;
        synchronized (object) {
            SessionInfo sessionInfo = new SessionInfo();
            sessionInfo.setAppName(string);
            sessionInfo.setAppInstName(string2);
            sessionInfo.setStreamName(string3);
            sessionInfo.setIpAddress(string4);
            sessionInfo.setQueryStr(string5);
            if (this.debugLog) {
                this.logger.info("HttpRefererValidate.onHttpRequest storing in [" + this.validator.sessionInfoList + "]", "vhost", "comment");
            }
            if (this.validator.sessionInfoList.contains(sessionInfo)) {
                sessionInfo = this.validator.sessionInfoList.get(this.validator.sessionInfoList.indexOf(sessionInfo));
            } else {
                this.validator.sessionInfoList.add(sessionInfo);
            }
            if (this.debugLog) {
                this.logger.info("HttpRefererValidate.onHttpRequest [appName: " + string + ", appInstName: " + string2 + "] saving sessionInfo " + sessionInfo, "vhost", "comment");
            }
            if (string6 != null) {
                sessionInfo.setReferer(string6);
                if (this.debugLog) {
                    this.logger.info("HttpRefererValidate.onHttpRequest referer set is [" + sessionInfo.getReferer() + "]", "vhost", "comment");
                }
            }
            sessionInfo.setExpireTime(System.currentTimeMillis() + l);
            if (this.debugLog) {
                this.logger.info("HttpRefererValidate.onHttpRequest expiry time for the session now [" + System.currentTimeMillis() + "] duration is [" + l + "] session expire is [" + sessionInfo.getExpireTime() + "]", "vhost", "comment");
                this.logger.info("HttpRefererValidate.onHttpRequest size of session list now [" + this.validator.sessionInfoList.size() + "]", "vhost", "comment");
            }
        }
    }

    private String getMimeType(String string) {
        String string2 = "image/gif";
        if (!StringUtils.isEmpty((String)string)) {
            try {
                string2 = Files.probeContentType(Paths.get(string, new String[0]));
            }
            catch (IOException iOException) {
                this.logger.error("HttpRefererValidategetMimeType IOException: " + iOException.toString(), (Throwable)iOException);
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getImageBytes(String string) {
        File file = new File(string);
        byte[] byArray = null;
        if (file.exists() && file.isFile()) {
            FileInputStream fileInputStream = null;
            try {
                byArray = new byte[(int)file.length()];
                fileInputStream = new FileInputStream(file);
                fileInputStream.read(byArray);
            }
            catch (Exception exception) {
                this.logger.error("HttpRefererValidate.getImageBytes Exception: " + exception.toString(), (Throwable)exception);
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                fileInputStream = null;
            }
        }
        return byArray;
    }

    private String decodeImagePath(IApplicationInstance iApplicationInstance, String string, boolean bl, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("com.wowza.wms.context.VHost", iApplicationInstance.getVHost().getName());
        hashMap.put("com.wowza.wms.context.VHostConfigHome", iApplicationInstance.getVHost().getHomePath());
        hashMap.put("com.wowza.wms.context.Application", iApplicationInstance.getApplication().getName());
        hashMap.put("com.wowza.wms.context.ApplicationInstance", iApplicationInstance.getName());
        hashMap.put("com.wowza.wms.context.Stream", string);
        hashMap.put("VHost.Name", iApplicationInstance.getVHost().getName());
        hashMap.put("Application.Name", iApplicationInstance.getApplication().getName());
        hashMap.put("ApplicationInstance.Name", iApplicationInstance.getName());
        hashMap.put("AppInstance.Name", iApplicationInstance.getName());
        hashMap.put("Stream.Name", string);
        hashMap.put("Valid", Boolean.toString(bl));
        string2 = SystemUtils.expandEnvironmentVariables((String)string2, hashMap);
        return string2;
    }

    class ExpireTimer
    extends TimerTask {
        private IVHost vhost;

        public ExpireTimer(IVHost iVHost) {
            this.vhost = iVHost;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (HttpRefererValidate.this.debugLog) {
                HttpRefererValidate.this.logger.info("HttpRefererValidate SessionTimer run()", "vhost", "comment");
            }
            TreeSet treeSet = new TreeSet();
            Object object = HttpRefererValidate.this.validator.lock;
            synchronized (object) {
                treeSet.addAll(HttpRefererValidate.this.validator.sessionInfoList);
                while (!treeSet.isEmpty()) {
                    SessionInfo sessionInfo = (SessionInfo)treeSet.first();
                    if (System.currentTimeMillis() < sessionInfo.getExpireTime()) {
                        if (!HttpRefererValidate.this.debugLog) break;
                        HttpRefererValidate.this.logger.info("HttpRefererValidate SessionTimer check : current time [" + System.currentTimeMillis() + "] expire time [" + sessionInfo.getExpireTime() + "]", "vhost", "comment");
                        break;
                    }
                    this.checkSession(sessionInfo);
                    treeSet.remove(sessionInfo);
                    if (!HttpRefererValidate.this.debugLog) continue;
                    HttpRefererValidate.this.logger.info("HttpRefererValidate SessionTimer removing session: [" + sessionInfo.toString() + "]", "vhost", "comment");
                }
            }
        }

        private void checkSession(SessionInfo sessionInfo) {
            block8: {
                IClient iClient;
                Object object;
                Object object2;
                IApplicationInstance iApplicationInstance;
                IApplication iApplication;
                boolean bl = true;
                if (this.vhost == null || !this.vhost.isApplicationLoaded(sessionInfo.getAppName()) || (iApplication = this.vhost.getApplication(sessionInfo.getAppName())) == null || !iApplication.isAppInstanceLoaded(sessionInfo.getAppInstName()) || (iApplicationInstance = iApplication.getAppInstance(sessionInfo.getAppInstName())) == null) break block8;
                List list = iApplicationInstance.getPlayStreamsByName(sessionInfo.getStreamName());
                if (list != null) {
                    object2 = list.iterator();
                    while (object2.hasNext()) {
                        object = (IMediaStream)object2.next();
                        iClient = object.getClient();
                        if (iClient == null || !iClient.getIp().equalsIgnoreCase(sessionInfo.getIpAddress())) continue;
                        bl = false;
                        break;
                    }
                }
                if (bl && (object2 = iApplicationInstance.getHTTPStreamerSessions(sessionInfo.getStreamName())) != null) {
                    object = object2.iterator();
                    while (object.hasNext()) {
                        iClient = (IHTTPStreamerSession)object.next();
                        if (!iClient.getIpAddress().equalsIgnoreCase(sessionInfo.getIpAddress())) continue;
                        bl = false;
                        break;
                    }
                }
                if (bl && (object2 = iApplicationInstance.getRTPSessions(sessionInfo.getStreamName())) != null) {
                    object = object2.iterator();
                    while (object.hasNext()) {
                        iClient = (RTPSession)object.next();
                        if (!iClient.getIp().equalsIgnoreCase(sessionInfo.getIpAddress())) continue;
                        bl = false;
                        break;
                    }
                }
                if (!bl) {
                    long l = System.currentTimeMillis() + iApplicationInstance.getProperties().getPropertyLong("refererValidateSessionValidDuration", 600000L);
                    sessionInfo.setExpireTime(l);
                } else {
                    HttpRefererValidate.this.validator.sessionInfoList.remove(sessionInfo);
                }
            }
        }
    }
}

