/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin;

import com.wowza.util.StringUtils;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.application.ApplicationInstance;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.client.IClient;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.plugin.HttpRefererValidate;
import com.wowza.wms.plugin.SessionInfo;
import com.wowza.wms.request.RequestFunction;
import com.wowza.wms.rtp.model.RTPSession;
import com.wowza.wms.rtp.model.RTPUrl;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStream;
import com.wowza.wms.util.ModuleUtils;
import com.wowza.wms.util.SecurityUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RefererValidate
extends ModuleBase {
    public static final String MODULE_NAME = "ModuleRefererValidate";
    public static final String PROP_NAME_PREFIX = "refererValidate";
    public static final boolean ALLOW_BLANK_REFERERS = false;
    public static final long SESSION_VALID_DURATION_DEFAULT = 600000L;
    private static final String PROP_PUBLISH_ALLOWED_ENCODERS = "securityPublishValidEncoders";
    private String validFlashVersionsStr = "Wirecast/|FME/|FMLE/|Wowza GoCoder*|Lavf/|UA Teradek/|KulaByte/|HaivisionKB/|VidBlaster/|XSplit/|PESA|makitoX/|Elemental Live/".contains("Wowza GoCoder") ? "Wirecast/|FME/|FMLE/|Wowza GoCoder*|Lavf/|UA Teradek/|KulaByte/|HaivisionKB/|VidBlaster/|XSplit/|PESA|makitoX/|Elemental Live/" : "Wirecast/|FME/|FMLE/|Wowza GoCoder*|Lavf/|UA Teradek/|KulaByte/|HaivisionKB/|VidBlaster/|XSplit/|PESA|makitoX/|Elemental Live/|Wowza GoCoder";
    private List<String> validFlashVersions = new ArrayList<String>();
    private WMSLogger logger = null;
    private HttpRefererValidate validator = null;
    private IApplicationInstance appInstance;
    private boolean debugLog = false;

    public void onAppStart(IApplicationInstance iApplicationInstance) {
        this.logger = WMSLoggerFactory.getLoggerObj((IApplicationInstance)iApplicationInstance);
        this.appInstance = iApplicationInstance;
        this.validFlashVersionsStr = iApplicationInstance.getProperties().getPropertyStr(PROP_PUBLISH_ALLOWED_ENCODERS, this.validFlashVersionsStr);
        this.validFlashVersions = SecurityUtils.parseValidFlashStrings((String)this.validFlashVersionsStr);
        this.validator = (HttpRefererValidate)((Object)iApplicationInstance.getVHost().getProperties().get((Object)"httpRefererValidate"));
        this.debugLog = iApplicationInstance.getProperties().getPropertyBoolean("refererValidateDebugLog", this.debugLog);
        if (this.logger.isDebugEnabled()) {
            this.debugLog = true;
        }
    }

    public void onConnect(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        String string = iClient.getIp();
        String string2 = iClient.getFlashVer();
        boolean bl = SecurityUtils.isValidFlashVersion((String)string2, this.validFlashVersions);
        if (bl) {
            if (this.debugLog) {
                this.logger.info("ModuleRefererValidate: Client is publisher. Passing further checks to ModuleCoreSecurity. " + string + ": " + string2, "application", "comment");
            }
            return;
        }
        if (!this.checkSession(string, null, StringUtils.isEmpty((String)iClient.getReferrer()))) {
            iClient.rejectConnection();
            if (this.debugLog) {
                this.logger.info("ModuleRefererValidate: Client connection rejected. " + string, "application", "comment");
            }
        }
    }

    public void play(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        String string;
        String string2;
        String string3 = iClient.getIp();
        if (this.checkSession(string3, string2 = ((ApplicationInstance)this.appInstance).internalResolvePlayAlias(string = aMFDataList.getString(3), iClient), StringUtils.isEmpty((String)iClient.getReferrer()))) {
            this.invokePrevious(iClient, requestFunction, aMFDataList);
        } else {
            IMediaStream iMediaStream = RefererValidate.getStream((IClient)iClient, (RequestFunction)requestFunction);
            RefererValidate.sendStreamOnStatusError((IMediaStream)iMediaStream, (String)"NetStream.Play.Failed", (String)("Playback not allowed for " + string));
            if (this.debugLog) {
                this.logger.info("ModuleRefererValidate: Client stream play rejected. " + string3 + ": " + string, "application", "comment");
            }
        }
    }

    public void onHTTPSessionCreate(IHTTPStreamerSession iHTTPStreamerSession) {
        String string = iHTTPStreamerSession.getIpAddress();
        String string2 = iHTTPStreamerSession.getStreamName();
        if (this.debugLog) {
            this.logger.info("ModuleRefererValidate: http request ipAddress [" + string + "]", "application", "comment");
            this.logger.info("ModuleRefererValidate: http request streamName [" + string2 + "]", "application", "comment");
        }
        if (!this.checkSession(string, string2, StringUtils.isEmpty((String)iHTTPStreamerSession.getReferrer()))) {
            iHTTPStreamerSession.rejectSession();
            if (this.debugLog) {
                this.logger.info("ModuleRefererValidate: http stream play rejected. " + string + ": " + string2, "application", "comment");
            }
        }
    }

    public void onRTPSessionCreate(RTPSession rTPSession) {
        String string = rTPSession.getIp();
        String string2 = rTPSession.getUserAgent();
        boolean bl = SecurityUtils.isValidFlashVersion((String)string2, this.validFlashVersions);
        if (bl) {
            if (this.debugLog) {
                this.logger.info("ModuleRefererValidate: Client is publisher. Passing further checks to ModuleCoreSecurity. " + string + ": " + string2, "application", "comment");
            }
            return;
        }
        String string3 = rTPSession.getUri();
        RTPUrl rTPUrl = new RTPUrl(string3);
        String string4 = rTPUrl.getStreamName();
        String string5 = ((ApplicationInstance)this.appInstance).internalResolvePlayAlias(string4, rTPSession);
        if (this.checkSession(string, string5, StringUtils.isEmpty((String)rTPSession.getReferrer()))) {
            rTPSession.rejectSession();
            if (this.debugLog) {
                this.logger.info("ModuleRefererValidate: rtp stream play rejected. " + string + ": " + string4, "application", "comment");
            }
        }
    }

    private boolean checkSession(String string, String string2, boolean bl) {
        if (this.debugLog) {
            this.logger.info("ModuleRefererValidate.checkSession [" + string + ": " + string2 + "]", "application", "comment");
        }
        boolean bl2 = false;
        if (string2 != null) {
            string2 = RefererValidate.decodeStreamName(string2);
        }
        if (this.validator == null) {
            this.logger.warn("ModuleRefererValidate.checkSession HTTPProvider, HttpRefererValidate, not enabled for VHost. Allowing connection", "application", "comment");
            return true;
        }
        List<SessionInfo> list = this.validator.getSessionInfoList();
        Iterator<SessionInfo> iterator = list.iterator();
        if (this.debugLog) {
            this.logger.info("ModuleRefererValidate.checkSession size of valid sessions is [" + list.size() + "]");
        }
        while (iterator.hasNext()) {
            SessionInfo sessionInfo = iterator.next();
            if (this.debugLog) {
                this.logger.info("ModuleRefererValidate.checkSession : session info IPAddress [" + sessionInfo.getIpAddress() + "]", "application", "comment");
                this.logger.info("ModuleRefererValidate.checkSession : session info Referer [" + sessionInfo.getReferer() + "]", "application", "comment");
                this.logger.info("ModuleRefererValidate.checkSession : session info QueryStr [" + sessionInfo.getQueryStr() + "]", "application", "comment");
                this.logger.info("ModuleRefererValidate.checkSession : session info ExpireTime [" + sessionInfo.getExpireTime() + "]", "application", "comment");
                this.logger.info("ModuleRefererValidate.checkSession : session info StreamName [" + sessionInfo.getStreamName() + "]", "application", "comment");
                this.logger.info("ModuleRefererValidate.checkSession : session info AppInstance [" + sessionInfo.getAppInstName() + "]", "application", "comment");
                this.logger.info("ModuleRefererValidate.checkSession : session info AppName [" + sessionInfo.getAppName() + "]", "application", "comment");
            }
            if (this.debugLog) {
                this.logger.info("ModuleRefererValidate.checkSession [session: " + sessionInfo + "] [ running appInstance: '" + this.appInstance.getName() + "'] [ running appName: '" + this.appInstance.getApplication().getName() + "'] [ session appInstance: '" + sessionInfo.getAppInstName() + "'] [ session appName: '" + sessionInfo.getAppName() + "'] ", "application", "comment");
            }
            if (!this.appInstance.getApplication().getName().equals(sessionInfo.getAppName())) {
                if (!this.debugLog) continue;
                this.logger.info("ModuleRefererValidate.checkSession [session: " + sessionInfo + "] [ running appName does not equal session appName ]", "application", "comment");
                continue;
            }
            if (!this.appInstance.getName().equals(sessionInfo.getAppInstName())) {
                if (!this.debugLog) continue;
                this.logger.info("ModuleRefererValidate.checkSession [session: " + sessionInfo + "] [ running appInstance does not equal session appInstance ]", "application", "comment");
                continue;
            }
            if (this.debugLog) {
                this.logger.info("ModuleRefererValidate.checkSession [session: " + sessionInfo + "]", "application", "comment");
                this.logger.info("ModuleRefererValidate.checkSession [session: " + sessionInfo + "] [ running ipAddress: '" + string + "' ] [ session ipAddress: '" + sessionInfo.getIpAddress() + "' ]", "application", "comment");
                this.logger.info("ModuleRefererValidate.checkSession [session: " + sessionInfo + "] [ running streamName: '" + string2 + "'] [ session streamName: '" + sessionInfo.getStreamName() + "']", "application", "comment");
            }
            if (!string.equalsIgnoreCase(sessionInfo.getIpAddress())) continue;
            if (string2 == null) {
                if (this.debugLog) {
                    this.logger.info("ModuleRefererValidate.checkSession [ipAddress passed. streamName not checked. session: " + sessionInfo + "]", "application", "comment");
                }
                bl2 = true;
                break;
            }
            if (string2.equalsIgnoreCase(sessionInfo.getStreamName())) {
                if (this.debugLog) {
                    this.logger.info("ModuleRefererValidate.checkSession [ipAddress passed. streamName passed. session: " + sessionInfo + "]", "application", "comment");
                }
                bl2 = true;
                break;
            }
            this.logger.info("ModuleRefererValidate.checkSession [session: " + sessionInfo + "] [ running streamName does not equal session streamName ]", "application", "comment");
        }
        if (!bl2 && bl && this.appInstance.getProperties().getPropertyBoolean("refererValidateAllowBlankReferers", false)) {
            long l = this.appInstance.getProperties().getPropertyLong("refererValidateSessionValidDuration", 600000L);
            this.validator.addNewSession(this.appInstance.getApplication().getName(), this.appInstance.getName(), string2, string, null, null, l);
            bl2 = true;
            if (this.debugLog) {
                this.logger.info("ModuleRefererValidate.checkSession [appName: " + this.appInstance.getApplication().getName() + ", appInstName: " + this.appInstance.getName() + ", streamName: " + string2 + ", ipAddress: " + string + "] Session referer is empty and blank referers allowed. Allowing connection", "vhost", "comment");
            }
        }
        if (this.debugLog) {
            this.logger.info("ModuleRefererValidate.checkSession end [ passFlag: " + bl2 + "] ", "application", "comment");
        }
        return bl2;
    }

    public static String decodeStreamName(String string) {
        String string2 = MediaStream.BASE_STREAM_EXT;
        if (string != null) {
            String[] stringArray = ModuleUtils.decodeStreamExtension((String)string, (String)string2);
            string = stringArray[0];
            string2 = stringArray[1];
            boolean bl = string.indexOf("://") >= 0;
            int n = string.indexOf("?");
            if (!bl && n >= 0) {
                string = string.substring(0, n);
            }
        }
        return string;
    }
}

