/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.s3upload;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.amazonaws.event.ProgressEvent;
import com.amazonaws.event.ProgressEventType;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.AccessControlList;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.Grantee;
import com.amazonaws.services.s3.model.GroupGrantee;
import com.amazonaws.services.s3.model.HeadBucketRequest;
import com.amazonaws.services.s3.model.HeadBucketResult;
import com.amazonaws.services.s3.model.ListMultipartUploadsRequest;
import com.amazonaws.services.s3.model.MultipartUploadListing;
import com.amazonaws.services.s3.model.Permission;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.transfer.PersistableTransfer;
import com.amazonaws.services.s3.transfer.PersistableUpload;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerBuilder;
import com.amazonaws.services.s3.transfer.Upload;
import com.amazonaws.services.s3.transfer.internal.S3SyncProgressListener;
import com.wowza.util.JSON;
import com.wowza.util.StringUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaWriterActionNotify;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ModuleS3Upload
extends ModuleBase {
    public static final String MODULE_NAME = "ModuleS3Upload";
    public static final String PROP_NAME_PREFIX = "s3Upload";
    private WMSLogger logger = null;
    private IApplicationInstance appInstance = null;
    private TransferManager transferManager = null;
    private AccessControlList acl = null;
    private CannedAccessControlList cannedAcl = null;
    private String accessKey = null;
    private String secretKey = null;
    private String awsProfile = null;
    private String awsProfilePath = null;
    private String bucketName = null;
    private String filePrefix = null;
    private String endpoint = null;
    private String regionName = null;
    private File storageDir = null;
    private Map<String, Timer> uploadTimers = new HashMap<String, Timer>();
    private List<String> currentUploads = new ArrayList<String>();
    private boolean checkBucket = true;
    private boolean useDefaultRegion = true;
    private boolean allowBucketRegionOverride = true;
    private boolean debugLog = false;
    private boolean shuttingDown = false;
    private boolean resumeUploads = true;
    private boolean versionFile = false;
    private boolean stripRecorderVersioning = true;
    private boolean deleteOriginalFiles = false;
    private boolean restartFailedUploads = true;
    private long restartFailedUploadsTimeout = 60000L;
    private long uploadDelay = 0L;
    private long lastTouch = -1L;
    private long touchTimeout = 2500L;
    private Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAppStart(IApplicationInstance iApplicationInstance) {
        this.appInstance = iApplicationInstance;
        this.logger = WMSLoggerFactory.getLoggerObj((IApplicationInstance)iApplicationInstance);
        this.logger.info("ModuleS3Upload.onAppStart [" + iApplicationInstance.getContextStr() + " : build #55]");
        this.touchTimeout = iApplicationInstance.getApplicationInstanceTouchTimeout() / 2;
        try {
            HeadBucketResult headBucketResult;
            String string;
            CannedAccessControlList cannedAccessControlList2;
            String string2;
            WMSProperties wMSProperties = iApplicationInstance.getProperties();
            String string3 = iApplicationInstance.decodeStorageDir(iApplicationInstance.getStreamRecorderProperties().getPropertyStr("streamRecorderOutputPath", iApplicationInstance.getStreamStorageDir()));
            this.storageDir = new File(string3);
            this.accessKey = wMSProperties.getPropertyStr("s3UploadAccessKey", this.accessKey);
            this.secretKey = wMSProperties.getPropertyStr("s3UploadSecretKey", this.secretKey);
            this.awsProfile = wMSProperties.getPropertyStr("s3UploadAwsProfile", this.awsProfile);
            this.awsProfilePath = wMSProperties.getPropertyStr("s3UploadAwsProfilePath", this.awsProfilePath);
            this.bucketName = wMSProperties.getPropertyStr("s3UploadBucketName", this.bucketName);
            this.filePrefix = iApplicationInstance.decodeStorageDir(wMSProperties.getPropertyStr("s3UploadFilePrefix", this.filePrefix));
            this.regionName = wMSProperties.getPropertyStr("s3UploadRegion", this.regionName);
            if (StringUtils.isEmpty((String)this.regionName)) {
                this.endpoint = wMSProperties.getPropertyStr("s3UploadEndpoint", this.endpoint);
                this.regionName = this.getRegion();
            }
            this.useDefaultRegion = wMSProperties.getPropertyBoolean("s3UploadUseDefaultRegion", this.useDefaultRegion);
            this.allowBucketRegionOverride = wMSProperties.getPropertyBoolean("s3UploadAllowBucketRegionOverride", this.allowBucketRegionOverride);
            this.checkBucket = wMSProperties.getPropertyBoolean("s3UploadCheckBucket", this.checkBucket);
            this.debugLog = wMSProperties.getPropertyBoolean("s3UploadDebugLog", this.debugLog);
            this.resumeUploads = wMSProperties.getPropertyBoolean("s3UploadResumeUploads", this.resumeUploads);
            this.restartFailedUploads = wMSProperties.getPropertyBoolean("s3UploadRestartFailedUploads", this.restartFailedUploads);
            this.restartFailedUploadsTimeout = wMSProperties.getPropertyLong("s3UploadRestartFailedUploadTimeout", this.restartFailedUploadsTimeout);
            this.versionFile = wMSProperties.getPropertyBoolean("s3UploadVersionFile", this.versionFile);
            this.stripRecorderVersioning = wMSProperties.getPropertyBoolean("s3UploadStripRecorderVersioning", this.stripRecorderVersioning);
            this.deleteOriginalFiles = wMSProperties.getPropertyBoolean("s3UploadDeletOriginalFiles", this.deleteOriginalFiles);
            this.deleteOriginalFiles = wMSProperties.getPropertyBoolean("s3UploadDeleteOriginalFiles", this.deleteOriginalFiles);
            this.uploadDelay = wMSProperties.getPropertyLong("s3UploadDelay", this.uploadDelay);
            String string4 = wMSProperties.getPropertyStr("s3UploadACLGroupGranteeUri");
            String string5 = wMSProperties.getPropertyStr("s3UploadACLPermissionRule");
            GroupGrantee groupGrantee = null;
            Permission permission = null;
            if (!StringUtils.isEmpty((String)string4)) {
                groupGrantee = GroupGrantee.parseGroupGrantee((String)string4);
            }
            if (!StringUtils.isEmpty((String)string5)) {
                permission = Permission.parsePermission((String)string5.toUpperCase());
            }
            if (groupGrantee != null && permission != null) {
                this.acl = new AccessControlList();
                this.acl.grantPermission((Grantee)groupGrantee, permission);
            }
            if (!StringUtils.isEmpty((String)(string2 = wMSProperties.getPropertyStr("s3UploadCannedAcl")))) {
                for (CannedAccessControlList cannedAccessControlList2 : CannedAccessControlList.values()) {
                    if (!cannedAccessControlList2.toString().equals(string2)) continue;
                    this.cannedAcl = cannedAccessControlList2;
                    break;
                }
            }
            AmazonS3 amazonS3 = null;
            AmazonS3ClientBuilder amazonS3ClientBuilder = AmazonS3ClientBuilder.standard();
            Regions regions = null;
            try {
                regions = Regions.fromName((String)this.regionName);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (this.useDefaultRegion) {
                    Regions regions2 = regions = Regions.getCurrentRegion() != null ? Regions.fromName((String)Regions.getCurrentRegion().getName()) : Regions.DEFAULT_REGION;
                    if (regions != null) {
                        this.regionName = regions.getName();
                    }
                }
            }
            finally {
                if (regions != null) {
                    amazonS3ClientBuilder.withRegion(regions);
                    if (this.allowBucketRegionOverride) {
                        amazonS3ClientBuilder.withForceGlobalBucketAccessEnabled(Boolean.valueOf(true));
                    }
                }
            }
            cannedAccessControlList2 = null;
            if (!StringUtils.isEmpty((String)this.accessKey) && !StringUtils.isEmpty((String)this.secretKey)) {
                this.logger.info("ModuleS3Upload.onAppStart: [" + iApplicationInstance.getContextStr() + "] using supplied aws credentials", "application", "comment");
                cannedAccessControlList2 = new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(this.accessKey, this.secretKey));
            } else if (!StringUtils.isEmpty((String)this.awsProfile)) {
                this.logger.info("ModuleS3Upload.onAppStart: [" + iApplicationInstance.getContextStr() + "] using aws profile: " + this.awsProfile, "application", "comment");
                cannedAccessControlList2 = StringUtils.isEmpty((String)this.awsProfilePath) ? new ProfileCredentialsProvider(this.awsProfile) : new ProfileCredentialsProvider(this.awsProfilePath, this.awsProfile);
            } else {
                this.logger.info("ModuleS3Upload.onAppStart: [" + iApplicationInstance.getContextStr() + "] using default aws credentials provider chain", "application", "comment");
            }
            if (cannedAccessControlList2 != null) {
                amazonS3ClientBuilder.withCredentials((AWSCredentialsProvider)cannedAccessControlList2);
            }
            amazonS3 = (AmazonS3)amazonS3ClientBuilder.build();
            if (this.checkBucket && !(string = (headBucketResult = amazonS3.headBucket(new HeadBucketRequest(this.bucketName))).getBucketRegion()).equalsIgnoreCase(this.regionName)) {
                this.logger.warn("ModuleS3Upload.onAppStart: [" + iApplicationInstance.getContextStr() + "] bucket region doesn't match configured region. (b:c)[" + string + ":" + this.regionName + "]", "application", "comment");
            }
            this.transferManager = TransferManagerBuilder.standard().withS3Client(amazonS3).build();
            this.logger.info("ModuleS3Upload.onAppStart [" + iApplicationInstance.getContextStr() + "] Local Storage Dir: " + string3 + ", S3 Bucket Name: " + this.bucketName + ", File Prefix: " + this.filePrefix + ", Resume Uploads: " + this.resumeUploads + ", Delete Original Files: " + this.deleteOriginalFiles + ", Version Files: " + this.versionFile + ", Upload Delay: " + this.uploadDelay, "application", "comment");
            iApplicationInstance.getVHost().getThreadPool().execute(new Runnable(){

                @Override
                public void run() {
                    ModuleS3Upload.this.resumeUploads();
                }
            });
        }
        catch (IllegalStateException illegalStateException) {
            this.logger.error("ModuleS3Upload.onAppStart [" + iApplicationInstance.getContextStr() + "] Illegal State Exception thrown. The installed version of AWS SDK may not be compatible with this version of Wowza Streaming Engine. Please check and upgrade your version of AWS SDK.", (Throwable)illegalStateException);
        }
        catch (AmazonServiceException amazonServiceException) {
            int n = amazonServiceException.getStatusCode();
            String string = amazonServiceException.getErrorMessage();
            this.logger.warn("ModuleS3Upload.onAppStart: [" + iApplicationInstance.getContextStr() + "] missing S3 bucket: " + this.bucketName + ", S3 returned status: " + n + ", message: " + string, "application", "comment");
        }
        catch (Exception exception) {
            this.logger.error("ModuleS3Upload.onAppStart [" + iApplicationInstance.getContextStr() + "] exception: " + exception.getMessage(), (Throwable)exception);
        }
        catch (Throwable throwable) {
            this.logger.error("ModuleS3Upload.onAppStart [" + iApplicationInstance.getContextStr() + "] throwable exception: " + throwable.getMessage(), throwable);
        }
        iApplicationInstance.addMediaWriterListener((IMediaWriterActionNotify)new WriteListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAppStop(IApplicationInstance iApplicationInstance) {
        this.logger.info("ModuleS3Upload.onAppStop [" + iApplicationInstance.getContextStr() + "]", "application", "comment");
        Object object = this.lock;
        synchronized (object) {
            this.shuttingDown = true;
            Iterator<String> iterator = this.uploadTimers.keySet().iterator();
            while (iterator.hasNext()) {
                String string = iterator.next();
                Timer timer = this.uploadTimers.get(string);
                if (timer != null) {
                    timer.cancel();
                }
                if (this.debugLog) {
                    this.logger.info("ModuleS3Upload.onAppStop  stopping pending upload [" + iApplicationInstance.getContextStr() + "/" + string + "]", "application", "comment");
                }
                iterator.remove();
            }
        }
        try {
            if (this.transferManager != null) {
                this.transferManager.shutdownNow(false);
            }
        }
        catch (Exception exception) {
            this.logger.error("ModuleS3Upload.onAppStop [" + iApplicationInstance.getContextStr() + "] exception: " + exception.getMessage(), (Throwable)exception);
        }
    }

    private void resumeUploads() {
        if (this.debugLog) {
            this.logger.info("ModuleS3Upload.resumeUploads " + (this.resumeUploads ? "resuming" : "aborting") + " unfinished Uploads [" + this.appInstance.getContextStr() + "]", "application", "comment");
        }
        if (this.transferManager != null && !this.resumeUploads) {
            this.transferManager.abortMultipartUploads(this.bucketName, new Date());
        }
        List<File> list = this.getMatchingFiles(this.storageDir, ".upload");
        for (File file : list) {
            if (!this.resumeUploads) {
                file.delete();
                continue;
            }
            String string = this.getMediaName(file.getPath());
            this.startUpload(string, this.uploadDelay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startUpload(String string, long l) {
        Object object = this.lock;
        synchronized (object) {
            Timer timer = this.uploadTimers.remove(string);
            if (timer != null) {
                timer.cancel();
            }
            long l2 = this.getFileAge(string);
            if (l > 0L && l2 != -1L && l2 < l) {
                timer = new Timer("UploadTimer: [" + this.appInstance.getContextStr() + "/" + string + "]");
                long l3 = Math.min(l - l2, this.touchTimeout);
                timer.schedule((TimerTask)new UploadTask(string, l, l2), l3, l3 / 2L);
                this.uploadTimers.put(string, timer);
                if (this.debugLog) {
                    this.logger.info("ModuleS3Upload.startUpload (delayed) for [" + this.appInstance.getContextStr() + "/" + string + "] age: " + l2 + ", delay: " + l + ", timerDelay: " + l3, "application", "comment");
                }
            } else {
                if (this.debugLog) {
                    this.logger.info("ModuleS3Upload.startUpload (now) for [" + this.appInstance.getContextStr() + "/" + string + "] age: " + l2 + ", delay: " + l, "application", "comment");
                }
                this.startUpload(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void startUpload(String string) {
        this.touchAppInstance();
        File file = new File(this.storageDir, string + ".upload");
        if (file == null || !file.exists()) {
            return;
        }
        if (this.transferManager != null) {
            Upload upload = null;
            FileInputStream fileInputStream = null;
            Object object = null;
            try {
                if (file.length() == 0L) {
                    File file2;
                    if (this.debugLog) {
                        this.logger.info("ModuleS3Upload.startUpload new or single part upload for [" + this.appInstance.getContextStr() + "/" + string + "]", "application", "comment");
                    }
                    if ((file2 = new File(this.storageDir, string)).exists()) {
                        object = string;
                        if (!StringUtils.isEmpty((String)this.filePrefix)) {
                            object = this.filePrefix + (this.filePrefix.endsWith("/") ? "" : "/") + (String)object;
                        }
                        if (this.versionFile) {
                            object = this.getMediaNameVersion((String)object);
                        }
                        PutObjectRequest putObjectRequest = new PutObjectRequest(this.bucketName, (String)object, file2);
                        if (this.acl != null) {
                            putObjectRequest.withAccessControlList(this.acl);
                        } else if (this.cannedAcl != null) {
                            putObjectRequest.withCannedAcl(this.cannedAcl);
                        }
                        upload = this.transferManager.upload(putObjectRequest);
                    } else {
                        this.logger.warn("ModuleS3Upload.startUpload mediaFile doesn't exist [" + this.appInstance.getContextStr() + "/" + string + "]", "application", "comment");
                        file.delete();
                    }
                } else {
                    if (this.debugLog) {
                        this.logger.info("ModuleS3Upload.startUpload resuming multipart upload for [" + this.appInstance.getContextStr() + "/" + string + "]", "application", "comment");
                    }
                    fileInputStream = new FileInputStream(file);
                    PersistableUpload persistableUpload = (PersistableUpload)PersistableTransfer.deserializeFrom((InputStream)fileInputStream);
                    upload = this.transferManager.resumeUpload(persistableUpload);
                    JSON jSON = new JSON(persistableUpload.serialize());
                    object = jSON.getString("key");
                }
                if (upload == null) return;
                this.currentUploads.add((String)object);
                upload.addProgressListener((com.amazonaws.event.ProgressListener)new ProgressListener(string, (String)object));
                return;
            }
            catch (Exception exception) {
                this.logger.error("ModuleS3Upload.startUpload error starting or resuming upload: [" + this.appInstance.getContextStr() + "/" + file.getName() + "]", (Throwable)exception);
                return;
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        this.logger.warn("ModuleS3Upload.startUpload problem starting or resuming upload: [" + this.appInstance.getContextStr() + "/" + file.getName() + "] Amazon S3 TransferManager not running.");
    }

    private List<File> getMatchingFiles(File file, String string) {
        ArrayList<File> arrayList = new ArrayList<File>();
        File[] fileArray = file.listFiles(new MyFilter(string));
        if (fileArray != null && fileArray.length > 0) {
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    arrayList.addAll(this.getMatchingFiles(file2, string));
                    continue;
                }
                if (this.debugLog) {
                    this.logger.info("ModuleS3Upload.getMatchingFile add file: " + file2.getName(), "application", "comment");
                }
                arrayList.add(file2);
            }
        }
        Collections.sort(arrayList, new Comparator<File>(){

            @Override
            public int compare(File file, File file2) {
                return Long.valueOf(file.lastModified()).compareTo(file2.lastModified());
            }
        });
        return arrayList;
    }

    private long getFileAge(String string) {
        long l = -1L;
        File file = new File(this.storageDir, string);
        if (file.exists()) {
            l = System.currentTimeMillis() - file.lastModified();
        }
        return l;
    }

    private String getMediaName(String string) {
        String string2 = string.replace(this.storageDir.getPath(), "");
        if (string2.startsWith(File.separator)) {
            string2 = string2.substring(File.separator.length());
        }
        if (string2.endsWith(".upload")) {
            string2 = string2.substring(0, string2.indexOf(".upload"));
        }
        return string2;
    }

    private String getMediaNameVersion(String object) {
        boolean bl;
        Object object2;
        if (this.stripRecorderVersioning) {
            Pattern pattern = Pattern.compile("(.*)(_\\d+)(\\.\\w+)");
            object2 = pattern.matcher((CharSequence)object);
            if (this.debugLog) {
                this.logger.info("ModuleS3Upload.getMediaNameVersion stripRecorderVersioning: " + (String)object + ": " + ((Matcher)object2).toString(), "application", "comment");
            }
            if (((Matcher)object2).matches()) {
                object = ((Matcher)object2).group(1) + ((Matcher)object2).group(3);
                if (this.debugLog) {
                    this.logger.info("ModuleS3Upload.getMediaNameVersion stripRecorderVersioning new mediaName: " + (String)object, "application", "comment");
                }
            }
        }
        if (!(bl = this.doesObjectExistOnS3((String)object))) {
            return object;
        }
        object2 = object;
        String string = object;
        String string2 = "";
        int n = string.lastIndexOf(".");
        if (n >= 0) {
            string2 = string.substring(n);
            string = string.substring(0, n);
        }
        int n2 = 0;
        while (true) {
            object2 = string + "_" + Integer.toString(n2) + string2;
            bl = this.doesObjectExistOnS3((String)object2);
            if (this.debugLog) {
                this.logger.info("ModuleS3Upload.getMediaNameVersion doesObjectExist: " + (String)object2 + ": " + Boolean.toString(bl), "application", "comment");
            }
            if (!bl) break;
            ++n2;
            this.touchAppInstance();
        }
        if (this.debugLog) {
            this.logger.info("ModuleS3Upload.getMediaNameVersion using: " + (String)object2, "application", "comment");
        }
        return object2;
    }

    private boolean doesObjectExistOnS3(String string) {
        ListMultipartUploadsRequest listMultipartUploadsRequest;
        MultipartUploadListing multipartUploadListing;
        AmazonS3 amazonS3 = this.transferManager.getAmazonS3Client();
        boolean bl = this.currentUploads.contains(string);
        if (!bl) {
            bl = amazonS3.doesObjectExist(this.bucketName, string);
        }
        if (!bl && !(multipartUploadListing = amazonS3.listMultipartUploads(listMultipartUploadsRequest = new ListMultipartUploadsRequest(this.bucketName).withPrefix(string))).getMultipartUploads().isEmpty()) {
            bl = true;
        }
        return bl;
    }

    private String getRegion() {
        if (!StringUtils.isEmpty((String)this.regionName)) {
            return this.regionName;
        }
        try {
            Pattern pattern = Pattern.compile("(s3\\.dualstack.|s3\\.|s3-)(.+)\\.amazonaws.com");
            if (!StringUtils.isEmpty((String)this.endpoint)) {
                Matcher matcher = pattern.matcher(this.endpoint);
                if (matcher.matches()) {
                    this.regionName = matcher.group(2);
                }
                if (StringUtils.isEmpty((String)this.regionName)) {
                    this.logger.warn("ModuleS3Upload.getRegion [" + this.appInstance.getContextStr() + "] Unable to extract region name from endpoint. [" + this.endpoint + "]");
                }
            }
        }
        catch (Exception exception) {
            this.logger.warn("ModuleS3Upload.getRegion [" + this.appInstance.getContextStr() + "] Exception throw while trying to extract region name from endpoint. [" + this.endpoint + "]", (Throwable)exception);
        }
        return this.regionName;
    }

    private void touchAppInstance() {
        long l = System.currentTimeMillis();
        if (l - this.touchTimeout >= this.lastTouch) {
            if (this.debugLog) {
                this.logger.info("ModuleS3Upload touching appInstance [" + this.appInstance.getContextStr() + "]", "application", "comment");
            }
            this.appInstance.touch();
            this.lastTouch = l;
        }
    }

    private class ProgressListener
    extends S3SyncProgressListener {
        final String mediaName;
        final String uploadName;

        ProgressListener(String string, String string2) {
            this.mediaName = string;
            this.uploadName = string2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void progressChanged(ProgressEvent progressEvent) {
            if (progressEvent.getEventType().isTransferEvent()) {
                ProgressEventType progressEventType = progressEvent.getEventType();
                switch (progressEventType) {
                    case TRANSFER_COMPLETED_EVENT: {
                        if (ModuleS3Upload.this.debugLog) {
                            ModuleS3Upload.this.logger.info("ModuleS3Upload.ProgressListener.progressChanged [" + ModuleS3Upload.this.appInstance.getContextStr() + "/" + this.mediaName + "] event: " + progressEventType.toString(), "application", "comment");
                        }
                        Object object = ModuleS3Upload.this.lock;
                        synchronized (object) {
                            if (this.uploadName != null) {
                                ModuleS3Upload.this.currentUploads.remove(this.uploadName);
                            }
                            File file = new File(ModuleS3Upload.this.storageDir, this.mediaName + ".upload");
                            file.delete();
                        }
                        if (!ModuleS3Upload.this.deleteOriginalFiles) break;
                        object = new File(ModuleS3Upload.this.storageDir, this.mediaName);
                        ((File)object).delete();
                        break;
                    }
                    case TRANSFER_FAILED_EVENT: {
                        if (ModuleS3Upload.this.debugLog) {
                            ModuleS3Upload.this.logger.warn("ModuleS3Upload.ProgressListener.progressChanged [" + ModuleS3Upload.this.appInstance.getContextStr() + "/" + this.mediaName + "] event: " + progressEventType.toString(), "application", "comment");
                        }
                        Object object = ModuleS3Upload.this.lock;
                        synchronized (object) {
                            if (this.uploadName != null) {
                                ModuleS3Upload.this.currentUploads.remove(this.uploadName);
                            }
                            if (ModuleS3Upload.this.debugLog) {
                                ModuleS3Upload.this.logger.info("ModuleS3Upload.ProgressListener.progressChanged [" + ModuleS3Upload.this.appInstance.getContextStr() + "/" + this.mediaName + "] event: " + progressEventType.toString() + ", shutting down", "application", "comment");
                            }
                            if (ModuleS3Upload.this.shuttingDown) {
                                break;
                            }
                        }
                        if (!ModuleS3Upload.this.restartFailedUploads) break;
                        if (ModuleS3Upload.this.debugLog) {
                            ModuleS3Upload.this.logger.info("ModuleS3Upload.ProgressListener.progressChanged [" + ModuleS3Upload.this.appInstance.getContextStr() + "/" + this.mediaName + "] event: " + progressEventType.toString() + ", restarting upload", "application", "comment");
                        }
                        long l = ModuleS3Upload.this.getFileAge(this.mediaName);
                        ModuleS3Upload.this.startUpload(this.mediaName, ModuleS3Upload.this.restartFailedUploadsTimeout + l);
                        break;
                    }
                    default: {
                        if (!ModuleS3Upload.this.debugLog) break;
                        ModuleS3Upload.this.logger.info("ModuleS3Upload.ProgressListener.progressChanged [" + ModuleS3Upload.this.appInstance.getContextStr() + "/" + this.mediaName + "] event: " + progressEventType.toString(), "application", "comment");
                    }
                }
            }
            ModuleS3Upload.this.touchAppInstance();
        }

        public void onPersistableTransfer(final PersistableTransfer persistableTransfer) {
            if (ModuleS3Upload.this.debugLog) {
                ModuleS3Upload.this.logger.info("ModuleS3Upload.ProgressListener.onPersistableTransfer() [" + ModuleS3Upload.this.appInstance.getContextStr() + "/" + this.mediaName + "] data: " + persistableTransfer.serialize(), "application", "comment");
            }
            ModuleS3Upload.this.appInstance.getVHost().getThreadPool().execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = ModuleS3Upload.this.lock;
                    synchronized (object) {
                        FileOutputStream fileOutputStream = null;
                        File file = new File(ModuleS3Upload.this.storageDir, ProgressListener.this.mediaName + ".upload");
                        try {
                            if (!file.exists()) {
                                file.createNewFile();
                            }
                            fileOutputStream = new FileOutputStream(file);
                            persistableTransfer.serialize((OutputStream)fileOutputStream);
                        }
                        catch (Exception exception) {
                        }
                        finally {
                            if (fileOutputStream != null) {
                                try {
                                    fileOutputStream.close();
                                }
                                catch (Exception exception) {}
                            }
                        }
                    }
                }
            });
        }
    }

    private class WriteListener
    implements IMediaWriterActionNotify {
        private WriteListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onWriteComplete(IMediaStream iMediaStream, File file) {
            String string = ModuleS3Upload.this.getMediaName(file.getPath());
            if (ModuleS3Upload.this.debugLog) {
                ModuleS3Upload.this.logger.info("ModuleS3Upload.onWriteComplete [" + ModuleS3Upload.this.appInstance.getContextStr() + "/" + string + "]", "application", "comment");
            }
            if (ModuleS3Upload.this.transferManager == null) {
                ModuleS3Upload.this.logger.warn("ModuleS3Upload.WriteListener.onWriteComplete Cannot upload file because S3 Transfer Manager isn't loaded: [" + ModuleS3Upload.this.appInstance.getContextStr() + "/" + string + "]");
            }
            File file2 = null;
            Object object = ModuleS3Upload.this.lock;
            synchronized (object) {
                try {
                    file2 = new File(file.getPath() + ".upload");
                    if (file2.exists()) {
                        if (ModuleS3Upload.this.debugLog) {
                            ModuleS3Upload.this.logger.info("ModuleS3Upload.onWriteComplete .upload file exists (deleting) [" + ModuleS3Upload.this.appInstance.getContextStr() + "/" + string + "]", "application", "comment");
                        }
                        file2.delete();
                    }
                    file2.createNewFile();
                    if (!ModuleS3Upload.this.shuttingDown) {
                        ModuleS3Upload.this.startUpload(string, ModuleS3Upload.this.uploadDelay);
                    }
                }
                catch (IOException iOException) {
                    ModuleS3Upload.this.logger.error("ModuleS3Upload.WriteListener.onWriteComplete Cannot create .upload file: [" + ModuleS3Upload.this.appInstance.getContextStr() + "/" + string + "]", (Throwable)iOException);
                }
            }
        }

        public void onFLVAddMetadata(IMediaStream iMediaStream, Map<String, Object> map) {
        }
    }

    private class MyFilter
    implements FileFilter {
        private String suffix;

        MyFilter(String string) {
            this.suffix = string;
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(this.suffix.toLowerCase());
        }
    }

    private class UploadTask
    extends TimerTask {
        private final String mediaName;
        private final long delay;
        private long lastAge = 0L;

        UploadTask(String string, long l, long l2) {
            this.mediaName = string;
            this.delay = l;
            this.lastAge = l2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean bl = false;
            boolean bl2 = false;
            Object object = ModuleS3Upload.this.lock;
            synchronized (object) {
                if (ModuleS3Upload.this.shuttingDown) {
                    if (ModuleS3Upload.this.debugLog) {
                        ModuleS3Upload.this.logger.info("ModuleS3Upload.UploadTask.run() shutting down [" + ModuleS3Upload.this.appInstance.getContextStr() + "/" + this.mediaName + "]", "application", "comment");
                    }
                    bl2 = true;
                } else {
                    File file = new File(ModuleS3Upload.this.storageDir, this.mediaName + ".upload");
                    if (!file.exists()) {
                        ModuleS3Upload.this.logger.warn("ModuleS3Upload.UploadTask.run() .uploadfile missing [" + ModuleS3Upload.this.appInstance.getContextStr() + "/" + this.mediaName + "]", "application", "comment");
                        bl2 = true;
                    } else {
                        long l = ModuleS3Upload.this.getFileAge(this.mediaName);
                        if (l < this.lastAge) {
                            ModuleS3Upload.this.logger.warn("ModuleS3Upload.UploadTask.run() media file has been modified [" + ModuleS3Upload.this.appInstance.getContextStr() + "/" + this.mediaName + "] age: " + l + " < lastAge: " + this.lastAge, "application", "comment");
                            bl2 = true;
                        } else {
                            this.lastAge = l;
                            if (l >= this.delay) {
                                if (ModuleS3Upload.this.debugLog) {
                                    ModuleS3Upload.this.logger.info("ModuleS3Upload.UploadTask.run() age >= delay [" + ModuleS3Upload.this.appInstance.getContextStr() + "/" + this.mediaName + "] age: " + l + ", delay: " + this.delay, "application", "comment");
                                }
                                bl2 = true;
                                bl = true;
                            } else if (ModuleS3Upload.this.debugLog) {
                                ModuleS3Upload.this.logger.info("ModuleS3Upload.UploadTask.run() age < delay [" + ModuleS3Upload.this.appInstance.getContextStr() + "/" + this.mediaName + "] age: " + l + ", delay: " + this.delay, "application", "comment");
                            }
                        }
                    }
                }
                if (bl2) {
                    if (ModuleS3Upload.this.debugLog) {
                        ModuleS3Upload.this.logger.info("ModuleS3Upload.UploadTask.run() removing timer [" + ModuleS3Upload.this.appInstance.getContextStr() + "/" + this.mediaName + "]", "application", "comment");
                    }
                    ModuleS3Upload.this.uploadTimers.remove(this.mediaName);
                    this.cancel();
                } else {
                    ModuleS3Upload.this.touchAppInstance();
                }
            }
            if (bl) {
                if (ModuleS3Upload.this.debugLog) {
                    ModuleS3Upload.this.logger.info("ModuleS3Upload.UploadTask.run() starting upload [" + ModuleS3Upload.this.appInstance.getContextStr() + "/" + this.mediaName + "]", "application", "comment");
                }
                ModuleS3Upload.this.startUpload(this.mediaName);
            }
        }
    }
}

