/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.streampublisher;

import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediacaster.IMediaCaster;
import com.wowza.wms.mediacaster.IMediaCasterNotify2;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamActionNotify;
import com.wowza.wms.stream.IMediaStreamPlay;
import com.wowza.wms.stream.publish.PlaylistItem;
import com.wowza.wms.stream.publish.Stream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModuleLoopUntilLive
extends ModuleBase {
    public static String MODULE_NAME = "ModuleLoopUntilLive";
    public static final String PROP_NAME_PREFIX = "loopUntilLive";
    private WMSLogger logger;
    private IApplicationInstance appInstance;
    private String liveStreamNames = "myStream";
    private String outStreamNames = "Stream1";
    private boolean reloadEntirePlaylist = true;
    private boolean handleMediaCasters = true;
    private boolean waitForLiveAudio = true;
    private boolean waitForLiveVideo = true;
    private long waitForLiveTimeout = 10000L;
    private Object lock = new Object();
    private IMediaStreamActionNotify actionNotify = new StreamListener();
    private Map<String, List<PlaylistItem>> playlists = new HashMap<String, List<PlaylistItem>>();
    private Map<String, Integer> playlistIndexes = new HashMap<String, Integer>();

    public void onAppStart(IApplicationInstance iApplicationInstance) {
        this.logger = WMSLoggerFactory.getLoggerObj((IApplicationInstance)iApplicationInstance);
        this.init(iApplicationInstance);
        this.logger.info(MODULE_NAME + ".onAppStart: [" + iApplicationInstance.getContextStr() + "]: Build #9", "application", "comment");
    }

    public void init(IApplicationInstance iApplicationInstance) {
        this.appInstance = iApplicationInstance;
        iApplicationInstance.addMediaCasterListener((IMediaCasterNotify2)new MediaCasterListener());
        this.liveStreamNames = iApplicationInstance.getProperties().getPropertyStr("loopUntilLiveStream", this.liveStreamNames);
        this.liveStreamNames = iApplicationInstance.getProperties().getPropertyStr("loopUntilLiveSourceStreams", this.liveStreamNames);
        this.outStreamNames = iApplicationInstance.getProperties().getPropertyStr("loopUntilLiveOutStream", this.outStreamNames);
        this.outStreamNames = iApplicationInstance.getProperties().getPropertyStr("loopUntilLiveOutputStreams", this.outStreamNames);
        this.reloadEntirePlaylist = iApplicationInstance.getProperties().getPropertyBoolean("loopUntilLiveReloadEntirePlaylist", this.reloadEntirePlaylist);
        this.handleMediaCasters = iApplicationInstance.getProperties().getPropertyBoolean("loopUntilLiveHandleMediaCasters", this.handleMediaCasters);
        this.waitForLiveAudio = iApplicationInstance.getProperties().getPropertyBoolean("loopUntilLiveWaitForLiveAudio", this.waitForLiveAudio);
        this.waitForLiveVideo = iApplicationInstance.getProperties().getPropertyBoolean("loopUntilLiveWaitForLiveVideo", this.waitForLiveVideo);
        this.waitForLiveTimeout = iApplicationInstance.getProperties().getPropertyLong("loopUntilLiveWaitForLiveTimeout", this.waitForLiveTimeout);
    }

    public void onStreamCreate(IMediaStream iMediaStream) {
        if (this.appInstance == null) {
            this.init(iMediaStream.getStreams().getAppInstance());
        }
        iMediaStream.addClientListener(this.actionNotify);
    }

    public void onStreamDestroy(IMediaStream iMediaStream) {
        iMediaStream.removeClientListener(this.actionNotify);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void swapToLive(String string) {
        List list;
        String[] stringArray;
        long l = System.currentTimeMillis();
        while (l + this.waitForLiveTimeout > System.currentTimeMillis()) {
            stringArray = this.appInstance.getStreams().getStream(string);
            if (stringArray != null) {
                boolean bl = false;
                if (stringArray.isPublishStreamReady(this.waitForLiveAudio, this.waitForLiveVideo)) {
                    if (!this.waitForLiveAudio || !this.waitForLiveVideo) break;
                    AMFPacket aMFPacket = stringArray.getLastKeyFrame();
                    if (aMFPacket != null) {
                        long l2 = aMFPacket.getAbsTimecode();
                        list = stringArray.getPlayPackets();
                        for (Object object2 : list) {
                            long l3;
                            if (!object2.isAudio() || Math.abs(l2 - (l3 = object2.getAbsTimecode())) >= 50L) continue;
                            bl = true;
                            break;
                        }
                    }
                }
                if (bl) break;
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.appInstance.getStreams().getStream(string) == null) {
            return;
        }
        stringArray = this.liveStreamNames.split(",");
        String[] stringArray2 = this.outStreamNames.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i].trim();
            if (!string.equalsIgnoreCase(string2) || stringArray2.length <= i) continue;
            String string3 = stringArray2[i].trim();
            list = (Stream)this.appInstance.getProperties().get((Object)string3);
            if (list == null) continue;
            Object object = this.lock;
            synchronized (object) {
                if (!this.playlists.containsKey(string3)) {
                    Object object2;
                    object2 = list.getPlaylist();
                    PlaylistItem playlistItem = list.getCurrentItem();
                    int n = playlistItem != null ? playlistItem.getIndex() : 0;
                    this.playlists.put(string3, (List<PlaylistItem>)object2);
                    this.playlistIndexes.put(string3, n);
                    list.play(string2, -2, -1, true);
                    this.logger.info(MODULE_NAME + ".swapToLive [" + list.getName() + "]", "application", "comment");
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void swapToPlaylist(String string) {
        String[] stringArray = this.liveStreamNames.split(",");
        String[] stringArray2 = this.outStreamNames.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i].trim();
            if (!string.equalsIgnoreCase(string2) || stringArray2.length <= i) continue;
            String string3 = stringArray2[i].trim();
            Stream stream = (Stream)this.appInstance.getProperties().get((Object)string3);
            if (stream == null) continue;
            Object object = this.lock;
            synchronized (object) {
                List<PlaylistItem> list = this.playlists.remove(string3);
                Integer n = this.playlistIndexes.remove(string3);
                if (list != null) {
                    if (this.reloadEntirePlaylist) {
                        boolean bl = true;
                        for (PlaylistItem playlistItem : list) {
                            stream.play(playlistItem.getName(), playlistItem.getStart(), playlistItem.getLength(), bl);
                            bl = false;
                        }
                        stream.play(n + 1);
                    } else if (list.size() > n) {
                        PlaylistItem playlistItem = list.get(n);
                        stream.play(playlistItem.getName(), playlistItem.getStart(), playlistItem.getLength(), true);
                    }
                    this.logger.info(MODULE_NAME + ".swapToPlaylist [" + stream.getName() + "]", "application", "comment");
                }
                continue;
            }
        }
    }

    public String getLiveStreamNames() {
        return this.liveStreamNames;
    }

    public void setLiveStreamNames(String string) {
        this.liveStreamNames = string;
    }

    public String getOutStreamNames() {
        return this.outStreamNames;
    }

    public void setOutStreamNames(String string) {
        this.outStreamNames = string;
    }

    public boolean isReloadEntirePlaylist() {
        return this.reloadEntirePlaylist;
    }

    public void setReloadEntirePlaylist(boolean bl) {
        this.reloadEntirePlaylist = bl;
    }

    public boolean isHandleMediaCasters() {
        return this.handleMediaCasters;
    }

    public void setHandleMediaCasters(boolean bl) {
        this.handleMediaCasters = bl;
    }

    private class MediaCasterListener
    implements IMediaCasterNotify2 {
        private MediaCasterListener() {
        }

        public void onMediaCasterCreate(IMediaCaster iMediaCaster) {
        }

        public void onMediaCasterDestroy(IMediaCaster iMediaCaster) {
        }

        public void onRegisterPlayer(IMediaCaster iMediaCaster, IMediaStreamPlay iMediaStreamPlay) {
        }

        public void onUnRegisterPlayer(IMediaCaster iMediaCaster, IMediaStreamPlay iMediaStreamPlay) {
        }

        public void onSetSourceStream(IMediaCaster iMediaCaster, IMediaStream iMediaStream) {
        }

        public void onConnectStart(IMediaCaster iMediaCaster) {
        }

        public void onConnectSuccess(IMediaCaster iMediaCaster) {
        }

        public void onConnectFailure(IMediaCaster iMediaCaster) {
        }

        public void onStreamStart(IMediaCaster iMediaCaster) {
            String[] stringArray;
            final String string = iMediaCaster.getStream().getName();
            for (String string2 : stringArray = ModuleLoopUntilLive.this.liveStreamNames.split(",")) {
                if (!string2.trim().equalsIgnoreCase(string)) continue;
                ModuleLoopUntilLive.this.logger.info(MODULE_NAME + ".MediaCasterListener.onStreamStop Swapping to live [" + string + "]", "application", "comment");
                ModuleLoopUntilLive.this.appInstance.getVHost().getHandlerThreadPool().execute(new Runnable(){

                    @Override
                    public void run() {
                        ModuleLoopUntilLive.this.swapToLive(string);
                    }
                });
                break;
            }
        }

        public void onStreamStop(IMediaCaster iMediaCaster) {
            String[] stringArray;
            String string = iMediaCaster.getStream().getName();
            for (String string2 : stringArray = ModuleLoopUntilLive.this.liveStreamNames.split(",")) {
                if (!string2.trim().equalsIgnoreCase(string)) continue;
                ModuleLoopUntilLive.this.logger.info(MODULE_NAME + ".MediaCasterListener.onStreamStop Swapping to playlist [" + string + "]", "application", "comment");
                ModuleLoopUntilLive.this.swapToPlaylist(string);
                break;
            }
        }
    }

    private class StreamListener
    implements IMediaStreamActionNotify {
        private StreamListener() {
        }

        public void onPublish(IMediaStream iMediaStream, final String string, boolean bl, boolean bl2) {
            String[] stringArray;
            for (String string2 : stringArray = ModuleLoopUntilLive.this.liveStreamNames.split(",")) {
                if (!string2.trim().equalsIgnoreCase(string)) continue;
                if (ModuleLoopUntilLive.this.appInstance.getMediaCasterStreams().getMediaCaster(string) != null && ModuleLoopUntilLive.this.handleMediaCasters) {
                    ModuleLoopUntilLive.this.logger.info(MODULE_NAME + ".StreamListener.onPublish Stream is MediaCaster. Swapping handled by MediaCasterListener.onStreamStart [" + string + "]", "application", "comment");
                    return;
                }
                ModuleLoopUntilLive.this.logger.info(MODULE_NAME + ".StreamListener.onPublish Swapping to live [" + string + "]", "application", "comment");
                ModuleLoopUntilLive.this.appInstance.getVHost().getHandlerThreadPool().execute(new Runnable(){

                    @Override
                    public void run() {
                        ModuleLoopUntilLive.this.swapToLive(string);
                    }
                });
                break;
            }
        }

        public void onUnPublish(IMediaStream iMediaStream, String string, boolean bl, boolean bl2) {
            String[] stringArray;
            for (String string2 : stringArray = ModuleLoopUntilLive.this.liveStreamNames.split(",")) {
                if (!string2.trim().equalsIgnoreCase(string)) continue;
                if (ModuleLoopUntilLive.this.appInstance.getMediaCasterStreams().getMediaCaster(string) != null && ModuleLoopUntilLive.this.handleMediaCasters) {
                    ModuleLoopUntilLive.this.logger.info(MODULE_NAME + ".onUnPublish Stream is MediaCaster. Swapping handled by MediaCasterListener.onStreamStop [" + string + "]", "application", "comment");
                    return;
                }
                ModuleLoopUntilLive.this.logger.info(MODULE_NAME + ".StreamListener.onPublish Swapping to playlist [" + string + "]", "application", "comment");
                ModuleLoopUntilLive.this.swapToPlaylist(string);
                break;
            }
        }

        public void onPause(IMediaStream iMediaStream, boolean bl, double d) {
        }

        public void onPlay(IMediaStream iMediaStream, String string, double d, double d2, int n) {
        }

        public void onSeek(IMediaStream iMediaStream, double d) {
        }

        public void onStop(IMediaStream iMediaStream) {
        }
    }
}

