/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.streampublisher;

import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.plugin.streampublisher.ModuleStreamPublisher;
import com.wowza.wms.stream.publish.Publisher;
import com.wowza.wms.stream.publish.Stream;
import com.wowza.wms.util.StreamUtils;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ModuleLoopUntilLivePublisher
extends ModuleBase {
    private static final Class<ModuleStreamPublisher> CLASS = ModuleStreamPublisher.class;
    public static final String MODULE_NAME = CLASS.getSimpleName();
    private String outStreamNames = "Stream1";
    private String vodFileNames = "sample.mp4";
    private List<String> outStreamNamesList = new CopyOnWriteArrayList<String>();
    private List<String> vodFileNamesList;
    private IApplicationInstance appInstance;
    private WMSLogger logger;

    public void onAppStart(IApplicationInstance iApplicationInstance) {
        this.appInstance = iApplicationInstance;
        this.logger = WMSLoggerFactory.getLoggerObj((IApplicationInstance)iApplicationInstance);
        this.logger.info(MODULE_NAME + ".onAppStart: [" + iApplicationInstance.getContextStr() + "]: Build #9", "application", "comment");
        this.outStreamNames = iApplicationInstance.getProperties().getPropertyStr("loopUntilLiveOutputStreams", this.outStreamNames);
        this.vodFileNames = iApplicationInstance.getProperties().getPropertyStr("loopUntilLiveVodFiles", this.vodFileNames);
        this.outStreamNamesList.addAll(Arrays.asList(this.outStreamNames.split(",")));
        this.vodFileNamesList = Arrays.asList(this.vodFileNames.split(","));
        int n = this.vodFileNamesList.size();
        for (int i = 0; i < this.outStreamNamesList.size(); ++i) {
            String string = this.outStreamNamesList.get(i).trim();
            String string2 = this.vodFileNamesList.get(Math.min(i, n - 1)).trim();
            this.startStream(string, string2);
        }
    }

    public void startStream(String string, String string2) {
        Stream stream = (Stream)this.appInstance.getProperties().get((Object)string);
        if (stream != null) {
            this.logger.warn(MODULE_NAME + ".startStream [" + this.appInstance.getContextStr() + "/" + string + "] stream already running");
            return;
        }
        if (StreamUtils.getStreamLength((IApplicationInstance)this.appInstance, (String)string2) <= 0.0) {
            this.logger.warn(MODULE_NAME + ".startStream [" + this.appInstance.getContextStr() + "/" + string + "] vod file not found: " + string2);
            return;
        }
        stream = Stream.createInstance((IApplicationInstance)this.appInstance, (String)string);
        stream.play(string2, 0, -1, true);
        this.appInstance.getProperties().setProperty(string, (Object)stream);
        if (!this.outStreamNamesList.contains(string)) {
            this.outStreamNamesList.add(string);
        }
    }

    public void onAppStop(IApplicationInstance iApplicationInstance) {
        for (String string : this.outStreamNamesList) {
            this.stopStream(string);
        }
    }

    private void stopStream(String string) {
        Stream stream = (Stream)this.appInstance.getProperties().remove((Object)string);
        if (stream != null) {
            stream.closeAndWait();
            Publisher publisher = stream.getPublisher();
            if (publisher != null) {
                publisher.close();
            }
        }
        this.outStreamNamesList.remove(string);
    }
}

