/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.streampublisher;

import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.client.IClient;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.plugin.streampublisher.ServerListenerStreamPublisher;
import com.wowza.wms.request.RequestFunction;
import com.wowza.wms.server.Server;
import com.wowza.wms.stream.publish.Stream;
import java.util.Map;

public class ModuleStreamPublisher
extends ModuleBase {
    public static final String MODULE_NAME = "ModuleStreamPublisher";
    public static final String PROP_NAME_PREFIX = "streamPublisher";
    private ServerListenerStreamPublisher streamPublisher;
    private IApplicationInstance appInstance;
    private WMSLogger logger;

    public void loadSchedule(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        try {
            ModuleStreamPublisher.sendResult((IClient)iClient, (AMFDataList)aMFDataList, (String)this.loadSchedule());
        }
        catch (Exception exception) {
            ModuleStreamPublisher.sendResult((IClient)iClient, (AMFDataList)aMFDataList, (String)exception.getMessage());
        }
    }

    public void onAppStart(final IApplicationInstance iApplicationInstance) {
        this.appInstance = iApplicationInstance;
        this.logger = WMSLoggerFactory.getLoggerObj((IApplicationInstance)iApplicationInstance);
        this.logger.info("ModuleStreamPublisher.onAppStart: [" + iApplicationInstance.getContextStr() + "]: Build #9", "application", "comment");
        this.streamPublisher = (ServerListenerStreamPublisher)Server.getInstance().getProperties().get((Object)"serverListenerStreamPublisher");
        if (this.streamPublisher == null) {
            this.streamPublisher = new ServerListenerStreamPublisher();
            Server.getInstance().getProperties().setProperty("serverListenerStreamPublisher", (Object)this.streamPublisher);
        }
        iApplicationInstance.getVHost().getThreadPool().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    String string = ModuleStreamPublisher.this.loadSchedule();
                    ModuleStreamPublisher.this.logger.info("ModuleStreamPublisher.onAppStart: [" + iApplicationInstance.getContextStr() + "]: " + string, "application", "comment");
                }
                catch (Exception exception) {
                    ModuleStreamPublisher.this.logger.error("ModuleStreamPublisher.onAppStart: [" + iApplicationInstance.getContextStr() + "]: " + exception.getMessage(), (Throwable)exception);
                }
            }
        });
    }

    public void onAppStop(IApplicationInstance iApplicationInstance) {
        this.unloadSchedule();
        this.streamPublisher = null;
    }

    public String loadSchedule() throws Exception {
        return this.streamPublisher.loadSchedule(this.appInstance);
    }

    public void unloadSchedule() {
        Map map = (Map)this.appInstance.getProperties().remove((Object)"streamPublisherStreams");
        if (map != null) {
            for (Stream stream : map.values()) {
                this.streamPublisher.shutdownStream(this.appInstance, stream);
            }
            map.clear();
        }
        this.appInstance.getProperties().remove((Object)"streamPublisherScheduleLoaded");
    }
}

