/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.streampublisher;

import com.wowza.util.StringUtils;
import com.wowza.wms.amf.AMFData;
import com.wowza.wms.amf.AMFDataItem;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.amf.AMFDataMixedArray;
import com.wowza.wms.application.IApplication;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.IApplicationInstanceNotify;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.server.IServer;
import com.wowza.wms.server.IServerNotify2;
import com.wowza.wms.server.Server;
import com.wowza.wms.stream.publish.IStreamActionNotify;
import com.wowza.wms.stream.publish.Playlist;
import com.wowza.wms.stream.publish.PlaylistItem;
import com.wowza.wms.stream.publish.Publisher;
import com.wowza.wms.stream.publish.Stream;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.VHostSingleton;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ServerListenerStreamPublisher
implements IServerNotify2 {
    public static final String CLASS_NAME = "ServerListenerStreamPublisher";
    public static final String PROP_NAME_PREFIX = "streamPublisher";
    public static final String PROP_STREAMPUBLISHER = "serverListenerStreamPublisher";
    private WMSLogger logger = WMSLoggerFactory.getLogger(null);
    private Object lock = new Object();

    public void onServerCreate(IServer iServer) {
        iServer.getProperties().setProperty(PROP_STREAMPUBLISHER, (Object)this);
    }

    public void onServerInit(IServer iServer) {
        this.logger.info("ServerListenerStreamPublisher Started. build #9");
        IVHost iVHost = null;
        IApplication iApplication = null;
        String string = iServer.getProperties().getPropertyStr("PublishToVHost", "_defaultVHost_");
        string = iServer.getProperties().getPropertyStr("streamPublisherVHost", string);
        if (StringUtils.isEmpty((String)string)) {
            this.logger.info("ServerListenerStreamPublisher: publishToVHost is empty. Can not run.");
            return;
        }
        try {
            iVHost = VHostSingleton.getInstance((String)string);
            if (iVHost == null) {
                this.logger.warn("ServerListenerStreamPublisher: Failed to get Vhost can not run.");
                return;
            }
        }
        catch (Exception exception) {
            this.logger.error("ServerListenerStreamPublisher: Failed to get Vhost can not run.", (Throwable)exception);
            return;
        }
        String string2 = iServer.getProperties().getPropertyStr("PublishToApplication", "live/_definst_");
        string2 = iServer.getProperties().getPropertyStr("streamPublisherApplication", string2);
        if (StringUtils.isEmpty((String)string2)) {
            this.logger.warn("ServerListenerStreamPublisher: publishToApplication empty. Can not run.");
            return;
        }
        String[] stringArray = string2.split("/");
        String string3 = stringArray[0];
        String string4 = stringArray.length > 1 ? stringArray[1] : "_definst_";
        try {
            iApplication = iVHost.getApplication(string3);
            if (iApplication == null) {
                this.logger.warn("ServerListenerStreamPublisher: Failed to get Application can not run.");
                return;
            }
        }
        catch (Exception exception) {
            this.logger.error("ServerListenerStreamPublisher: Failed to get Application can not run.", (Throwable)exception);
            return;
        }
        AppInstanceListener appInstanceListener = (AppInstanceListener)iApplication.getProperties().get((Object)"streamPublisherAppInstanceListener");
        if (appInstanceListener == null) {
            appInstanceListener = new AppInstanceListener();
            iApplication.addApplicationInstanceListener((IApplicationInstanceNotify)appInstanceListener);
            iApplication.getProperties().setProperty("streamPublisherAppInstanceListener", (Object)appInstanceListener);
        }
        try {
            final IApplicationInstance iApplicationInstance = iApplication.getAppInstance(string4);
            if (iApplicationInstance == null) {
                this.logger.warn("ServerListenerStreamPublisher: Failed to get Application Instance can not run.");
                return;
            }
            if (iApplicationInstance.getProperties().getPropertyBoolean("streamPublisherScheduleLoaded", false)) {
                this.logger.info("ServerListenerStreamPublisher: Schedule loaded by module.");
            } else {
                iVHost.getThreadPool().execute(new Runnable(){

                    @Override
                    public void run() {
                        String string = null;
                        try {
                            string = ServerListenerStreamPublisher.this.loadSchedule(iApplicationInstance);
                        }
                        catch (Exception exception) {
                            ServerListenerStreamPublisher.this.logger.error("ServerListenerStreamPublisher: " + exception.getMessage(), (Throwable)exception);
                        }
                        iApplicationInstance.getProperties().setProperty("streamPublisherScheduleLoaded", (Object)true);
                        ServerListenerStreamPublisher.this.logger.info("ServerListenerStreamPublisher: " + string);
                    }
                });
            }
        }
        catch (Exception exception) {
            this.logger.error("ServerListenerStreamPublisher: Failed to get Application Instance can not run.", (Throwable)exception);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String loadSchedule(IApplicationInstance iApplicationInstance) throws Exception {
        Date date = new Date();
        WMSProperties wMSProperties = Server.getInstance().getProperties();
        WMSProperties wMSProperties2 = iApplicationInstance.getProperties();
        Object object = this.lock;
        synchronized (object) {
            boolean bl = wMSProperties.getPropertyBoolean("streamPublisherSwitchLog", true);
            bl = wMSProperties2.getPropertyBoolean("streamPublisherSwitchLog", bl);
            boolean bl2 = wMSProperties.getPropertyBoolean("PassthruMetaData", true);
            bl2 = wMSProperties.getPropertyBoolean("streamPublisherPassMetaData", bl2);
            bl2 = wMSProperties2.getPropertyBoolean("PassthruMetaData", bl2);
            bl2 = wMSProperties2.getPropertyBoolean("streamPublisherPassMetaData", bl2);
            String string2 = wMSProperties.getPropertyStr("streamPublisherSmilFile", "streamschedule.smil");
            string2 = wMSProperties2.getPropertyStr("streamPublisherSmilFile", string2);
            boolean bl3 = wMSProperties.getPropertyBoolean("streamPublisherTimesInMilliSeconds", false);
            bl3 = wMSProperties2.getPropertyBoolean("streamPublisherTimesInMilliSeconds", bl3);
            boolean bl4 = wMSProperties.getPropertyBoolean("streamPublisherStartLiveOnPreviousKeyFrame", true);
            bl4 = wMSProperties2.getPropertyBoolean("streamPublisherStartLiveOnPreviousKeyFrame", bl4);
            long l = wMSProperties.getPropertyLong("streamPublisherStartLiveOnPreviousBufferTime", 4100L);
            l = wMSProperties2.getPropertyLong("streamPublisherStartLiveOnPreviousBufferTime", l);
            int n = wMSProperties.getPropertyInt("streamPublisherTimeOffsetBetweenItems", 0);
            n = wMSProperties2.getPropertyInt("streamPublisherTimeOffsetBetweenItems", n);
            boolean bl5 = wMSProperties.getPropertyBoolean("streamPublisherUpdateMetadataOnNewItem", true);
            bl5 = wMSProperties2.getPropertyBoolean("streamPublisherUpdateMetadataOnNewItem", bl5);
            String string3 = iApplicationInstance.getStreamStorageDir();
            try {
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Object object62;
                String string4 = string3 + "/" + string2.replace("..", "");
                File file = new File(string4);
                if (!file.exists()) {
                    throw new Exception("ServerListenerStreamPublisher Could not find playlist file: " + string4);
                }
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = null;
                Document document = null;
                try {
                    documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    document = documentBuilder.parse("file:///" + string4);
                }
                catch (Exception exception) {
                    throw new Exception("ServerListenerStreamPublisher Error parsing " + string4 + ". " + exception.getMessage(), exception);
                }
                document.getDocumentElement().normalize();
                NodeList nodeList = document.getElementsByTagName("stream");
                HashMap<Object, Stream> hashMap = (HashMap<Object, Stream>)wMSProperties2.getProperty("streamPublisherStreams");
                if (hashMap == null) {
                    hashMap = new HashMap<Object, Stream>();
                    wMSProperties2.setProperty("streamPublisherStreams", hashMap);
                }
                HashMap<Object, Stream> hashMap2 = new HashMap<Object, Stream>();
                hashMap2.putAll(hashMap);
                hashMap.clear();
                HashMap<String, List> hashMap3 = (HashMap<String, List>)wMSProperties2.getProperty("streamPublisherSchedules");
                if (hashMap3 == null) {
                    hashMap3 = new HashMap<String, List>();
                    wMSProperties2.setProperty("streamPublisherSchedules", hashMap3);
                }
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    object62 = nodeList.item(i);
                    if (object62.getNodeType() != 1) continue;
                    object5 = (Element)object62;
                    object4 = object5.getAttribute("name");
                    this.logger.info("ServerListenerStreamPublisher: Stream name is '" + (String)object4 + "'");
                    object3 = (Stream)hashMap2.get(object4);
                    if (object3 == null) {
                        object3 = Stream.createInstance((IApplicationInstance)iApplicationInstance, (String)object4);
                        if (object3 == null) {
                            this.logger.error("ServerListenerStreamPublisher cannot create stream: " + (String)object4);
                            continue;
                        }
                        object2 = (IStreamActionNotify)wMSProperties2.get((Object)"streamPublisherStreamListener");
                        if (object2 == null) {
                            object2 = new StreamListener(iApplicationInstance, bl5);
                            wMSProperties2.setProperty("streamPublisherStreamListener", object2);
                        }
                        object3.addListener((IStreamActionNotify)object2);
                    }
                    hashMap2.remove(object4);
                    hashMap.put(object4, (Stream)object3);
                    wMSProperties2.setProperty((String)object4, object3);
                }
                for (Object object62 : hashMap2.values()) {
                    this.shutdownStream(iApplicationInstance, (Stream)object62);
                }
                hashMap2.clear();
                for (Object object62 : hashMap.values()) {
                    object5 = this.lock;
                    synchronized (object5) {
                        object4 = (List)hashMap3.remove(object62.getName());
                        if (object4 != null) {
                            object3 = object4.iterator();
                            while (object3.hasNext()) {
                                object2 = (ScheduledItem)object3.next();
                                ((ScheduledItem)object2).stop();
                            }
                            object4.clear();
                        }
                    }
                }
                NodeList nodeList2 = document.getElementsByTagName("playlist");
                if (nodeList2.getLength() == 0) {
                    return "No playlists defined in smil file";
                }
                object62 = this.lock;
                synchronized (object62) {
                    for (int i = 0; i < nodeList2.getLength(); ++i) {
                        Comparable<Integer> comparable;
                        List<Integer> list2;
                        String string5;
                        Object object7;
                        Object object8;
                        object4 = nodeList2.item(i);
                        if (object4.getNodeType() != 1) continue;
                        object3 = (Element)object4;
                        object2 = object3.getElementsByTagName("video");
                        if (object2.getLength() == 0) {
                            return "No videos defined in stream";
                        }
                        String string6 = object3.getAttribute("playOnStream");
                        if (string6.length() == 0) continue;
                        Playlist playlist = new Playlist(string6);
                        playlist.setRepeat(!object3.getAttribute("repeat").equals("false"));
                        for (int j = 0; j < object2.getLength(); ++j) {
                            object8 = object2.item(j);
                            if (object8.getNodeType() != 1) continue;
                            object7 = (Element)object8;
                            string5 = object7.getAttribute("src");
                            list2 = Integer.parseInt(object7.getAttribute("start"));
                            comparable = Integer.parseInt(object7.getAttribute("length"));
                            if ((Integer)((Object)list2) <= -2 && string5.indexOf(":") != -1) {
                                string5 = string5.substring(string5.indexOf(":") + 1);
                            }
                            playlist.addItem(string5, ((Integer)((Object)list2)).intValue(), comparable.intValue());
                        }
                        String string7 = object3.getAttribute("scheduled");
                        object8 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        object7 = null;
                        try {
                            object7 = ((DateFormat)object8).parse(string7);
                            this.logger.info("ServerListenerStreamPublisher.loadSchedule [scheduled: " + string7 + ", startTime: " + ((Date)object7).toString() + ", time: " + ((Date)object7).getTime() + ", parser.timezone: " + ((DateFormat)object8).getTimeZone().getDisplayName() + "]", "application", "comment");
                        }
                        catch (Exception exception) {
                            throw new Exception("ServerListenerStreamPublisher Parsing schedule time failed.", exception);
                        }
                        string5 = (Stream)hashMap.get(string6);
                        if (string5 == null) {
                            this.logger.warn("ServerListenerStreamPublisher Stream does not exist for playlist: " + object3.getAttribute("name") + " : " + string6);
                            continue;
                        }
                        list2 = (List)hashMap3.get(string6);
                        if (list2 == null) {
                            list2 = new ArrayList<Integer>();
                            hashMap3.put(string6, list2);
                        }
                        string5.setSendOnMetadata(bl2);
                        string5.setSwitchLog(bl);
                        string5.setTimesInMilliseconds(bl3);
                        string5.setStartLiveOnPreviousKeyFrame(bl4);
                        string5.setStartLiveOnPreviousBufferTime(l);
                        string5.setTimeOffsetBetweenItems(n);
                        comparable = new ScheduledItem(iApplicationInstance, (Date)object7, playlist, (Stream)string5);
                        list2.add((Integer)comparable);
                        this.logger.info("ServerListenerStreamPublisher Scheduled: " + string5.getName() + " for: " + string7);
                    }
                    hashMap3.replaceAll((string, list) -> {
                        List list2 = list.stream().sorted().filter(scheduledItem -> !((ScheduledItem)scheduledItem).start.before(date)).collect(Collectors.toList());
                        list.stream().sorted().filter(scheduledItem -> ((ScheduledItem)scheduledItem).start.before(date)).reduce((scheduledItem, scheduledItem2) -> scheduledItem2).ifPresent(scheduledItem -> list2.add(0, scheduledItem));
                        return list2;
                    });
                    hashMap3.forEach((string, list) -> list.forEach(ScheduledItem::start));
                }
            }
            catch (Exception exception) {
                throw new Exception("ServerListenerStreamPublisher Error from playlist manager is '" + exception.getMessage() + "'", exception);
            }
            iApplicationInstance.getProperties().setProperty("streamPublisherScheduleLoaded", (Object)true);
            return "DONE!";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownStream(IApplicationInstance iApplicationInstance, Stream stream) {
        if (stream == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            List list;
            WMSProperties wMSProperties = iApplicationInstance.getProperties();
            Map map = (Map)wMSProperties.get((Object)"streamPublisherSchedules");
            if (map != null && (list = (List)map.remove(stream.getName())) != null) {
                for (ScheduledItem scheduledItem : list) {
                    scheduledItem.stop();
                }
            }
            wMSProperties.remove((Object)stream.getName());
            stream.closeAndWait();
            list = stream.getPublisher();
            if (list != null) {
                list.unpublish();
                list.close();
            }
            this.logger.info("ServerListenerStreamPublisher: Stream shut down : " + stream.getName());
        }
    }

    public void onServerShutdownComplete(IServer iServer) {
    }

    public void onServerShutdownStart(IServer iServer) {
    }

    public void onServerConfigLoaded(IServer iServer) {
    }

    private class AppInstanceListener
    implements IApplicationInstanceNotify {
        private AppInstanceListener() {
        }

        public void onApplicationInstanceCreate(IApplicationInstance iApplicationInstance) {
        }

        public void onApplicationInstanceDestroy(IApplicationInstance iApplicationInstance) {
            WMSProperties wMSProperties = iApplicationInstance.getProperties();
            Map map = (Map)wMSProperties.remove((Object)"streamPublisherStreams");
            if (map != null) {
                for (Stream stream : map.values()) {
                    ServerListenerStreamPublisher.this.shutdownStream(iApplicationInstance, stream);
                }
            }
        }
    }

    private class StreamListener
    implements IStreamActionNotify {
        private IApplicationInstance appInstance;
        private boolean updateMetadata;

        StreamListener(IApplicationInstance iApplicationInstance, boolean bl) {
            this.appInstance = iApplicationInstance;
            this.updateMetadata = bl;
        }

        public void onPlaylistItemStart(Stream stream, PlaylistItem playlistItem) {
            try {
                String string = playlistItem.getName();
                if (this.appInstance.getProperties().getPropertyBoolean("streamPublisherSendBroadcast", true)) {
                    this.appInstance.broadcastMsg("PlaylistItemStart", new Object[]{string});
                }
                if (this.updateMetadata) {
                    Publisher publisher = stream.getPublisher();
                    AMFDataList aMFDataList = new AMFDataList();
                    aMFDataList.add((AMFData)new AMFDataItem("@setDataFrame"));
                    aMFDataList.add((AMFData)new AMFDataItem("onMetaData"));
                    AMFDataMixedArray aMFDataMixedArray = new AMFDataMixedArray();
                    aMFDataMixedArray.put("title", string);
                    aMFDataList.add((AMFData)aMFDataMixedArray);
                    byte[] byArray = aMFDataList.serialize();
                    long l = Math.max(publisher.getStream().getAudioTC(), publisher.getStream().getVideoTC());
                    publisher.addDataData(byArray, l);
                }
                if (stream.isSwitchLog()) {
                    ServerListenerStreamPublisher.this.logger.info("ServerListenerStreamPublisher PlayList Item Start: " + string);
                }
            }
            catch (Exception exception) {
                ServerListenerStreamPublisher.this.logger.error("ServerListenerStreamPublisher Get Item error: " + exception.getMessage());
            }
        }

        public void onPlaylistItemStop(Stream stream, PlaylistItem playlistItem) {
            if (stream.getPlaylist().contains(playlistItem) && playlistItem.getIndex() == stream.getPlaylist().size() - 1 && !stream.getRepeat() && stream.isUnpublishOnEnd()) {
                Map map = (Map)this.appInstance.getProperties().get((Object)"streamPublisherStreams");
                if (map != null) {
                    map.remove(stream.getName());
                }
                ServerListenerStreamPublisher.this.shutdownStream(this.appInstance, stream);
                ServerListenerStreamPublisher.this.logger.info("ServerListenerStreamPublisher: closing stream: " + stream.getName());
            }
        }
    }

    private class ScheduledItem
    implements Comparable<ScheduledItem> {
        private IApplicationInstance appInstance;
        private Timer timer;
        private Date start;
        private Playlist playlist;
        private Stream stream;

        public ScheduledItem(IApplicationInstance iApplicationInstance, Date date, Playlist playlist, Stream stream) {
            this.appInstance = iApplicationInstance;
            this.start = date;
            this.playlist = playlist;
            this.stream = stream;
            this.timer = new Timer();
        }

        public void start() {
            if (!this.stream.getRepeat()) {
                ServerListenerStreamPublisher.this.logger.info("ServerListenerStreamPublisher stream is set to not repeat, setUnpublishOnEnd: false " + this.stream.getName());
                this.stream.setUnpublishOnEnd(false);
            } else {
                ServerListenerStreamPublisher.this.logger.info("ServerListenerStreamPublisher stream is **NOT** set to not repeat, setUnpublishOnEnd: true " + this.stream.getName());
            }
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    ScheduledItem.this.playlist.open(ScheduledItem.this.stream);
                    ServerListenerStreamPublisher.this.logger.info("ServerListenerStreamPublisher Scheduled stream is now live: " + ScheduledItem.this.stream.getName());
                    ScheduledItem.this.removeFromList();
                    ScheduledItem.this.timer = null;
                }
            }, this.start);
            ServerListenerStreamPublisher.this.logger.info("ServerListenerStreamPublisher scheduled playlist: " + this.playlist.getName() + " on stream: " + this.stream.getName() + " for:" + this.start.toString());
        }

        public void stop() {
            if (this.timer != null) {
                this.timer.cancel();
                ServerListenerStreamPublisher.this.logger.info("ServerListenerStreamPublisher cancelled playlist: " + this.playlist.getName() + " on stream: " + this.stream.getName() + " for:" + this.start.toString());
                this.removeFromList();
                this.timer = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeFromList() {
            Object object = ServerListenerStreamPublisher.this.lock;
            synchronized (object) {
                List list;
                Map map = (Map)this.appInstance.getProperties().get((Object)"streamPublisherSchedules");
                if (map != null && (list = (List)map.get(this.stream.getName())) != null) {
                    list.remove(this);
                    boolean bl = this.playlist.getRepeat() || list.isEmpty() && !this.playlist.getRepeat();
                    this.stream.setUnpublishOnEnd(bl);
                    ServerListenerStreamPublisher.this.logger.info("ServerListenerStreamPublisher.ScheduledItem.removeFromList(): setting stopOnEnd: " + bl + ", playlist.getRepeat(): " + this.playlist.getRepeat() + ", schedules.isEmpty():" + list.isEmpty());
                }
            }
        }

        @Override
        public int compareTo(ScheduledItem scheduledItem) {
            if (this.start.equals(scheduledItem.start)) {
                return 0;
            }
            return this.start.before(scheduledItem.start) ? -1 : 1;
        }
    }
}

