/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.streamresolver;

import com.wowza.util.JSON;
import com.wowza.util.StringUtils;
import com.wowza.util.XMLUtils;
import com.wowza.wms.application.ApplicationInstance;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.bootstrap.Bootstrap;
import com.wowza.wms.client.IClient;
import com.wowza.wms.httpstreamer.cupertinostreaming.httpstreamer.HTTPStreamerSessionCupertino;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.httpstreamer.mpegdashstreaming.httpstreamer.HTTPStreamerSessionMPEGDash;
import com.wowza.wms.httpstreamer.sanjosestreaming.httpstreamer.HTTPStreamerSessionSanJose;
import com.wowza.wms.httpstreamer.smoothstreaming.httpstreamer.HTTPStreamerSessionSmoothStreamer;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.mediacaster.IMediaCaster;
import com.wowza.wms.mediacaster.IMediaCasterNotify2;
import com.wowza.wms.mediacaster.MediaCaster;
import com.wowza.wms.mediacaster.MediaCasterItem;
import com.wowza.wms.mediacaster.MediaCasterNotifyBase;
import com.wowza.wms.mediacaster.MediaCasterStreamId;
import com.wowza.wms.mediacaster.MediaCasterStreamItem;
import com.wowza.wms.mediacaster.wowza.LiveMediaStreamReceiver;
import com.wowza.wms.medialist.MediaList;
import com.wowza.wms.medialist.MediaListRendition;
import com.wowza.wms.medialist.MediaListSegment;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.plugin.streamresolver.Message;
import com.wowza.wms.plugin.streamresolver.UDPClient;
import com.wowza.wms.rtp.model.RTPSession;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamNameAliasProvider;
import com.wowza.wms.stream.IMediaStreamPlay;
import com.wowza.wms.stream.MediaStream;
import com.wowza.wms.stream.MediaStreamNameAliasProviderBase;
import com.wowza.wms.util.MediaListUtils;
import com.wowza.wms.util.ModuleUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ModuleStreamResolver
extends ModuleBase {
    public static String MODULE_NAME = "ModuleStreamResolver";
    public static String MODULE_PROPERTY_PREFIX = "wowzaResolver";
    private static final int _UDP_PORT = 9777;
    private static final int _UDP_REQUEST_TIMEOUT = 2000;
    private static final String _PROTOCOL = "wowz";
    private static Executor executor = Executors.newCachedThreadPool();
    private Object lock = new Object();
    private Map<String, Lookup> lookups = new HashMap<String, Lookup>();
    private Map<String, String> urls = new HashMap<String, String>();
    private Map<String, List<IMediaStreamPlay>> players = new HashMap<String, List<IMediaStreamPlay>>();
    private int port;
    private int timeout;
    private int maxRetries = 2;
    private String protocol = "";
    private IApplicationInstance appInstance;
    private String targetPath = null;
    private boolean useExternalFile = false;
    private long lastFileModification = 0L;
    private String lastOriginSetting = "";
    private WMSLogger logger = null;
    private boolean debug = false;
    private String defaultApplicationName;
    private String defaultApplicationInstanceName;

    public void onAppStart(IApplicationInstance iApplicationInstance) {
        this.appInstance = iApplicationInstance;
        this.logger = WMSLoggerFactory.getLoggerObj((IApplicationInstance)iApplicationInstance);
        this.port = iApplicationInstance.getProperties().getPropertyInt(MODULE_PROPERTY_PREFIX + "UDPClientPort", 9777);
        this.timeout = iApplicationInstance.getProperties().getPropertyInt(MODULE_PROPERTY_PREFIX + "UDPClientTimeout", 2000);
        this.protocol = iApplicationInstance.getProperties().getPropertyStr(MODULE_PROPERTY_PREFIX + "Protocol", _PROTOCOL);
        this.maxRetries = iApplicationInstance.getProperties().getPropertyInt(MODULE_PROPERTY_PREFIX + "ConnectMaxRetries", this.maxRetries);
        this.debug = iApplicationInstance.getProperties().getPropertyBoolean(MODULE_PROPERTY_PREFIX + "DebugLog", this.debug);
        if (this.logger.isDebugEnabled()) {
            this.debug = true;
        }
        if (this.debug) {
            MediaCaster.debugLog = true;
        }
        if (iApplicationInstance.getProperties().containsKey((Object)(MODULE_PROPERTY_PREFIX + "ConfTargetPath"))) {
            this.useExternalFile = true;
            this.targetPath = iApplicationInstance.decodeStorageDir(iApplicationInstance.getProperties().getPropertyStr(MODULE_PROPERTY_PREFIX + "ConfTargetPath", null));
        }
        this.defaultApplicationName = iApplicationInstance.getProperties().getPropertyStr(MODULE_PROPERTY_PREFIX + "OriginApplicationName", iApplicationInstance.getApplication().getName());
        this.defaultApplicationInstanceName = iApplicationInstance.getProperties().getPropertyStr(MODULE_PROPERTY_PREFIX + "OriginApplicationInstanceName", iApplicationInstance.getName());
        this.logger.info(MODULE_NAME + ".onAppStart [" + iApplicationInstance.getContextStr() + " : build #49]");
        iApplicationInstance.setStreamNameAliasProvider((IMediaStreamNameAliasProvider)new AliasProvider());
        iApplicationInstance.addMediaCasterListener((IMediaCasterNotify2)new MediaCasterListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStreamDestroy(IMediaStream iMediaStream) {
        IMediaStreamPlay iMediaStreamPlay;
        if (iMediaStream != null && !iMediaStream.isMediaCasterPlay() && (iMediaStreamPlay = iMediaStream.getPlayer()) != null) {
            Object object = this.lock;
            synchronized (object) {
                Iterator<String> iterator = this.players.keySet().iterator();
                while (iterator.hasNext()) {
                    this.players.get(iterator.next()).remove(iMediaStreamPlay);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onHTTPSessionDestroy(IHTTPStreamerSession iHTTPStreamerSession) {
        IMediaStreamPlay iMediaStreamPlay;
        IMediaStream iMediaStream = iHTTPStreamerSession.getStream();
        if (iMediaStream != null && !iMediaStream.isMediaCasterPlay() && (iMediaStreamPlay = iMediaStream.getPlayer()) != null) {
            Object object = this.lock;
            synchronized (object) {
                Iterator<String> iterator = this.players.keySet().iterator();
                while (iterator.hasNext()) {
                    this.players.get(iterator.next()).remove(iMediaStreamPlay);
                }
            }
        }
    }

    private String getNewURLs() {
        if (this.useExternalFile) {
            return this.getNewURLsFromConfig();
        }
        return this.getNewPropertyURLs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNewURLsFromConfig() {
        Object object;
        long l = 0L;
        try {
            if (this.targetPath == null || this.targetPath.isEmpty()) {
                this.logger.error(MODULE_NAME + ".getNewURLsFromConfig could not find valid target file " + this.targetPath);
                return null;
            }
            object = new File(this.targetPath);
            if (!((File)object).exists()) {
                this.logger.error(MODULE_NAME + ".getNewURLsFromConfig could not find valid target file " + this.targetPath);
                return null;
            }
            l = ((File)object).lastModified();
            if (this.lastFileModification != 0L && this.lastFileModification == l) {
                return this.lastOriginSetting;
            }
        }
        catch (Exception exception) {
            this.logger.error(MODULE_NAME + ".getNewURLsFromConfig Exception", (Throwable)exception);
            return null;
        }
        object = "";
        FileInputStream fileInputStream = null;
        BufferedReader bufferedReader = null;
        try {
            fileInputStream = new FileInputStream(this.targetPath);
            bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            String string = "";
            while ((string = bufferedReader.readLine()) != null) {
                if ((string = string.trim()).startsWith("#") || string.length() <= 0) continue;
                object = (String)object + string + ",";
            }
            object = ((String)object).replaceAll("[\\,\\s]+$", "");
        }
        catch (Exception exception) {
            this.logger.info(MODULE_NAME + ".getNewURLsFromConfig Exception", (Throwable)exception);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
            bufferedReader = null;
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
            fileInputStream = null;
        }
        this.logger.info(MODULE_NAME + ".getNewURLsFromConfig " + (String)object);
        this.lastFileModification = l;
        this.lastOriginSetting = object;
        return object;
    }

    private String getNewPropertyURLs() {
        String string = Bootstrap.getServerHome((int)2) + "/conf/" + this.appInstance.getApplication().getName() + "/Application.xml";
        if (this.debug) {
            this.logger.info(MODULE_NAME + ".getNewURLs: fileURL " + string);
        }
        if (string != null) {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(string);
                XPathFactory xPathFactory = XMLUtils.newXPathFactory();
                xPathFactory.newXPath();
                if (document != null) {
                    Element element = document.getDocumentElement();
                    XMLUtils.getVersion((Element)element);
                    String string2 = "/Root/Application/Properties/Property";
                    WMSProperties wMSProperties = new WMSProperties();
                    XMLUtils.loadConfigProperies((Element)element, (String)string2, (WMSProperties)wMSProperties);
                    return wMSProperties.getPropertyStr(MODULE_PROPERTY_PREFIX + "OriginServers", null);
                }
            }
            catch (Exception exception) {
                this.logger.error(MODULE_NAME + "getNewURLs: error parsing app config file: (" + string + ")", (Throwable)exception);
            }
        }
        return this.appInstance.getProperties().getPropertyStr(MODULE_PROPERTY_PREFIX + "OriginServers", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String lookupURL(String string, boolean bl) {
        Lookup lookup = null;
        if (this.debug) {
            this.logger.info(MODULE_NAME + ".lookupUrl Looking up url for [" + this.appInstance.getContextStr() + "/" + string + "] lookups: " + this.lookups.toString() + ", urls: " + this.urls.toString(), "application", "comment");
        }
        Object object = this.lock;
        synchronized (object) {
            if (!bl && this.urls.containsKey(string)) {
                String string2 = this.urls.get(string);
                if (this.debug) {
                    this.logger.info(MODULE_NAME + ".lookupUrl from urls list, returning url for [" + this.appInstance.getContextStr() + "/" + string + "] url: " + string2, "application", "comment");
                }
                return string2;
            }
            lookup = this.lookups.get(string);
            if (lookup == null) {
                lookup = new Lookup(string);
                lookup.start();
                this.lookups.put(string, lookup);
                if (this.debug) {
                    this.logger.info(MODULE_NAME + ".lookupUrl adding new lookup url for [" + this.appInstance.getContextStr() + "/" + string + "] lookup: " + lookup.toString(), "application", "comment");
                }
            }
        }
        try {
            if (this.debug) {
                this.logger.info(MODULE_NAME + ".lookupUrl joining existing lookup for [" + this.appInstance.getContextStr() + "/" + string + "] lookup: " + lookup.toString(), "application", "comment");
            }
            lookup.join(this.timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.debug) {
            this.logger.info(MODULE_NAME + ".lookupUrl after lookup, returning url for [" + this.appInstance.getContextStr() + "/" + string + "] url: " + lookup.url, "application", "comment");
        }
        return StringUtils.isEmpty((String)lookup.url) ? "" : lookup.url;
    }

    private boolean isStreamUrl(String string) {
        return string.matches("^(rtmp|wowz)[ste]*://.+$");
    }

    private String getStreamExt(String string) {
        String string2 = MediaStream.BASE_STREAM_EXT;
        if (string != null) {
            if (string.toLowerCase().endsWith(".smil") || string.toLowerCase().endsWith(".smi")) {
                string2 = "smil";
            }
            String[] stringArray = ModuleUtils.decodeStreamExtension((String)string, (String)string2);
            string2 = stringArray[1];
        }
        return string2;
    }

    private boolean isMediaList(String string) {
        String string2 = this.getStreamExt(string);
        return this.appInstance.getMediaReaderContentType(string2) == 2;
    }

    private boolean checkMediaListAvailability(IApplicationInstance iApplicationInstance, String string, IHTTPStreamerSession iHTTPStreamerSession) {
        List list;
        MediaListSegment mediaListSegment;
        boolean bl = false;
        String string2 = this.getStreamExt(string);
        String[] stringArray = ModuleUtils.decodeStreamExtension((String)string, (String)string2);
        MediaList mediaList = MediaListUtils.parseMediaList((IApplicationInstance)iApplicationInstance, (String)(string = stringArray[0]), (String)(string2 = stringArray[1]), (IHTTPStreamerSession)iHTTPStreamerSession);
        if (mediaList != null && (mediaListSegment = mediaList.getFirstSegment()) != null && !(list = mediaListSegment.getRenditions()).isEmpty()) {
            int n = 0;
            int n2 = 0;
            for (MediaListRendition mediaListRendition : list) {
                if (mediaListRendition.getType() != 8 && mediaListRendition.getType() != 9) continue;
                ++n;
                String string3 = mediaListRendition.getName();
                if (iApplicationInstance.resolvePlayAlias(string3, iHTTPStreamerSession) == null) continue;
                ++n2;
            }
            if (n > 0) {
                bl = n2 == list.size();
            }
        }
        return bl;
    }

    class StreamRequest
    implements Callable<String> {
        private final String appName;
        private final String appInstance;
        private final String streamName;
        private final String host;
        private final int port;
        private final int udpTimeout;

        public StreamRequest(String string, String string2, String string3, String string4, int n, int n2) {
            this.streamName = string2;
            this.appInstance = string3;
            this.appName = string4;
            this.port = n;
            this.udpTimeout = n2;
            this.host = string;
        }

        private String sendUDPMessage() {
            Object object;
            if (ModuleStreamResolver.this.debug) {
                ModuleStreamResolver.this.logger.info(MODULE_NAME + "[sendUDPMessage] this.host:: " + this.host + " :: this.port :: " + this.port);
            }
            UDPClient uDPClient = new UDPClient(this.host, this.port, this.udpTimeout, ModuleStreamResolver.this.logger, ModuleStreamResolver.this.debug);
            String string = this.streamName;
            if (string.contains("/")) {
                object = string.split("/");
                string = object[((String[])object).length - 1].trim();
            }
            object = new Message();
            object.streamName = string;
            object.appInstance = this.appInstance;
            object.appName = this.appName;
            String string2 = uDPClient.send((Message)object);
            if (ModuleStreamResolver.this.debug) {
                ModuleStreamResolver.this.logger.info(MODULE_NAME + "[sendUDPMessage] response from host :: " + this.host + " :: " + string2);
            }
            if (string2 != null && string2.length() > 0) {
                try {
                    JSON jSON = new JSON(string2);
                    if (!jSON.containsKey("error")) {
                        String string3 = jSON.getString("server");
                        return string3;
                    }
                }
                catch (Exception exception) {
                    ModuleStreamResolver.this.logger.error(MODULE_NAME + "[sendUDPMessage] error parsing response from host :: " + this.host + " :: " + string2, (Throwable)exception);
                }
            }
            return null;
        }

        @Override
        public String call() throws Exception {
            return this.sendUDPMessage();
        }
    }

    class Lookup
    extends Thread {
        long startTime;
        String streamName;
        String url;

        Lookup(String string) {
            super(MODULE_NAME + ".Lookup [" + ModuleStreamResolver.this.appInstance.getContextStr() + "/" + string + "]");
            this.startTime = System.currentTimeMillis();
            this.streamName = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Object object;
            ArrayList<Future<String>> arrayList = new ArrayList<Future<String>>();
            ExecutorCompletionService<String> executorCompletionService = new ExecutorCompletionService<String>(executor);
            try {
                object = ModuleStreamResolver.this.getNewURLs();
                if (ModuleStreamResolver.this.debug) {
                    ModuleStreamResolver.this.logger.info("**Checking hostnames ... " + (String)object);
                }
                if (StringUtils.isEmpty((String)object)) return;
                String[] stringArray = ((String)object).split(",");
                for (String string : stringArray) {
                    arrayList.add(executorCompletionService.submit(new StreamRequest(string, this.streamName, ModuleStreamResolver.this.defaultApplicationInstanceName, ModuleStreamResolver.this.defaultApplicationName, ModuleStreamResolver.this.port, ModuleStreamResolver.this.timeout)));
                }
                do {
                    if (arrayList.isEmpty()) return;
                    Future future = executorCompletionService.take();
                    arrayList.remove(future);
                    this.url = (String)future.get();
                } while (this.url == null);
                if (!ModuleStreamResolver.this.isStreamUrl(this.url.toLowerCase())) {
                    this.url = ModuleStreamResolver.this.protocol + "://" + this.url;
                    this.url = this.url.trim();
                }
                if (ModuleStreamResolver.this.debug) {
                    ModuleStreamResolver.this.logger.info(MODULE_NAME + ".Lookup.run() before adding url for [" + ModuleStreamResolver.this.appInstance.getContextStr() + "/" + this.streamName + "] Lookup.url: " + this.url + ", urls: " + ModuleStreamResolver.this.urls.toString(), "application", "comment");
                }
                Object object2 = ModuleStreamResolver.this.lock;
                synchronized (object2) {
                    ModuleStreamResolver.this.urls.put(this.streamName, this.url);
                    if (!ModuleStreamResolver.this.debug) return;
                    ModuleStreamResolver.this.logger.info(MODULE_NAME + ".Lookup.run() after adding url for [" + ModuleStreamResolver.this.appInstance.getContextStr() + "/" + this.streamName + "] Lookup.url: " + this.url + ", urls: " + ModuleStreamResolver.this.urls.toString(), "application", "comment");
                    return;
                }
            }
            catch (Exception exception) {
                return;
            }
            finally {
                if (!arrayList.isEmpty()) {
                    for (Future future : arrayList) {
                        future.cancel(true);
                    }
                    arrayList.clear();
                }
                if (ModuleStreamResolver.this.debug) {
                    ModuleStreamResolver.this.logger.info(MODULE_NAME + ".Lookup.run() before removing lookups for [" + ModuleStreamResolver.this.appInstance.getContextStr() + "/" + this.streamName + "] lookups: " + ModuleStreamResolver.this.lookups.toString(), "application", "comment");
                }
                object = ModuleStreamResolver.this.lock;
                synchronized (object) {
                    ModuleStreamResolver.this.lookups.remove(this.streamName);
                    if (ModuleStreamResolver.this.debug) {
                        ModuleStreamResolver.this.logger.info(MODULE_NAME + ".Lookup.run() after removing lookups for [" + ModuleStreamResolver.this.appInstance.getContextStr() + "/" + this.streamName + "] lookups: " + ModuleStreamResolver.this.lookups.toString(), "application", "comment");
                    }
                }
            }
        }

        @Override
        public String toString() {
            return "Lookup: {streamName: " + this.streamName + ", name: " + this.streamName + ", startTime: " + this.startTime + ", url: " + this.url + "}";
        }
    }

    class MediaCasterListener
    extends MediaCasterNotifyBase {
        MediaCasterListener() {
        }

        public void onMediaCasterCreate(IMediaCaster iMediaCaster) {
            if (iMediaCaster instanceof LiveMediaStreamReceiver && !((LiveMediaStreamReceiver)iMediaCaster).isTryConnect()) {
                if (ModuleStreamResolver.this.debug) {
                    ModuleStreamResolver.this.logger.info(MODULE_NAME + ".onMediaCasterCreate shutting down mediaCaster due to no url: [" + ModuleStreamResolver.this.appInstance.getContextStr() + "/" + iMediaCaster.getMediaCasterId() + "]");
                }
                ModuleStreamResolver.this.appInstance.getVHost().getThreadPool().execute((Runnable)new MediaCasterShutdownRunner((LiveMediaStreamReceiver)iMediaCaster));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onRegisterPlayer(IMediaCaster iMediaCaster, IMediaStreamPlay iMediaStreamPlay) {
            String string = iMediaCaster.getMediaCasterId();
            if (iMediaCaster instanceof LiveMediaStreamReceiver) {
                if (ModuleStreamResolver.this.debug) {
                    ModuleStreamResolver.this.logger.info(MODULE_NAME + ".onRegisterPlayer before adding player for [" + ModuleStreamResolver.this.appInstance.getContextStr() + "/" + string + "] players: " + ModuleStreamResolver.this.players.toString(), "application", "comment");
                }
                Object object = ModuleStreamResolver.this.lock;
                synchronized (object) {
                    ArrayList<IMediaStreamPlay> arrayList = (ArrayList<IMediaStreamPlay>)ModuleStreamResolver.this.players.get(string);
                    if (arrayList == null) {
                        arrayList = new ArrayList<IMediaStreamPlay>();
                        ModuleStreamResolver.this.players.put(string, arrayList);
                    }
                    arrayList.add(iMediaStreamPlay);
                    if (ModuleStreamResolver.this.debug) {
                        ModuleStreamResolver.this.logger.info(MODULE_NAME + ".onRegisterPlayer after adding player for [" + ModuleStreamResolver.this.appInstance.getContextStr() + "/" + string + "] players: " + ModuleStreamResolver.this.players.toString(), "application", "comment");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onUnRegisterPlayer(IMediaCaster iMediaCaster, IMediaStreamPlay iMediaStreamPlay) {
            String string = iMediaCaster.getMediaCasterId();
            if (iMediaCaster instanceof LiveMediaStreamReceiver) {
                if (ModuleStreamResolver.this.debug) {
                    ModuleStreamResolver.this.logger.info(MODULE_NAME + ".onUnRegisterPlayer before removing player for [" + ModuleStreamResolver.this.appInstance.getContextStr() + "/" + string + "] players: " + ModuleStreamResolver.this.players.toString(), "application", "comment");
                }
                Object object = ModuleStreamResolver.this.lock;
                synchronized (object) {
                    List list = (List)ModuleStreamResolver.this.players.get(string);
                    if (list != null) {
                        list.remove(iMediaStreamPlay);
                    }
                    if (ModuleStreamResolver.this.debug) {
                        ModuleStreamResolver.this.logger.info(MODULE_NAME + ".onUnRegisterPlayer after removing player for [" + ModuleStreamResolver.this.appInstance.getContextStr() + "/" + string + "] players: " + ModuleStreamResolver.this.players.toString(), "application", "comment");
                    }
                }
            }
        }

        public void onConnectSuccess(IMediaCaster iMediaCaster) {
            if (iMediaCaster instanceof LiveMediaStreamReceiver) {
                if (ModuleStreamResolver.this.debug) {
                    ModuleStreamResolver.this.logger.info(MODULE_NAME + "onConnectSuccess name: " + iMediaCaster.getMediaCasterId());
                    ModuleStreamResolver.this.logger.info(MODULE_NAME + "onConnectSuccess isTryConnect: " + ((LiveMediaStreamReceiver)iMediaCaster).isTryConnect());
                    ModuleStreamResolver.this.logger.info(MODULE_NAME + "onConnectSuccess isValid: " + iMediaCaster.getMediaCasterStreamItem().isValid());
                }
                LiveMediaStreamReceiver liveMediaStreamReceiver = (LiveMediaStreamReceiver)iMediaCaster;
                int n = liveMediaStreamReceiver.getProperties().getPropertyInt("connectRetryCount", 0);
                if (++n > ModuleStreamResolver.this.maxRetries) {
                    System.out.println("onConnectSuccess calling resolveMediaCasterURL: " + n);
                    this.resolveMediaCasterURL(liveMediaStreamReceiver);
                }
                liveMediaStreamReceiver.getProperties().setProperty("connectRetryCount", (Object)n);
            }
        }

        public void onConnectFailure(IMediaCaster iMediaCaster) {
            if (iMediaCaster instanceof LiveMediaStreamReceiver) {
                System.out.println("onConnectFalure calling resolveMediaCasterURL");
                this.resolveMediaCasterURL((LiveMediaStreamReceiver)iMediaCaster);
            }
        }

        private void resolveMediaCasterURL(final LiveMediaStreamReceiver liveMediaStreamReceiver) {
            ModuleStreamResolver.this.appInstance.getVHost().getThreadPool().execute(new Runnable(){

                @Override
                public void run() {
                    String string;
                    liveMediaStreamReceiver.getProperties().remove((Object)"connectRetryCount");
                    MediaCasterStreamId mediaCasterStreamId = MediaCasterItem.parseIdString((String)liveMediaStreamReceiver.getMediaCasterId());
                    String string2 = mediaCasterStreamId.getName();
                    String string3 = mediaCasterStreamId.getLiveStreamPacketizer();
                    if (ModuleStreamResolver.this.debug) {
                        ModuleStreamResolver.this.logger.info(MODULE_NAME + ".onMediaCasterCreate resolving stream name: [" + ModuleStreamResolver.this.appInstance.getContextStr() + "/" + string2 + "]");
                    }
                    if (StringUtils.isEmpty((String)(string = ModuleStreamResolver.this.lookupURL(string2, true)))) {
                        if (ModuleStreamResolver.this.debug) {
                            ModuleStreamResolver.this.logger.info(MODULE_NAME + ".onMediaCasterCreate shutting down players due to no mediaCaster url: [" + ModuleStreamResolver.this.appInstance.getContextStr() + "/" + string2 + "]");
                        }
                        MediaCasterListener.this.shutdownPlayers((IMediaCaster)liveMediaStreamReceiver);
                        if (ModuleStreamResolver.this.debug) {
                            ModuleStreamResolver.this.logger.info(MODULE_NAME + ".onMediaCasterCreate shutting down mediaCaster due to no url: [" + ModuleStreamResolver.this.appInstance.getContextStr() + "/" + liveMediaStreamReceiver.getMediaCasterId() + "]");
                        }
                        liveMediaStreamReceiver.setTryConnect(false);
                        ModuleStreamResolver.this.appInstance.getVHost().getThreadPool().execute((Runnable)new MediaCasterShutdownRunner(liveMediaStreamReceiver));
                    } else {
                        liveMediaStreamReceiver.resolveURL();
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void shutdownPlayers(IMediaCaster iMediaCaster) {
            String string = iMediaCaster.getMediaCasterId();
            List list = null;
            if (ModuleStreamResolver.this.debug) {
                ModuleStreamResolver.this.logger.info(MODULE_NAME + ".shutdownPlayers before removing player list for [" + ModuleStreamResolver.this.appInstance.getContextStr() + "/" + string + "] players: " + ModuleStreamResolver.this.players.toString(), "application", "comment");
            }
            Iterator iterator = ModuleStreamResolver.this.lock;
            synchronized (iterator) {
                list = (List)ModuleStreamResolver.this.players.remove(string);
                if (ModuleStreamResolver.this.debug) {
                    ModuleStreamResolver.this.logger.info(MODULE_NAME + ".shutdownPlayers after removing player list for [" + ModuleStreamResolver.this.appInstance.getContextStr() + "/" + string + "] players: " + ModuleStreamResolver.this.players.toString(), "application", "comment");
                }
            }
            if (list != null) {
                if (ModuleStreamResolver.this.debug) {
                    ModuleStreamResolver.this.logger.info(MODULE_NAME + ".shutdownPlayers waiting for lock for [" + ModuleStreamResolver.this.appInstance.getContextStr() + "/" + string + "]", "application", "comment");
                }
                try {
                    if (ModuleStreamResolver.this.debug) {
                        ModuleStreamResolver.this.logger.info(MODULE_NAME + ".shutdownPlayers got lock for [" + ModuleStreamResolver.this.appInstance.getContextStr() + "/" + string + "]", "application", "comment");
                    }
                    for (IMediaStreamPlay iMediaStreamPlay : list) {
                        IMediaStream iMediaStream = iMediaStreamPlay.getParent();
                        if (iMediaStream == null) continue;
                        if (iMediaStream.getClient() != null) {
                            iMediaStream.getClient().setShutdownClient(true);
                        }
                        if (iMediaStream.getRTPStream() != null) {
                            ModuleStreamResolver.this.appInstance.getVHost().getRTPContext().shutdownRTPSession(iMediaStream.getRTPStream().getSession());
                        }
                        if (iMediaStream.getHTTPStreamerSession() == null) continue;
                        iMediaStream.getHTTPStreamerSession().rejectSession();
                        iMediaStream.getHTTPStreamerSession().setDeleteSession();
                    }
                }
                catch (Exception exception) {
                    ModuleStreamResolver.getLogger().error("ModuleStreamResolver.MediaCasterListener.shutdownPlayers exception: " + exception.getMessage(), (Throwable)exception);
                }
                finally {
                    if (ModuleStreamResolver.this.debug) {
                        ModuleStreamResolver.this.logger.info(MODULE_NAME + ".shutdownPlayers released lock for [" + ModuleStreamResolver.this.appInstance.getContextStr() + "/" + string + "]", "application", "comment");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMediaCasterDestroy(IMediaCaster iMediaCaster) {
            String string = iMediaCaster.getMediaCasterId();
            String string2 = MediaCasterItem.parseIdString((String)string).getName();
            if (iMediaCaster instanceof LiveMediaStreamReceiver) {
                if (ModuleStreamResolver.this.debug) {
                    ModuleStreamResolver.this.logger.info(MODULE_NAME + ".onMediaCasterDestroy before removing url and players for [" + ModuleStreamResolver.this.appInstance.getContextStr() + "/(" + string2 + ":" + string + ")] urls: " + ModuleStreamResolver.this.urls.toString() + ", players: " + ModuleStreamResolver.this.players.toString(), "application", "comment");
                }
                Object object = ModuleStreamResolver.this.lock;
                synchronized (object) {
                    ModuleStreamResolver.this.urls.remove(string2);
                    ModuleStreamResolver.this.players.remove(string);
                    if (ModuleStreamResolver.this.debug) {
                        ModuleStreamResolver.this.logger.info(MODULE_NAME + ".onMediaCasterDestroy after removing url and players for [" + ModuleStreamResolver.this.appInstance.getContextStr() + "/(" + string2 + ":" + string + ")] urls: " + ModuleStreamResolver.this.urls.toString() + ", players: " + ModuleStreamResolver.this.players.toString(), "application", "comment");
                    }
                }
            }
        }

        public void onStreamStart(IMediaCaster iMediaCaster) {
            if (iMediaCaster instanceof LiveMediaStreamReceiver) {
                ((LiveMediaStreamReceiver)iMediaCaster).getProperties().remove((Object)"connectRetryCount");
            }
        }

        public void onStreamStop(IMediaCaster iMediaCaster) {
            if (iMediaCaster instanceof LiveMediaStreamReceiver && iMediaCaster.getStreamTimeoutReason() != 100) {
                this.resolveMediaCasterURL((LiveMediaStreamReceiver)iMediaCaster);
            }
        }
    }

    class MediaCasterShutdownRunner
    implements Runnable {
        final LiveMediaStreamReceiver liveMediaStreamReceiver;

        MediaCasterShutdownRunner(LiveMediaStreamReceiver liveMediaStreamReceiver) {
            this.liveMediaStreamReceiver = liveMediaStreamReceiver;
        }

        @Override
        public void run() {
            MediaCasterStreamItem mediaCasterStreamItem = this.liveMediaStreamReceiver.getMediaCasterStreamItem();
            if (mediaCasterStreamItem != null) {
                ModuleStreamResolver.this.appInstance.getMediaCasterStreams().remove(mediaCasterStreamItem);
                mediaCasterStreamItem.shutdown(false);
            }
        }
    }

    class AliasProvider
    extends MediaStreamNameAliasProviderBase {
        AliasProvider() {
        }

        public String resolvePlayAlias(IApplicationInstance iApplicationInstance, String string) {
            if (ModuleStreamResolver.this.isMediaList(string)) {
                return string;
            }
            String string2 = this.getStreamName(string);
            if (string2 == null && iApplicationInstance.getClientCountTotal() <= 0) {
                iApplicationInstance.incClientCountTotal();
                ((ApplicationInstance)iApplicationInstance).setClientRemoveTime(System.currentTimeMillis());
            }
            return string2;
        }

        public String resolvePlayAlias(IApplicationInstance iApplicationInstance, String string, IClient iClient) {
            if (ModuleStreamResolver.this.isMediaList(string)) {
                return string;
            }
            String string2 = this.getStreamName(string);
            if (string2 == null && iApplicationInstance.getClientCountTotal() <= 0) {
                iApplicationInstance.incClientCountTotal();
                ((ApplicationInstance)iApplicationInstance).setClientRemoveTime(System.currentTimeMillis());
            }
            return string2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String resolvePlayAlias(IApplicationInstance iApplicationInstance, String string, IHTTPStreamerSession iHTTPStreamerSession) {
            IMediaStreamPlay iMediaStreamPlay;
            IMediaStream iMediaStream;
            Object object;
            if (ModuleStreamResolver.this.isMediaList(string)) {
                if (!ModuleStreamResolver.this.checkMediaListAvailability(iApplicationInstance, string, iHTTPStreamerSession)) {
                    return null;
                }
                return string;
            }
            String string2 = null;
            String string3 = null;
            if (iHTTPStreamerSession != null && iHTTPStreamerSession.getHTTPStreamerAdapter() != null && (object = iHTTPStreamerSession.getHTTPStreamerAdapter().getHTTPStreamerItem()) != null) {
                string2 = object.getLiveStreamPacketizer();
                string3 = object.getLiveStreamRepeater();
            }
            if (string2 == null) {
                string2 = this.resolvePacketizer(iHTTPStreamerSession);
            }
            if (string3 == null) {
                string3 = this.resolveRepeater(iHTTPStreamerSession);
            }
            if ((object = this.getStreamName(string, string2, string3)) == null && iApplicationInstance.getClientCountTotal() <= 0) {
                iApplicationInstance.incClientCountTotal();
                ((ApplicationInstance)iApplicationInstance).setClientRemoveTime(System.currentTimeMillis());
            }
            if (StringUtils.isEmpty((String)object)) {
                if (ModuleStreamResolver.this.debug) {
                    ModuleStreamResolver.this.logger.info(MODULE_NAME + ".resolvePlayAlias[HttpStreamerSession] after getSteamName [" + iApplicationInstance.getContextStr() + "/[" + string2 + "|" + string3 + "]" + string + "] returned streamName is null", "application", "comment");
                }
                return null;
            }
            String string4 = "[" + string2 + "|" + string3 + "]" + (String)object;
            if (ModuleStreamResolver.this.debug) {
                ModuleStreamResolver.this.logger.info(MODULE_NAME + ".resolvePlayAlias[HttpStreamerSession] before adding player for [" + iApplicationInstance.getContextStr() + "/" + string4 + "] players: " + ModuleStreamResolver.this.players.toString(), "application", "comment");
            }
            if ((iMediaStream = iHTTPStreamerSession.getStream()) != null && !iMediaStream.isMediaCasterPlay() && (iMediaStreamPlay = iMediaStream.getPlayer()) != null) {
                Object object2 = ModuleStreamResolver.this.lock;
                synchronized (object2) {
                    ArrayList<IMediaStreamPlay> arrayList = (ArrayList<IMediaStreamPlay>)ModuleStreamResolver.this.players.get(string4);
                    if (arrayList == null) {
                        arrayList = new ArrayList<IMediaStreamPlay>();
                        ModuleStreamResolver.this.players.put(string4, arrayList);
                    }
                    if (!arrayList.contains(iMediaStreamPlay)) {
                        arrayList.add(iMediaStreamPlay);
                        if (ModuleStreamResolver.this.debug) {
                            ModuleStreamResolver.this.logger.info(MODULE_NAME + ".resolvePlayAlias[HttpStreamerSession] after adding player for [" + iApplicationInstance.getContextStr() + "/" + string4 + "] players: " + ModuleStreamResolver.this.players.toString(), "application", "comment");
                        }
                    }
                }
            }
            return object;
        }

        private String resolvePacketizer(IHTTPStreamerSession iHTTPStreamerSession) {
            String string = null;
            if (iHTTPStreamerSession instanceof HTTPStreamerSessionCupertino) {
                string = "cupertinostreamingpacketizer";
            } else if (iHTTPStreamerSession instanceof HTTPStreamerSessionSanJose) {
                string = "sanjosestreamingpacketizer";
            } else if (iHTTPStreamerSession instanceof HTTPStreamerSessionSmoothStreamer) {
                string = "smoothstreamingpacketizer";
            } else if (iHTTPStreamerSession instanceof HTTPStreamerSessionMPEGDash) {
                string = "mpegdashstreamingpacketizer";
            }
            return string;
        }

        private String resolveRepeater(IHTTPStreamerSession iHTTPStreamerSession) {
            String string = null;
            if (iHTTPStreamerSession instanceof HTTPStreamerSessionCupertino) {
                string = "cupertinostreamingrepeater";
            } else if (iHTTPStreamerSession instanceof HTTPStreamerSessionSanJose) {
                string = "sanjosestreamingrepeater";
            } else if (iHTTPStreamerSession instanceof HTTPStreamerSessionSmoothStreamer) {
                string = "smoothstreamingrepeater";
            } else if (iHTTPStreamerSession instanceof HTTPStreamerSessionMPEGDash) {
                string = "mpegdashstreamingrepeater";
            }
            return string;
        }

        public String resolvePlayAlias(IApplicationInstance iApplicationInstance, String string, RTPSession rTPSession) {
            if (ModuleStreamResolver.this.isMediaList(string)) {
                return string;
            }
            String string2 = this.getStreamName(string);
            if (string2 == null && iApplicationInstance.getClientCountTotal() <= 0) {
                iApplicationInstance.incClientCountTotal();
                ((ApplicationInstance)iApplicationInstance).setClientRemoveTime(System.currentTimeMillis());
            }
            return string2;
        }

        private String getStreamName(String string) {
            return this.getStreamName(string, null, null);
        }

        private String getStreamName(String string, String string2, String string3) {
            int n;
            string = ModuleStreamResolver.this.appInstance.getProperties().getPropertyStr(MODULE_PROPERTY_PREFIX + "OriginStreamName", string);
            String string4 = string = ModuleUtils.decodeStreamExtension((String)string, null)[0];
            if (ModuleStreamResolver.this.debug) {
                ModuleStreamResolver.this.logger.info(MODULE_NAME + ".getStreamName[" + string4 + "] ");
            }
            MediaCasterStreamItem mediaCasterStreamItem = ModuleStreamResolver.this.appInstance.getMediaCasterStreams().getMediaCaster(string4, string2, string3);
            IMediaCaster iMediaCaster = null;
            if (mediaCasterStreamItem != null && (iMediaCaster = mediaCasterStreamItem.getMediaCaster()) != null && (n = iMediaCaster.getStreamTimeoutReason()) == 100) {
                return string4;
            }
            String string5 = ModuleStreamResolver.this.lookupURL(string4, false);
            if (!StringUtils.isEmpty((String)string5) && iMediaCaster != null && iMediaCaster instanceof LiveMediaStreamReceiver) {
                ((LiveMediaStreamReceiver)iMediaCaster).resolveURL();
            }
            return StringUtils.isEmpty((String)string5) ? null : string4;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String resolveStreamAlias(IApplicationInstance iApplicationInstance, String string) {
            String string2 = "";
            if (ModuleStreamResolver.this.debug) {
                ModuleStreamResolver.this.logger.info(MODULE_NAME + ".resolveStreamAlias getting url for [" + iApplicationInstance.getContextStr() + "/" + string + "] urls: " + ModuleStreamResolver.this.urls.toString(), "application", "comment");
            }
            if (ModuleStreamResolver.this.isStreamUrl(string) || ModuleStreamResolver.this.isMediaList(string)) {
                return string;
            }
            Object object = ModuleStreamResolver.this.lock;
            synchronized (object) {
                string2 = (String)ModuleStreamResolver.this.urls.get(string);
                if (ModuleStreamResolver.this.debug) {
                    ModuleStreamResolver.this.logger.info(MODULE_NAME + ".resolveStreamAlias got url for [" + iApplicationInstance.getContextStr() + "/" + string + "]: url: " + string2 + ", urls: " + ModuleStreamResolver.this.urls.toString(), "application", "comment");
                }
            }
            return StringUtils.isEmpty((String)string2) ? "" : string2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String resolveStreamAlias(IApplicationInstance iApplicationInstance, String string, IMediaCaster iMediaCaster) {
            String string2 = "";
            if (ModuleStreamResolver.this.debug) {
                ModuleStreamResolver.this.logger.info(MODULE_NAME + ".resolveStreamAlias2 getting url for [" + iApplicationInstance.getContextStr() + "/" + string + "] urls: " + ModuleStreamResolver.this.urls.toString(), "application", "comment");
            }
            if (ModuleStreamResolver.this.isStreamUrl(string) || ModuleStreamResolver.this.isMediaList(string)) {
                return string;
            }
            Object object = ModuleStreamResolver.this.lock;
            synchronized (object) {
                string2 = (String)ModuleStreamResolver.this.urls.get(string);
                if (ModuleStreamResolver.this.debug) {
                    ModuleStreamResolver.this.logger.info(MODULE_NAME + ".resolveStreamAlias2 got url for [" + iApplicationInstance.getContextStr() + "/" + string + "]: url: " + string2 + ", urls: " + ModuleStreamResolver.this.urls.toString(), "application", "comment");
                }
            }
            return StringUtils.isEmpty((String)string2) ? "" : string2;
        }
    }
}

