/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.streamresolver;

import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.plugin.streamresolver.UDPServer;
import com.wowza.wms.server.IServer;
import com.wowza.wms.server.ServerNotifyBase;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public class ServerListenerLocateSourceStream
extends ServerNotifyBase {
    public static String MODULE_NAME = "ServerListenerLocateSourceStream";
    public static String MODULE_PROPERTY_PREFIX = "wowzaSourceStream";
    private static final int _UDP_PORT = 9777;
    private static final boolean _DEBUG = WMSLoggerFactory.getLogger(ServerListenerLocateSourceStream.class).isDebugEnabled();
    private static final WMSLogger logger = WMSLoggerFactory.getLogger(ServerListenerLocateSourceStream.class);
    private Thread udpListenerThread;

    public void onServerInit(IServer iServer) {
        try {
            logger.info(MODULE_NAME + ".onServerInit starting up server listener.. Build #49");
            final boolean bl = iServer.getProperties().getPropertyBoolean(MODULE_PROPERTY_PREFIX + "UDPListenerDebug", _DEBUG);
            final int n = iServer.getProperties().getPropertyInt(MODULE_PROPERTY_PREFIX + "UDPListenerPort", 9777);
            final String string = iServer.getProperties().getPropertyStr(MODULE_PROPERTY_PREFIX + "HostName", this.getInternalIPAddress());
            if (string != null) {
                this.udpListenerThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        new UDPServer(n, string, logger, bl);
                    }
                });
                this.udpListenerThread.start();
                logger.info(MODULE_NAME + ".onServerInit starting UDP Server..");
            } else {
                logger.info(MODULE_NAME + ".onServerInit[publicHostName] cannot resolve host name");
            }
        }
        catch (Exception exception) {
            logger.info(MODULE_NAME + ".onServerInit[Exception]", (Throwable)exception);
        }
    }

    public void onServerShutdownStart(IServer iServer) {
        try {
            if (this.udpListenerThread != null) {
                logger.info(MODULE_NAME + ".onServerShutdownStart shutting down..");
                this.udpListenerThread.interrupt();
            }
        }
        catch (Exception exception) {
            logger.info(MODULE_NAME + ".onServerShutdownStart[Exception]", (Throwable)exception);
        }
    }

    private String getInternalIPAddress() {
        String string = null;
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                if (!networkInterface.isUp() || networkInterface.isLoopback() || networkInterface.isVirtual()) continue;
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address) || string != null) continue;
                    string = inetAddress.getHostAddress();
                }
            }
        }
        catch (SocketException socketException) {
            logger.warn(MODULE_NAME + ".getInternalIpAddress Problem probing network interfaces", (Throwable)socketException);
        }
        if (string == null) {
            string = "127.0.0.1";
        }
        return string;
    }
}

