/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.streamresolver;

import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.plugin.streamresolver.Message;
import com.wowza.wms.plugin.streamresolver.ServerListenerLocateSourceStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;

public class UDPClient {
    private final String host;
    private final int port;
    private final WMSLogger logger;
    private final int timeout;
    private final boolean debug;

    public UDPClient(String string, int n, int n2, WMSLogger wMSLogger, boolean bl) {
        this.host = string;
        this.port = n;
        this.timeout = n2;
        this.logger = wMSLogger;
        this.debug = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String send(Message message) {
        try (DatagramSocket datagramSocket = new DatagramSocket();){
            datagramSocket.setSoTimeout(this.timeout);
            InetAddress inetAddress = InetAddress.getByName(this.host);
            byte[] byArray = new byte[1024];
            String string2 = message.toString();
            if (this.debug) {
                this.logger.info(ServerListenerLocateSourceStream.MODULE_NAME + "[UDPClient]Sending UDP Message :: " + string2 + " to server :: " + this.host + ":" + inetAddress);
            }
            byte[] byArray2 = string2.getBytes();
            DatagramPacket datagramPacket = new DatagramPacket(byArray2, byArray2.length, inetAddress, this.port);
            datagramSocket.send(datagramPacket);
            DatagramPacket datagramPacket2 = new DatagramPacket(byArray, byArray.length);
            datagramSocket.receive(datagramPacket2);
            String string3 = new String(datagramPacket2.getData(), datagramPacket2.getOffset(), datagramPacket2.getLength());
            if (this.debug) {
                this.logger.info(ServerListenerLocateSourceStream.MODULE_NAME + "[UDPClient] FROM SERVER:" + string3 + " from server::" + datagramPacket2.getSocketAddress());
            }
            String string = string3;
            return string;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            this.logger.warn(ServerListenerLocateSourceStream.MODULE_NAME + "[UDPClient] timeout connecting to server :" + this.host);
            return null;
        }
        catch (IOException iOException) {
            this.logger.warn(ServerListenerLocateSourceStream.MODULE_NAME + "[UDPClient] problem connecting to server :" + this.host + ": " + iOException.getMessage());
            return null;
        }
        catch (Exception exception) {
            this.logger.error(ServerListenerLocateSourceStream.MODULE_NAME + "[UDPClient]Exception :" + exception.getMessage(), (Throwable)exception);
        }
        return null;
    }
}

