/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.streamresolver;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.wowza.util.JSON;
import com.wowza.util.StringUtils;
import com.wowza.wms.application.ApplicationInstance;
import com.wowza.wms.application.IApplication;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.plugin.streamresolver.ServerListenerLocateSourceStream;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.MediaStreamMap;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.VHostSingleton;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class UDPServer {
    private final int port;
    private final WMSLogger logger;
    private final boolean debug;
    private final String publicHostName;

    public UDPServer(int n, String string, WMSLogger wMSLogger, boolean bl) {
        this.logger = wMSLogger;
        this.port = n;
        this.debug = bl;
        this.publicHostName = string;
        this.listenForRequests();
    }

    private String getStreamOrigin(String string, String string2, String string3) {
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            if (this.debug) {
                this.logger.info(ServerListenerLocateSourceStream.MODULE_NAME + "[UDPServer] getStreamOrigin::" + string);
            }
            List list = VHostSingleton.getVHostNames();
            for (String string4 : list) {
                Object object;
                IApplicationInstance iApplicationInstance;
                IApplication iApplication;
                IVHost iVHost = VHostSingleton.getInstance((String)string4);
                if (!iVHost.isApplicationLoaded(string2) || (iApplication = iVHost.getApplication(string2)) == null || (iApplicationInstance = iApplication.getAppInstance(string3)) == null) continue;
                if (iApplicationInstance.getClientCountTotal() <= 0) {
                    iApplicationInstance.incClientCountTotal();
                    ((ApplicationInstance)iApplicationInstance).setClientRemoveTime(System.currentTimeMillis());
                }
                MediaStreamMap mediaStreamMap = iApplicationInstance.getStreams();
                boolean bl = false;
                IMediaStream iMediaStream = mediaStreamMap.getStream(string);
                if (iMediaStream != null) {
                    bl = true;
                    object = this.publicHostName + "/" + string2 + "/" + string3 + "/" + string;
                    hashMap.put("server", object);
                    String string5 = iMediaStream.getLiveStreamPacketizerList();
                    if (!StringUtils.isEmpty((String)string5)) {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        for (String string6 : string5.split("[|,]")) {
                            if (mediaStreamMap.getLiveStreamPacketizer(string, string6 = string6.trim(), false) == null) continue;
                            arrayList.add(string6);
                        }
                        if (!arrayList.isEmpty()) {
                            hashMap.put("packetizers", arrayList);
                        }
                    }
                }
                if (!bl) continue;
                object = new ObjectMapper().writeValueAsString(hashMap);
                if (this.debug) {
                    this.logger.info(ServerListenerLocateSourceStream.MODULE_NAME + "[UDPServer] getStreamOrigin::" + (String)object);
                }
                return object;
            }
        }
        catch (Exception exception) {
            this.logger.error(ServerListenerLocateSourceStream.MODULE_NAME + "[UDPServer] getStreamOrigin:: Exception Thrown", (Throwable)exception);
        }
        return "{error: \"Unable to locate Stream\"}";
    }

    private void listenForRequests() {
        try {
            if (this.debug) {
                this.logger.info(ServerListenerLocateSourceStream.MODULE_NAME + "[UDPServer] listenForRequests on port " + this.port);
            }
            DatagramSocket datagramSocket = new DatagramSocket(this.port);
            while (true) {
                Object object;
                Object object2;
                byte[] byArray = new byte[1024];
                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                datagramSocket.receive(datagramPacket);
                String string = new String(datagramPacket.getData(), datagramPacket.getOffset(), datagramPacket.getLength());
                if (this.debug) {
                    this.logger.info(ServerListenerLocateSourceStream.MODULE_NAME + "[UDPServer] listenForRequests::received message::" + string + " from server::" + datagramPacket.getSocketAddress());
                }
                String string2 = "";
                try {
                    object2 = new JSON(string);
                    String string3 = object2.getString("streamName");
                    object = object2.getString("appName");
                    String string4 = object2.getString("appInstanceName");
                    string2 = this.getStreamOrigin(string3, (String)object, string4);
                }
                catch (Exception exception) {
                    this.logger.error(ServerListenerLocateSourceStream.MODULE_NAME + "[UDPServer] listenForRequests::JSON-Exception::" + exception.getMessage(), (Throwable)exception);
                }
                try {
                    object2 = datagramPacket.getAddress();
                    int n = datagramPacket.getPort();
                    byte[] byArray2 = string2.getBytes();
                    object = new DatagramPacket(byArray2, byArray2.length, (InetAddress)object2, n);
                    datagramSocket.send((DatagramPacket)object);
                    if (!this.debug) continue;
                    this.logger.info(ServerListenerLocateSourceStream.MODULE_NAME + "[UDPServer] listenForRequests::responseString::" + string2 + " to server::" + datagramPacket.getSocketAddress());
                }
                catch (Exception exception) {
                    this.logger.error(ServerListenerLocateSourceStream.MODULE_NAME + "[UDPServer] listenForRequests::IP-Exception::" + exception.getMessage(), (Throwable)exception);
                }
            }
        }
        catch (Exception exception) {
            this.logger.error(ServerListenerLocateSourceStream.MODULE_NAME + "[UDPServer] Exception::" + exception.getMessage(), (Throwable)exception);
            return;
        }
    }
}

