/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin;

import com.wowza.util.StringUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleBase;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;

public class ModuleTimedDisconnect
extends ModuleBase {
    public static final String MODULE_NAME = "ModuleTimedDisconnect";
    public static final String PROP_NAME_PREFIX = "timedDisconnect";
    private IApplicationInstance appInstance = null;
    private Timer timer = null;
    private int disconnectTime = 60;
    private String allowedIps = "";
    private String allowedAgents = "";
    private boolean debugLog = false;
    private WMSLogger logger = null;
    private TreeMap<Long, String> sessionCache = new TreeMap();
    private long sessionCacheDuration = 600000L;

    public void onAppStart(IApplicationInstance iApplicationInstance) {
        this.appInstance = iApplicationInstance;
        this.logger = WMSLoggerFactory.getLoggerObj((IApplicationInstance)iApplicationInstance);
        this.disconnectTime = iApplicationInstance.getProperties().getPropertyInt("timedDisconnectTime", this.disconnectTime);
        this.allowedIps = iApplicationInstance.getProperties().getPropertyStr("timedDisconnectAllowedIPs", this.allowedIps);
        this.allowedAgents = iApplicationInstance.getProperties().getPropertyStr("timedDisconnectAllowedAgents", this.allowedAgents);
        this.sessionCacheDuration = iApplicationInstance.getProperties().getPropertyLong("timedDisconnectSessionCacheDuration", this.sessionCacheDuration);
        this.debugLog = iApplicationInstance.getProperties().getPropertyBoolean("timedDisconnectDebugLog", this.debugLog);
        if (this.logger.isDebugEnabled()) {
            this.debugLog = true;
        }
        this.logger.info("ModuleTimedDisconnect Started [" + iApplicationInstance.getContextStr() + " build #2, disconnectTime: " + this.disconnectTime + ", ignoredAgents: " + this.allowedAgents + ", sessionCacheDuration: " + this.sessionCacheDuration + ", debugLog: " + this.debugLog + "]", "application", "comment");
        this.timer = new Timer("ModuleTimedDisconnect [" + iApplicationInstance.getContextStr() + "]");
        this.timer.schedule((TimerTask)new Disconnecter(), 0L, 1000L);
    }

    public void onAppStop(IApplicationInstance iApplicationInstance) {
        this.logger.info("ModuleTimedDisconnect: Stopped [" + iApplicationInstance.getContextStr() + "]", "application", "comment");
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onHTTPSessionCreate(IHTTPStreamerSession iHTTPStreamerSession) {
        TreeMap<Long, String> treeMap = this.sessionCache;
        synchronized (treeMap) {
            if (this.sessionCache.values().contains(iHTTPStreamerSession.getSessionId())) {
                iHTTPStreamerSession.rejectSession();
                iHTTPStreamerSession.setDeleteSession();
            }
        }
    }

    private boolean checkAllowedIPAddress(String string) {
        if (string.equalsIgnoreCase("127.0.0.1")) {
            if (this.debugLog) {
                ModuleTimedDisconnect.getLogger().info("ModuleTimedDisconnect: IP will be ignored [" + string + "]", "application", "comment");
            }
            return false;
        }
        String[] stringArray = this.allowedIps.toLowerCase().split(",");
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i].trim();
                if (StringUtils.isEmpty((String)string2) || !string.toLowerCase().startsWith(string2)) continue;
                if (this.debugLog) {
                    ModuleTimedDisconnect.getLogger().info("ModuleTimedDisconnect: IP will be ignored [" + string + "]", "application", "comment");
                }
                return false;
            }
        }
        if (this.debugLog) {
            ModuleTimedDisconnect.getLogger().info("ModuleTimedDisconnect: IP will be checked [" + string + "]", "application", "comment");
        }
        return true;
    }

    private boolean checkAllowedUserAgent(String string) {
        String[] stringArray = this.allowedAgents.toLowerCase().split(",");
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i].trim();
                if (StringUtils.isEmpty((String)string2) || !string.toLowerCase().startsWith(string2)) continue;
                if (this.debugLog) {
                    ModuleTimedDisconnect.getLogger().info("ModuleTimedDisconnect: UA will be ignored [" + string + "]", "application", "comment");
                }
                return false;
            }
        }
        if (this.debugLog) {
            ModuleTimedDisconnect.getLogger().info("ModuleTimedDisconnect: UA will be checked [" + string + "]", "application", "comment");
        }
        return true;
    }

    private class Disconnecter
    extends TimerTask {
        private Disconnecter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void run() {
            for (Object object : ModuleTimedDisconnect.this.appInstance.getClients()) {
                if (!(object.getTimeRunningSeconds() > (double)ModuleTimedDisconnect.this.disconnectTime) || !ModuleTimedDisconnect.this.checkAllowedIPAddress(object.getIp()) || !ModuleTimedDisconnect.this.checkAllowedUserAgent(object.getFlashVer())) continue;
                if (ModuleTimedDisconnect.this.debugLog) {
                    ModuleTimedDisconnect.this.logger.info("ModuleTimedDisconnect: RTMP disconnecting client " + object.getClientId() + " FlashVer is " + object.getFlashVer(), "application", "comment");
                }
                object.setShutdownClient(true);
            }
            for (Object object : ModuleTimedDisconnect.this.appInstance.getHTTPStreamerSessions()) {
                if (!(object.getTimeRunningSeconds() > (double)ModuleTimedDisconnect.this.disconnectTime) || !ModuleTimedDisconnect.this.checkAllowedIPAddress(object.getIpAddress()) || !ModuleTimedDisconnect.this.checkAllowedUserAgent(object.getUserAgent())) continue;
                if (ModuleTimedDisconnect.this.debugLog) {
                    ModuleTimedDisconnect.this.logger.info("ModuleTimedDisconnect: HTTP disconnecting session " + object.getSessionId(), "application", "comment");
                }
                object.rejectSession();
                Object object2 = ModuleTimedDisconnect.this.sessionCache;
                synchronized (object2) {
                    ModuleTimedDisconnect.this.sessionCache.put(System.currentTimeMillis(), object.getSessionId());
                }
            }
            for (Object object2 : ModuleTimedDisconnect.this.appInstance.getRTPSessions()) {
                if (!(object2.getTimeRunningSeconds() > (double)ModuleTimedDisconnect.this.disconnectTime) || !ModuleTimedDisconnect.this.checkAllowedIPAddress(object2.getIp()) || !ModuleTimedDisconnect.this.checkAllowedUserAgent(object2.getUserAgent())) continue;
                if (ModuleTimedDisconnect.this.debugLog) {
                    ModuleTimedDisconnect.this.logger.info("ModuleTimedDisconnect: RTSP disconnecting client " + object2.getSessionId(), "application", "comment");
                }
                ModuleTimedDisconnect.this.appInstance.getVHost().getRTPContext().shutdownRTPSession(object2);
            }
            long l = System.currentTimeMillis() - ModuleTimedDisconnect.this.sessionCacheDuration;
            TreeMap treeMap = ModuleTimedDisconnect.this.sessionCache;
            synchronized (treeMap) {
                Iterator iterator = ModuleTimedDisconnect.this.sessionCache.keySet().iterator();
                while (iterator.hasNext() && (Long)iterator.next() <= l) {
                    iterator.remove();
                }
            }
        }
    }
}

