/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin;

import com.wowza.util.StringUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.livetranscoder.ILiveStreamTranscoderControl;

public class TranscoderControl
extends ModuleBase {
    public static final String MODULE_NAME = "TranscoderControl";
    public static final String PROP_NAME_PREFIX = "transcoderControl";
    private WMSLogger logger;
    private String names = "*";
    private boolean matchAllow = true;
    private boolean noMatchAllow = false;

    public void onAppStart(IApplicationInstance iApplicationInstance) {
        this.logger = WMSLoggerFactory.getLoggerObj((IApplicationInstance)iApplicationInstance);
        this.names = iApplicationInstance.getProperties().getPropertyStr("transcoderControlNames", this.names);
        this.matchAllow = iApplicationInstance.getProperties().getPropertyBoolean("transcoderControlMatchAllow", this.matchAllow);
        this.noMatchAllow = iApplicationInstance.getProperties().getPropertyBoolean("transcoderControlNoMatchAllow", this.noMatchAllow);
        iApplicationInstance.setLiveStreamTranscoderControl((ILiveStreamTranscoderControl)new Controller());
    }

    private class Controller
    implements ILiveStreamTranscoderControl {
        private Controller() {
        }

        public boolean isLiveStreamTranscode(String string, IMediaStream iMediaStream) {
            String[] stringArray;
            if (iMediaStream.isTranscodeResult()) {
                return false;
            }
            TranscoderControl.this.logger.info("TranscoderControl.isLiveStreamTranscode [" + string + " : " + iMediaStream.getName() + " : " + TranscoderControl.this.names + "]", iMediaStream);
            if (TranscoderControl.this.names.equals("*")) {
                TranscoderControl.this.logger.info("TranscoderControl.isLiveStreamTranscode [" + string + " : " + iMediaStream.getName() + " :  names is wildcard. returning " + TranscoderControl.this.matchAllow + "]", iMediaStream);
                return TranscoderControl.this.matchAllow;
            }
            if (StringUtils.isEmpty((String)TranscoderControl.this.names)) {
                TranscoderControl.this.logger.info("TranscoderControl.isLiveStreamTranscode [" + string + " : " + iMediaStream.getName() + " : names is empty. returning " + TranscoderControl.this.noMatchAllow + "]", iMediaStream);
                return TranscoderControl.this.noMatchAllow;
            }
            for (String string2 : stringArray = TranscoderControl.this.names.split(",")) {
                if (!iMediaStream.getName().matches(string2.trim())) continue;
                TranscoderControl.this.logger.info("TranscoderControl.isLiveStreamTranscode [" + string + " : " + iMediaStream.getName() + " : match found : " + string2.trim() + " : returning " + TranscoderControl.this.matchAllow + "]", iMediaStream);
                return TranscoderControl.this.matchAllow;
            }
            TranscoderControl.this.logger.info("TranscoderControl.isLiveStreamTranscode [" + string + " : " + iMediaStream.getName() + " : No match found : returning " + TranscoderControl.this.noMatchAllow + "]", iMediaStream);
            return TranscoderControl.this.noMatchAllow;
        }
    }
}

