/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin;

import com.wowza.util.StringUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.logging.WMSLogger;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.transcoder.model.ITranscoderFrameGrabResult;
import com.wowza.wms.transcoder.model.LiveStreamTranscoder;
import com.wowza.wms.transcoder.model.TranscoderNativeVideoFrame;
import com.wowza.wms.transcoder.model.TranscoderStream;
import com.wowza.wms.transcoder.model.TranscoderStreamSourceVideo;
import com.wowza.wms.transcoder.util.TranscoderStreamUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;

public class TranscoderTimedSnapshot
extends ModuleBase {
    public static final String MODULE_NAME = "ModuleTranscoderTimedSnapshot";
    public static final String PROP_NAME_PREFIX = "transcoderTimedSnapshot";
    private List<SnapshotWorker> workers = new ArrayList<SnapshotWorker>();
    private String streamNames = "myStream";
    private int height = 0;
    private int width = 0;
    private int sleepTime = 1000;
    private String imagePrefix = "thumbnail_";
    private String format = "png";
    private boolean timestampImages = true;
    private WMSLogger logger = null;
    private IApplicationInstance appInstance = null;

    public void onAppStart(IApplicationInstance iApplicationInstance) {
        this.appInstance = iApplicationInstance;
        this.logger = WMSLoggerFactory.getLoggerObj((IApplicationInstance)iApplicationInstance);
        WMSProperties wMSProperties = iApplicationInstance.getProperties();
        this.streamNames = wMSProperties.getPropertyStr("transcoderTimedSnapshotStreamNames", this.streamNames);
        this.height = wMSProperties.getPropertyInt("transcoderTimedSnapshotHeight", this.height);
        this.width = wMSProperties.getPropertyInt("transcoderTimedSnapshotWidth", this.width);
        this.sleepTime = wMSProperties.getPropertyInt("transcoderTimedSnapshotInterval", this.sleepTime);
        this.imagePrefix = wMSProperties.getPropertyStr("transcoderTimedSnapshotImagePrefix", this.imagePrefix);
        this.format = wMSProperties.getPropertyStr("transcoderTimedSnapshotFormat", this.format).toLowerCase();
        this.timestampImages = wMSProperties.getPropertyBoolean("transcoderTimedSnapshotTimestampImages", this.timestampImages);
        if (this.sleepTime < 1000) {
            this.logger.info("ModuleTranscoderTimedSnapshot timer reset, less than 1000 , reset to 1000, remember it is in milliseconds", "application", "comment");
            this.sleepTime = 1000;
        }
        if (!(this.format.equals("jpg") || this.format.equals("png") || this.format.equals("bmp"))) {
            this.logger.info("ModuleTranscoderTimedSnapshot format must be jpg, png or bmp , reset to png", "application", "comment");
            this.format = "png";
        }
        if (StringUtils.isEmpty((String)this.streamNames)) {
            this.logger.info("ModuleTranscoderTimedSnapshot Stream Names is empty, not doing anything.", "application", "comment");
        } else {
            String[] stringArray;
            for (String string : stringArray = this.streamNames.replaceAll("(\\|)", ",").split(",")) {
                if (StringUtils.isEmpty((String)string)) continue;
                SnapshotWorker snapshotWorker = new SnapshotWorker(string.trim());
                snapshotWorker.setDaemon(true);
                snapshotWorker.start();
                this.workers.add(snapshotWorker);
            }
        }
    }

    public void onAppStop(IApplicationInstance iApplicationInstance) {
        for (SnapshotWorker snapshotWorker : this.workers) {
            if (snapshotWorker == null) continue;
            snapshotWorker.quit();
        }
        this.workers.clear();
    }

    public void takeSnapshot(String string) {
        try {
            TranscoderStreamSourceVideo transcoderStreamSourceVideo;
            TranscoderStream transcoderStream;
            LiveStreamTranscoder liveStreamTranscoder;
            IMediaStream iMediaStream = this.appInstance.getStreams().getStream(string);
            if (iMediaStream != null && (liveStreamTranscoder = (LiveStreamTranscoder)iMediaStream.getLiveStreamTranscoder("transcoder")) != null && (transcoderStream = liveStreamTranscoder.getTranscodingStream()) != null && (transcoderStreamSourceVideo = transcoderStream.getSource().getVideo()) != null) {
                if (this.width > 0 && this.height > 0) {
                    transcoderStreamSourceVideo.grabFrame((ITranscoderFrameGrabResult)new FrameGrabResult(string), this.width, this.height);
                } else {
                    transcoderStreamSourceVideo.grabFrame((ITranscoderFrameGrabResult)new FrameGrabResult(string));
                }
            }
        }
        catch (Exception exception) {
            this.logger.error("ModuleTranscoderTimedSnapshot Exception: [" + this.appInstance.getContextStr() + "/" + string + "] " + exception.toString(), (Throwable)exception);
        }
    }

    class SnapshotWorker
    extends Thread {
        private boolean running;
        private boolean quit;
        private final String streamName;

        SnapshotWorker(String string) {
            super("Transcoder Snapshot Worker [" + TranscoderTimedSnapshot.this.appInstance.getContextStr() + "/" + string + "]");
            this.running = true;
            this.quit = false;
            this.streamName = string;
        }

        synchronized boolean running() {
            return this.running;
        }

        synchronized void quit() {
            this.quit = true;
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TranscoderTimedSnapshot.this.logger.info(this.getName() + " started.");
            while (true) {
                SnapshotWorker snapshotWorker = this;
                synchronized (snapshotWorker) {
                    if (this.quit) {
                        this.running = false;
                        break;
                    }
                }
                TranscoderTimedSnapshot.this.takeSnapshot(this.streamName);
                try {
                    Thread.sleep(TranscoderTimedSnapshot.this.sleepTime);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    class FrameGrabResult
    implements ITranscoderFrameGrabResult {
        private final String streamName;

        FrameGrabResult(String string) {
            this.streamName = string;
        }

        public void onGrabFrame(TranscoderNativeVideoFrame transcoderNativeVideoFrame) {
            BufferedImage bufferedImage = TranscoderStreamUtils.nativeImageToBufferedImage((TranscoderNativeVideoFrame)transcoderNativeVideoFrame);
            if (bufferedImage != null) {
                long l = System.currentTimeMillis() / 1000L;
                String string = TranscoderTimedSnapshot.this.appInstance.getStreamStoragePath();
                File file = new File(string, TranscoderTimedSnapshot.this.imagePrefix + this.streamName + (String)(TranscoderTimedSnapshot.this.timestampImages ? "_" + l : "") + "." + TranscoderTimedSnapshot.this.format);
                try {
                    if (file.exists()) {
                        file.delete();
                    }
                    ImageIO.write((RenderedImage)bufferedImage, TranscoderTimedSnapshot.this.format, file);
                }
                catch (Exception exception) {
                    TranscoderTimedSnapshot.this.logger.error("ModuleTestTranscoderFrameGrab.grabFrame: File write error: " + file);
                }
            }
        }
    }
}

