package com.wowza.wms.plugin.fixstreampath;

import com.wowza.wms.module.*;
import com.wowza.wms.request.*;
import com.wowza.wms.amf.*;
import com.wowza.wms.client.*;

public class ModuleFixDefInst extends ModuleBase
{
	private void fixStreamPath(IClient client, AMFDataList params, int paramIndex)
	{
		while (true)
		{
			String streamPrefix = client.getProperties().getPropertyStr(VHostListenerFixDefInst.PROPERTIES_STREAMPREFIX);
			if (streamPrefix == null)
				break;

			if (params.get(paramIndex).getType() != AMFData.DATA_TYPE_STRING)
				break;
    		
			String streamName = params.getString(paramIndex);
			
			String newName = streamPrefix+"/"+streamName;
   		
    		params.set(paramIndex, newName);
    		
    		getLogger().info("ModuleFixDefInst: from:"+streamName+" to:"+newName);
    		break;
    	}
	}
	
    public void getStreamLength(IClient client, RequestFunction function, AMFDataList params)
    {
    	fixStreamPath(client, params, PARAM1);
    	invokePrevious(client, function, params);
    }
    
    public void play(IClient client, RequestFunction function, AMFDataList params)
    {
    	fixStreamPath(client, params, PARAM1);
    	invokePrevious(client, function, params);
    }
    
    public void publish(IClient client, RequestFunction function, AMFDataList params)
    {
    	fixStreamPath(client, params, PARAM1);
    	invokePrevious(client, function, params);
    }
    
    public void releaseStream(IClient client, RequestFunction function, AMFDataList params)
    {
    	fixStreamPath(client, params, PARAM1);
    	invokePrevious(client, function, params);
    }

}
