package com.wowza.wms.plugin.fixstreampath;

import com.wowza.wms.module.*;
import com.wowza.wms.request.*;
import com.wowza.wms.amf.*;
import com.wowza.wms.client.*;

public class ModuleFixStreamPath extends ModuleBase
{
	private void fixStreamPath(IClient client, AMFDataList params, int paramIndex)
	{
		while (true)
		{
			if (params.get(paramIndex).getType() != AMFData.DATA_TYPE_STRING)
				break;

			String connectApp = client.getProperties().getPropertyStr("connectapp");
    		if (connectApp == null)
    			break;
    		
    		String[] parts = connectApp.split("[/]");
    		if (parts == null)
    			break;
    		
    		if (parts.length <= 2)
    			break;
    		
			String streamName = params.getString(paramIndex);
			
			String newName = streamName;
    		for(int i=(parts.length-1);i>=2;i--)
    			newName = parts[i] + "/" + newName;
    		
    		params.set(paramIndex, newName);
    		
    		getLogger().info("ModuleFixStreamPath: from:"+streamName+" to:"+newName);
    		break;
    	}
	}
	
    public void getStreamLength(IClient client, RequestFunction function, AMFDataList params)
    {
    	fixStreamPath(client, params, PARAM1);
    	invokePrevious(client, function, params);
    }
    
    public void play(IClient client, RequestFunction function, AMFDataList params)
    {
    	fixStreamPath(client, params, PARAM1);
    	invokePrevious(client, function, params);
    }
    
    public void publish(IClient client, RequestFunction function, AMFDataList params)
    {
    	fixStreamPath(client, params, PARAM1);
    	invokePrevious(client, function, params);
    }
    
    public void releaseStream(IClient client, RequestFunction function, AMFDataList params)
    {
    	fixStreamPath(client, params, PARAM1);
    	invokePrevious(client, function, params);
    }
}
