package com.wowza.wms.plugin.fixstreampath;

import java.util.*;

import com.wowza.wms.amf.*;
import com.wowza.wms.application.*;
import com.wowza.wms.client.*;
import com.wowza.wms.request.*;
import com.wowza.wms.vhost.*;
import com.wowza.wms.logging.*;

public class VHostListenerFixDefInst implements IVHostNotify
{
	public static final String PROPERTIES_CONNECTURL = "tcUrl";
	public static final String PROPERTIES_APPLICATION = "app";
	public static final String PROPERTIES_STREAMPREFIX = "vHostListenerFixDefInstStreamPrefix";

	public void onVHostCreate(IVHost vhost)
	{
		WMSLoggerFactory.getLogger(null).info("VHostListenerFixDefInst.onVHostCreate["+vhost.getName()+"]");
	}

	public void onVHostInit(IVHost vhost)
	{
	}

	public void onVHostShutdownStart(IVHost vhost)
	{
	}

	public void onVHostShutdownComplete(IVHost vhost)
	{
	}

	public void onVHostClientConnect(IVHost vhost, IClient inClient, RequestFunction function, AMFDataList params)
	{
		try
		{
			while(true)
			{
				if (params.size() <= 2)
					break;
				
	    		AMFDataObj connectObj = (AMFDataObj)params.get(2);
	    		if (connectObj.getType() != AMFData.DATA_TYPE_OBJECT)
	    			break;
	    					
	    		if (!connectObj.containsKey(PROPERTIES_CONNECTURL) || !connectObj.containsKey(PROPERTIES_APPLICATION))
	    			break;
	    		
	    		String connectUrl = connectObj.getString(PROPERTIES_CONNECTURL);
	    		String appStr = connectObj.getString(PROPERTIES_APPLICATION);
	    		String streamPrefix = null;
	    		
				//app: live/test
				//flashVer: WIN 11,3,300,257
				//swfUrl: undefined
				//tcUrl: rtmp://localhost/live/test
				//fpad: false
				//capabilities: 239.0
				//audioCodecs: 3575.0
				//videoCodecs: 252.0
				//videoFunction: 1.0
				//pageUrl: undefined
				//objectEncoding: 3.0
	    		
	    		List<String> keys = connectObj.getKeys();
	    		Iterator<String> kiter = keys.iterator();
	    		while(kiter.hasNext())
	    		{
	    			String key = kiter.next();
		    		//System.out.println(key+": "+connectObj.getString(key));
	    		}
	    			    		
	    		int eloc = connectUrl.indexOf("://");
	    		if (eloc >= 0)
	    		{
	    			String protocolStr = connectUrl.substring(0, eloc+3);
	    			String pathStr = connectUrl.substring(eloc+3);
	    			
	    			String[] pathParts = pathStr.split("/");
	    			if (pathParts.length >= 3)
	    			{
	    				streamPrefix = "";
	    				for(int i=2;i<pathParts.length;i++)
	    				{
	    					if (streamPrefix.length() > 0)
	    						streamPrefix += "/";
	    					streamPrefix += pathParts[i];
	    				}
	    				
	    				String newConnectUrl = protocolStr+"/"+pathParts[0]+"/"+pathParts[1]+"/"+IApplicationInstance.DEFAULT_APPINSTANCE_NAME;
	    				String newAppStr = pathParts[1]+"/"+IApplicationInstance.DEFAULT_APPINSTANCE_NAME;
	    				
	    				WMSLoggerFactory.getLogger(null).info("VHostListenerFixDefInst.onVHostClientConnect["+vhost.getName()+"] tcUrl:"+newConnectUrl+" app:"+newAppStr+" streamPrefix:"+streamPrefix);
	    	    		
	    				connectObj.put(PROPERTIES_CONNECTURL, newConnectUrl);
	    				connectObj.put(PROPERTIES_APPLICATION, newAppStr);
	    				inClient.getProperties().setProperty(PROPERTIES_STREAMPREFIX, streamPrefix);
	    			}
	    		}
	    		
				//connectUrl: rtmp://localhost/live
				//appStr: live	    		
				break;
			}
		}
		catch(Exception e)
		{
		}
	}

}
