/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.geoip;

import com.maxmind.geoip.LookupService;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.client.IClient;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.plugin.geoip.ServerListenerGeographicSelector;
import com.wowza.wms.request.RequestFunction;
import com.wowza.wms.rtp.model.RTPSession;

public class ModuleGeographicSelection
extends ModuleBase {
    private LookupService maxMindObject = null;
    private boolean geographicReady = false;
    private boolean geoGraphicInclude = true;
    private boolean debug = false;
    private boolean blockByDefault = true;
    private String[] allowedEncoder = new String[0];
    private String[] allowedIP = new String[0];
    private String appContext = "";
    private String countries = "";

    public void onAppStart(IApplicationInstance iApplicationInstance) {
        this.appContext = iApplicationInstance.getApplication().getName() + "/" + iApplicationInstance.getName();
        ModuleGeographicSelection.getLogger().info("ModuleGeographicSelection.onAppStart[" + this.appContext + "]");
        this.maxMindObject = ServerListenerGeographicSelector.getGeographicObject();
        this.geographicReady = ServerListenerGeographicSelector.getGeographicReady();
        this.allowedEncoder = iApplicationInstance.getProperties().getPropertyStr("geoipAllowEncoder", "").toLowerCase().split(",");
        this.allowedIP = iApplicationInstance.getProperties().getPropertyStr("geoipAllowIP", "").toLowerCase().split(",");
        this.debug = iApplicationInstance.getProperties().getPropertyBoolean("geoipDebug", this.debug);
        this.geoGraphicInclude = iApplicationInstance.getProperties().getPropertyBoolean("geoipCountriesInclude", this.geoGraphicInclude);
        this.countries = iApplicationInstance.getProperties().getPropertyStr("geoipCountries", this.countries);
        this.blockByDefault = iApplicationInstance.getProperties().getPropertyBoolean("geoipBlockByDefault", this.blockByDefault);
    }

    public void onConnect(IClient iClient, RequestFunction requestFunction, AMFDataList aMFDataList) {
        block17: {
            ModuleGeographicSelection.getLogger().info("ModuleGeographicSelection.onConnect[" + this.appContext + "]: clientID:" + iClient.getClientId());
            String string = iClient.getFlashVer().toLowerCase();
            if (this.debug) {
                ModuleGeographicSelection.getLogger().info("ModuleGeographicSelection.onConnect[" + this.appContext + "]: flashver: " + string);
            }
            try {
                if (this.allowedEncoder != null) {
                    for (int i = 0; i < this.allowedEncoder.length; ++i) {
                        if (!string.startsWith(this.allowedEncoder[i].trim()) || this.allowedEncoder[i].length() <= 0) continue;
                        if (this.debug) {
                            ModuleGeographicSelection.getLogger().info("ModuleGeographicSelection.onConnect[" + this.appContext + "]: GeoIP Encoder Allowed: " + string + " matches " + this.allowedEncoder[i]);
                        }
                        return;
                    }
                }
                if (this.checkAllowedIP(this.allowedIP, iClient.getIp())) {
                    if (this.debug) {
                        ModuleGeographicSelection.getLogger().info("ModuleGeographicSelection.onConnect[" + this.appContext + "]: AllowedIP Passed check: " + this.allowedIP + " client ip " + iClient.getIp());
                    }
                    return;
                }
                if (this.debug) {
                    ModuleGeographicSelection.getLogger().info("ModuleGeographicSelection.onConnect[" + this.appContext + "]: Geographic client id " + iClient.getClientId() + " failed AllowedIP check");
                }
                if (this.geographicReady) {
                    if (this.debug) {
                        ModuleGeographicSelection.getLogger().info("ModuleGeographicSelection.onConnect[" + this.appContext + "]: Geographic client id " + iClient.getClientId() + " code is " + this.maxMindObject.getCountry(iClient.getIp()).getCode() + " list is " + this.countries);
                    }
                    if (this.countries.contains(this.maxMindObject.getCountry(iClient.getIp()).getCode()) == this.geoGraphicInclude) {
                        if (this.debug) {
                            ModuleGeographicSelection.getLogger().info("ModuleGeographicSelection.onConnect[" + this.appContext + "]: Geographic client id " + iClient.getClientId() + " connection accepted");
                        }
                        iClient.acceptConnection();
                        return;
                    }
                    if (this.debug) {
                        ModuleGeographicSelection.getLogger().info("ModuleGeographicSelection.onConnect[" + this.appContext + "]: Geographic client id " + iClient.getClientId() + " connection rejected");
                    }
                    iClient.rejectConnection();
                    break block17;
                }
                if (this.blockByDefault) {
                    if (this.debug) {
                        ModuleGeographicSelection.getLogger().info("ModuleGeographicSelection.onConnect[" + this.appContext + "]: Geographic client id " + iClient.getClientId() + " connction blocked");
                    }
                    iClient.rejectConnection("Geographic blocking not available, blocking client id " + iClient.getClientId() + " connection");
                    break block17;
                }
                ModuleGeographicSelection.getLogger().info("ModuleGeographicSelection.onConnect[" + this.appContext + "]: Geographic client id " + iClient.getClientId() + " Accept by default");
                iClient.acceptConnection();
                return;
            }
            catch (Exception exception) {
                ModuleGeographicSelection.getLogger().warn("ModuleGeographicSelection.onConnect[" + this.appContext + "]: Exception: " + exception.getMessage());
            }
        }
        if (this.debug) {
            ModuleGeographicSelection.getLogger().info("ModuleGeographicSelection.onConnect[" + this.appContext + "]: Geographic client id " + iClient.getClientId() + " decision at end, blocked by default");
        }
        iClient.rejectConnection();
        iClient.shutdownClient();
    }

    public void onHTTPSessionCreate(IHTTPStreamerSession iHTTPStreamerSession) {
        block13: {
            ModuleGeographicSelection.getLogger().info("ModuleGeographicSelection.onHTTPSessionCreate[" + this.appContext + "]: sessionID:" + iHTTPStreamerSession.getSessionId());
            try {
                if (this.checkAllowedIP(this.allowedIP, iHTTPStreamerSession.getIpAddress())) {
                    if (this.debug) {
                        ModuleGeographicSelection.getLogger().info("ModuleGeographicSelection.onConnect[" + this.appContext + "]: AllowedIP Passed check: " + this.allowedIP + " client id " + iHTTPStreamerSession.getSessionId() + " ip " + iHTTPStreamerSession.getIpAddress());
                    }
                    return;
                }
                if (this.debug) {
                    ModuleGeographicSelection.getLogger().info("ModuleGeographicSelection.onConnect[" + this.appContext + "]: client id " + iHTTPStreamerSession.getSessionId() + " failed AllowedIP check");
                }
                if (this.geographicReady) {
                    if (this.debug) {
                        ModuleGeographicSelection.getLogger().info("ModuleGeographicSelection.onConnect[" + this.appContext + "]: Geographic client id '" + iHTTPStreamerSession.getSessionId() + " code is " + this.maxMindObject.getCountry(iHTTPStreamerSession.getIpAddress()).getCode() + " list is " + this.countries);
                    }
                    if (this.countries.contains(this.maxMindObject.getCountry(iHTTPStreamerSession.getIpAddress()).getCode()) == this.geoGraphicInclude) {
                        if (this.debug) {
                            ModuleGeographicSelection.getLogger().info("ModuleGeographicSelection.onConnect[" + this.appContext + "]: Geographic client id '" + iHTTPStreamerSession.getSessionId() + " connection accepted");
                        }
                        return;
                    }
                    if (this.debug) {
                        ModuleGeographicSelection.getLogger().info("ModuleGeographicSelection.onConnect[" + this.appContext + "]: Geographic client id '" + iHTTPStreamerSession.getSessionId() + " connection rejected");
                    }
                    iHTTPStreamerSession.rejectSession();
                    iHTTPStreamerSession.shutdown();
                    break block13;
                }
                if (this.blockByDefault) {
                    if (this.debug) {
                        ModuleGeographicSelection.getLogger().info("ModuleGeographicSelection.onConnect[" + this.appContext + "]: Geographic client id '" + iHTTPStreamerSession.getSessionId() + " connction blocked");
                    }
                    iHTTPStreamerSession.rejectSession();
                    iHTTPStreamerSession.shutdown();
                    break block13;
                }
                ModuleGeographicSelection.getLogger().info("ModuleGeographicSelection.onConnect[" + this.appContext + "]: Geographic client id '" + iHTTPStreamerSession.getSessionId() + " Accept by default");
                return;
            }
            catch (Exception exception) {
                ModuleGeographicSelection.getLogger().warn("ModuleGeographicSelection.onHTTPSessionCreate[" + this.appContext + "]: Exception: " + exception.getMessage());
            }
        }
        if (this.debug) {
            ModuleGeographicSelection.getLogger().info("ModuleGeographicSelection.onConnect[" + this.appContext + "]: Geographic client id '" + iHTTPStreamerSession.getSessionId() + " decision at end, blocked by default");
        }
        iHTTPStreamerSession.rejectSession();
        iHTTPStreamerSession.shutdown();
    }

    public void onRTPSessionCreate(RTPSession rTPSession) {
        block12: {
            ModuleGeographicSelection.getLogger().info("ModuleGeographicSelection.onRTPSessionCreate[" + this.appContext + "]: sessionID:" + rTPSession.getSessionId());
            try {
                if (this.checkAllowedIP(this.allowedIP, rTPSession.getIp())) {
                    if (this.debug) {
                        ModuleGeographicSelection.getLogger().info("ModuleGeographicSelection.onConnect[" + this.appContext + "]: AllowedIP Passed check: " + this.allowedIP + " client ip " + rTPSession.getSessionId());
                    }
                    return;
                }
                if (this.geographicReady) {
                    if (this.debug) {
                        ModuleGeographicSelection.getLogger().info("ModuleGeographicSelection.onConnect[" + this.appContext + "]: Geographic client id '" + rTPSession.getSessionId() + " code is " + this.maxMindObject.getCountry(rTPSession.getIp()).getCode() + " list is " + this.countries);
                    }
                    if (this.countries.contains(this.maxMindObject.getCountry(rTPSession.getIp()).getCode()) == this.geoGraphicInclude) {
                        if (this.debug) {
                            ModuleGeographicSelection.getLogger().info("ModuleGeographicSelection.onConnect[" + this.appContext + "]: Geographic client id '" + rTPSession.getSessionId() + " connection accepted");
                        }
                        return;
                    }
                    if (this.debug) {
                        ModuleGeographicSelection.getLogger().info("ModuleGeographicSelection.onConnect[" + this.appContext + "]: Geographic client id '" + rTPSession.getSessionId() + " connection rejected");
                    }
                    rTPSession.rejectSession();
                    rTPSession.shutdown();
                    break block12;
                }
                if (this.blockByDefault) {
                    if (this.debug) {
                        ModuleGeographicSelection.getLogger().info("ModuleGeographicSelection.onConnect[" + this.appContext + "]: Geographic client id '" + rTPSession.getSessionId() + " connction blocked");
                    }
                    rTPSession.rejectSession();
                    rTPSession.shutdown();
                    break block12;
                }
                ModuleGeographicSelection.getLogger().info("ModuleGeographicSelection.onConnect[" + this.appContext + "]: Geographic client id '" + rTPSession.getSessionId() + " Accept by default");
                return;
            }
            catch (Exception exception) {
                ModuleGeographicSelection.getLogger().warn("ModuleGeographicSelection.onRTPSessionCreate[" + this.appContext + "]: Exception: " + exception.getMessage());
            }
        }
        if (this.debug) {
            ModuleGeographicSelection.getLogger().info("ModuleGeographicSelection.onConnect[" + this.appContext + "]: Geographic client id '" + rTPSession.getSessionId() + " decision at end, blocked by default");
        }
        rTPSession.rejectSession();
        rTPSession.shutdown();
    }

    public boolean checkAllowedIP(String[] stringArray, String string) {
        try {
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!string.startsWith(stringArray[i].trim()) || stringArray[i].length() <= 0) continue;
                    if (this.debug) {
                        ModuleGeographicSelection.getLogger().info("ModuleGeographicSelection.checkAllowedIP[" + this.appContext + "]: GeoIP Encoder Allowed IP: " + string + " matches " + stringArray[i]);
                    }
                    return true;
                }
            }
        }
        catch (Exception exception) {
            ModuleGeographicSelection.getLogger().warn("ModuleGeographicSelection.checkAllowedIP[" + this.appContext + "]:  Exception: " + exception.getMessage());
        }
        return false;
    }
}

