/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.geoip;

import com.maxmind.geoip.LookupService;
import com.wowza.wms.bootstrap.Bootstrap;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.server.IServer;
import com.wowza.wms.server.IServerNotify2;
import java.io.File;

public class ServerListenerGeographicSelector
implements IServerNotify2 {
    private static boolean geoIPLoaded = false;
    private static LookupService maxMindGeoIPObject = null;
    private static GeographicReloader serverMonitor = null;

    public void onServerCreate(IServer iServer) {
    }

    public void onServerInit(IServer iServer) {
        ServerListenerGeographicSelector.reloadGeoDatabase(iServer);
        serverMonitor = new GeographicReloader(iServer);
        serverMonitor.setDaemon(true);
        serverMonitor.start();
    }

    public void onServerShutdownComplete(IServer iServer) {
    }

    public void onServerShutdownStart(IServer iServer) {
        if (serverMonitor != null) {
            serverMonitor.quit();
        }
    }

    public void onServerConfigLoaded(IServer iServer) {
    }

    private static boolean loadGeoIPDatabase(IServer iServer) {
        boolean bl = false;
        String string = iServer.getProperties().getPropertyStr("geoipDatabaseLocation", Bootstrap.getServerHome((int)2) + File.separatorChar + "conf" + File.separatorChar + "GeoIP.dat");
        try {
            maxMindGeoIPObject = new LookupService(string, 1);
            bl = true;
            iServer.getProperties().setProperty("geoipLocationLoaded", (Object)string);
            WMSLoggerFactory.getLogger(null).info("ServerListenerGeographicSelector.loadGeoIPDatabase: Loaded requested database from " + string);
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(null).warn("ServerListenerGeographicSelector.loadGeoIPDatabase: Could not load requested database; reason " + exception.toString() + " from location " + string);
            bl = false;
        }
        return bl;
    }

    public static LookupService getGeographicObject() {
        return maxMindGeoIPObject;
    }

    public static boolean getGeographicReady() {
        return geoIPLoaded;
    }

    public static boolean reloadGeoDatabase(IServer iServer) {
        if (maxMindGeoIPObject != null && geoIPLoaded) {
            maxMindGeoIPObject.close();
            maxMindGeoIPObject = null;
            geoIPLoaded = false;
        }
        geoIPLoaded = ServerListenerGeographicSelector.loadGeoIPDatabase(iServer);
        return geoIPLoaded;
    }

    public class GeographicReloader
    extends Thread {
        private boolean running = true;
        private boolean quit = false;
        private int sleepTime = 10000;
        private boolean geoReloadFind = false;
        private long lastModifiedLoad = 0L;
        private IServer server = null;

        public GeographicReloader(IServer iServer) {
            this.server = iServer;
        }

        public synchronized boolean running() {
            return this.running;
        }

        public synchronized void quit() {
            this.quit = true;
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                String string = this.server.getProperties().getPropertyStr("geoipDatabaseLocation", Bootstrap.getServerHome((int)2) + File.separatorChar + "conf" + File.separatorChar + "GeoIP.dat");
                File file = new File(string);
                long l = file.lastModified();
                long l2 = System.currentTimeMillis() / 1000L;
                long l3 = l2 - (long)(this.sleepTime / 1000 * 6);
                if (this.geoReloadFind && (l /= 1000L) == this.lastModifiedLoad) {
                    ServerListenerGeographicSelector.reloadGeoDatabase(this.server);
                }
                if (this.geoReloadFind) {
                    this.geoReloadFind = false;
                }
                if (l > l3) {
                    this.lastModifiedLoad = l;
                    this.geoReloadFind = true;
                }
                GeographicReloader geographicReloader = this;
                synchronized (geographicReloader) {
                    try {
                        Thread.currentThread().wait(this.sleepTime);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                geographicReloader = this;
                synchronized (geographicReloader) {
                    if (this.quit) {
                        this.running = false;
                        break;
                    }
                }
            }
        }
    }
}

