package com.wowza.wms.plugin.geoip;

import com.maxmind.geoip.LookupService;
import com.wowza.wms.amf.AMFDataList;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.client.IClient;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.request.RequestFunction;
import com.wowza.wms.rtp.model.RTPSession;

public class ModuleGeographicSelection extends ModuleBase {
	
	private LookupService maxMindObject = null;
	private boolean geographicReady = false;
	private boolean geoGraphicInclude = true;
	private boolean debug = false;
	private boolean blockByDefault = true;
	private String allowedEncoder[] = {};
	private String allowedIP[] = {};
	private String appContext = "";
	private String countries = "";

	public void onAppStart(IApplicationInstance appInstance) 
	{
		this.appContext = appInstance.getApplication().getName() + "/" + appInstance.getName();
		getLogger().info("ModuleGeographicSelection.onAppStart["+ appContext+ "]");

		this.maxMindObject = ServerListenerGeographicSelector.getGeographicObject();
		this.geographicReady = ServerListenerGeographicSelector.getGeographicReady();
		this.allowedEncoder = appInstance.getProperties().getPropertyStr("geoipAllowEncoder", "").toLowerCase().split(",");
		this.allowedIP = appInstance.getProperties().getPropertyStr("geoipAllowIP", "").toLowerCase().split(",");
		this.debug = appInstance.getProperties().getPropertyBoolean("geoipDebug", debug);
		this.geoGraphicInclude = appInstance.getProperties().getPropertyBoolean("geoipCountriesInclude", geoGraphicInclude);
		this.countries = appInstance.getProperties().getPropertyStr("geoipCountries", countries);
		this.blockByDefault = appInstance.getProperties().getPropertyBoolean("geoipBlockByDefault", blockByDefault);
	}

	public void onConnect(IClient client, RequestFunction function,	AMFDataList params) 
	{
		getLogger().info("ModuleGeographicSelection.onConnect["+appContext+"]: clientID:" + client.getClientId());
		
		String flashver = client.getFlashVer().toLowerCase();
		if (debug)
		{
			getLogger().info("ModuleGeographicSelection.onConnect["+appContext+"]: flashver: " + flashver);
		}
		
		try
		{ 
			if (this.allowedEncoder != null)
			{ 
				for (int i = 0; i < this.allowedEncoder.length; i++) 
				{  
					if (flashver.startsWith(this.allowedEncoder[i].trim()) && this.allowedEncoder[i].length()>0) 
					{ 
						if (this.debug)
						{
							getLogger().info("ModuleGeographicSelection.onConnect["+appContext+"]: GeoIP Encoder Allowed: "+flashver+" matches "+allowedEncoder[i]);
						}
						return;
					} 
				} 
			}
			if (checkAllowedIP(allowedIP, client.getIp()))
			{
				if (this.debug)
					{
					getLogger().info("ModuleGeographicSelection.onConnect["+appContext+"]: AllowedIP Passed check: "+allowedIP+" client ip "+client.getIp());
					}
				return;
			}

			if (this.debug)
				{
				getLogger().info("ModuleGeographicSelection.onConnect["+appContext+"]: Geographic client id "+client.getClientId()+" failed AllowedIP check");
				}
			
			if (this.geographicReady)
			{
				if (this.debug)
					{
					getLogger().info("ModuleGeographicSelection.onConnect["+appContext+"]: Geographic client id "+client.getClientId()+" code is "+this.maxMindObject.getCountry(client.getIp()).getCode()+" list is "+this.countries);
					}
				if (this.countries.contains(this.maxMindObject.getCountry(client.getIp()).getCode()) == this.geoGraphicInclude)
				{
					if (this.debug)
						{
						getLogger().info("ModuleGeographicSelection.onConnect["+appContext+"]: Geographic client id "+client.getClientId()+" connection accepted");
						}
					client.acceptConnection();
					return;
				}
				else
				{
					if (this.debug)
						{
						getLogger().info("ModuleGeographicSelection.onConnect["+appContext+"]: Geographic client id "+client.getClientId()+" connection rejected");
						}
					client.rejectConnection();
				}
			}
			else
			{
				if (this.blockByDefault)
				{
					if (this.debug)
						{
						getLogger().info("ModuleGeographicSelection.onConnect["+appContext+"]: Geographic client id "+client.getClientId()+" connction blocked");
						}
					client.rejectConnection("Geographic blocking not available, blocking client id "+client.getClientId()+" connection");
				}
				else
				{
					getLogger().info("ModuleGeographicSelection.onConnect["+appContext+"]: Geographic client id "+client.getClientId()+" Accept by default");
					client.acceptConnection();
					return;
				}
			}
		} 
		catch (Exception e) 
		{
			getLogger().warn("ModuleGeographicSelection.onConnect["+appContext+"]: Exception: " + e.getMessage()); 
		}

		if (this.debug)
			{
			getLogger().info("ModuleGeographicSelection.onConnect["+appContext+"]: Geographic client id "+client.getClientId()+" decision at end, blocked by default");
			}

		client.rejectConnection();
		client.shutdownClient();
	}

	public void onHTTPSessionCreate(IHTTPStreamerSession httpSession) 
	{
		getLogger().info("ModuleGeographicSelection.onHTTPSessionCreate["+appContext+"]: sessionID:" + httpSession.getSessionId());

		try
		{
			if (checkAllowedIP(allowedIP, httpSession.getIpAddress()))
			{
				if (this.debug)
				{
				getLogger().info("ModuleGeographicSelection.onConnect["+appContext+"]: AllowedIP Passed check: "+allowedIP+" client id "+httpSession.getSessionId()+" ip "+httpSession.getIpAddress());
				}
				return;
			}
			

			if (this.debug)
				{
				getLogger().info("ModuleGeographicSelection.onConnect["+appContext+"]: client id "+httpSession.getSessionId()+" failed AllowedIP check");
				}
			

			if (this.geographicReady)
			{
				if (this.debug)
					{
					getLogger().info("ModuleGeographicSelection.onConnect["+appContext+"]: Geographic client id '"+httpSession.getSessionId()+" code is "+this.maxMindObject.getCountry(httpSession.getIpAddress()).getCode()+" list is "+this.countries);
					}

				if (this.countries.contains(this.maxMindObject.getCountry(httpSession.getIpAddress()).getCode()) == this.geoGraphicInclude)
				{
					if (this.debug)
					{
					getLogger().info("ModuleGeographicSelection.onConnect["+appContext+"]: Geographic client id '"+httpSession.getSessionId()+" connection accepted");
					}
					return;
				}
				else
				{
					if (this.debug)
					{
					getLogger().info("ModuleGeographicSelection.onConnect["+appContext+"]: Geographic client id '"+httpSession.getSessionId()+" connection rejected");
					}
					httpSession.rejectSession();
					httpSession.shutdown();
				}
			}
			else
			{
				if (this.blockByDefault)
				{
					if (this.debug)
						{
						getLogger().info("ModuleGeographicSelection.onConnect["+appContext+"]: Geographic client id '"+httpSession.getSessionId()+" connction blocked");
						}
					httpSession.rejectSession();
					httpSession.shutdown();
				}
				else
				{
					getLogger().info("ModuleGeographicSelection.onConnect["+appContext+"]: Geographic client id '"+httpSession.getSessionId()+" Accept by default");
					return;
				}

			}
		}
		catch (Exception e) 
		{
			getLogger().warn("ModuleGeographicSelection.onHTTPSessionCreate["+appContext+"]: Exception: " + e.getMessage()); 
		}
		
		if (this.debug)
			{
			getLogger().info("ModuleGeographicSelection.onConnect["+appContext+"]: Geographic client id '"+httpSession.getSessionId()+" decision at end, blocked by default");
			}

		httpSession.rejectSession();
		httpSession.shutdown();
	}

	public void onRTPSessionCreate(RTPSession rtpSession) 
	{
		getLogger().info("ModuleGeographicSelection.onRTPSessionCreate["+appContext+"]: sessionID:" + rtpSession.getSessionId());

		try
		{
			if (checkAllowedIP(allowedIP, rtpSession.getIp()))
			{
				if (this.debug)
					{
					getLogger().info("ModuleGeographicSelection.onConnect["+appContext+"]: AllowedIP Passed check: "+allowedIP+" client ip "+rtpSession.getSessionId());
					}
				return;
			}
			
			if (this.geographicReady)
			{
				if (this.debug)
					{
					getLogger().info("ModuleGeographicSelection.onConnect["+appContext+"]: Geographic client id '"+rtpSession.getSessionId()+" code is "+this.maxMindObject.getCountry(rtpSession.getIp()).getCode()+" list is "+this.countries);
					}


				if (this.countries.contains(this.maxMindObject.getCountry(rtpSession.getIp()).getCode()) == this.geoGraphicInclude)
					{	
					if (this.debug)
						{
						getLogger().info("ModuleGeographicSelection.onConnect["+appContext+"]: Geographic client id '"+rtpSession.getSessionId()+" connection accepted");
						}
					return;
					}
					else
					{
						if (this.debug)
						{
							getLogger().info("ModuleGeographicSelection.onConnect["+appContext+"]: Geographic client id '"+rtpSession.getSessionId()+" connection rejected");
						}	
					rtpSession.rejectSession();
					rtpSession.shutdown();
					}

			}
			else
			{
				if (this.blockByDefault)
				{
					if (this.debug)
						{
						getLogger().info("ModuleGeographicSelection.onConnect["+appContext+"]: Geographic client id '"+rtpSession.getSessionId()+" connction blocked");
						}
					rtpSession.rejectSession();
					rtpSession.shutdown();
				}
				else
				{
					getLogger().info("ModuleGeographicSelection.onConnect["+appContext+"]: Geographic client id '"+rtpSession.getSessionId()+" Accept by default");
					return;
				}

			}

		}
		catch (Exception e) 
		{
			getLogger().warn("ModuleGeographicSelection.onRTPSessionCreate["+appContext+"]: Exception: " + e.getMessage()); 
		}
		if (this.debug)
			{
			getLogger().info("ModuleGeographicSelection.onConnect["+appContext+"]: Geographic client id '"+rtpSession.getSessionId()+" decision at end, blocked by default");
			}
		rtpSession.rejectSession();
		rtpSession.shutdown();
	}
	
	public boolean checkAllowedIP(String parts[], String IP)
	{		
		try
		{ 
			if (parts != null)
			{ 
				for (int i = 0; i < parts.length; i++) 
				{  
					if (IP.startsWith(parts[i].trim()) && parts[i].length()>0) 
					{ 
						if (this.debug)
						{
							getLogger().info("ModuleGeographicSelection.checkAllowedIP["+appContext+"]: GeoIP Encoder Allowed IP: "+IP+" matches "+parts[i]);
						}
						return true;
					} 
				} 
			} 
		} 
		catch (Exception e) 
		{
			getLogger().warn("ModuleGeographicSelection.checkAllowedIP["+appContext+"]:  Exception: " + e.getMessage()); 
		}
		return false;
	}
}