package com.wowza.wms.plugin.geoip;

import java.io.File;

import com.maxmind.geoip.LookupService;
import com.wowza.wms.bootstrap.Bootstrap;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.server.*;


public class ServerListenerGeographicSelector implements IServerNotify2
{

	// internal class
	public class GeographicReloader extends Thread 
	{
		private boolean running = true;
		private boolean quit = false;
		private int sleepTime = 10000;
		private boolean geoReloadFind  = false;
		private long lastModifiedLoad = 0L;
		private IServer server = null;
		
		public GeographicReloader(IServer server)
		{
			this.server = server;
		}

		public synchronized boolean running()
		{
			return this.running;
		}
		
		public synchronized void quit()
		{
			this.quit = true;
			notify();
		}
		
		public void run()
		{
			while (true)
			{
				String databaseLocation = server.getProperties().getPropertyStr("geoipDatabaseLocation", Bootstrap.getServerHome(Bootstrap.CONFIGHOME)+File.separatorChar+"conf"+File.separatorChar+"GeoIP.dat");

				File geoIPReload = new File(databaseLocation);		
				
				long lastModified = geoIPReload.lastModified();
				lastModified = lastModified/1000;
				long epoch = System.currentTimeMillis()/1000;
				
				long calc = epoch - ( (this.sleepTime /1000)*6 );

				if (this.geoReloadFind == true && lastModified == this.lastModifiedLoad)
				{
					ServerListenerGeographicSelector.reloadGeoDatabase(this.server);
				}
				
				if (this.geoReloadFind == true)
				{
					this.geoReloadFind = false;
				}
				
				if (lastModified > calc) 
				{
					this.lastModifiedLoad = lastModified;
					this.geoReloadFind = true;
				}
				
				synchronized(this)
				{
					try
					{
						Thread.currentThread().wait(this.sleepTime);
					}
					catch (Exception e)
					{
						//Log.error("WorkerClass.run: wait: "+e.toString());
					}
				}

				synchronized(this)
				{
					if (this.quit)
					{
						this.running = false;
						break;
					}
				}
			}
		}
	}

	
	
	private static boolean geoIPLoaded = false;
	private static LookupService maxMindGeoIPObject = null;
	private static GeographicReloader serverMonitor = null;

	public void onServerCreate(IServer server) 
	{
	}

	public void onServerInit(IServer server) 
	{
		reloadGeoDatabase(server);
		serverMonitor = new GeographicReloader(server);
		serverMonitor.setDaemon(true);
		serverMonitor.start();
	}

	public void onServerShutdownComplete(IServer server) 
	{
	}

	public void onServerShutdownStart(IServer server) 
	{
		if (serverMonitor!=null)
		{
			serverMonitor.quit();
		}
	}

	public void onServerConfigLoaded(IServer server) 
	{
	}
	
	private static boolean loadGeoIPDatabase(IServer server)
	{
		boolean Loaded = false;
		String databaseLocation = server.getProperties().getPropertyStr("geoipDatabaseLocation", Bootstrap.getServerHome(Bootstrap.CONFIGHOME)+File.separatorChar+"conf"+File.separatorChar+"GeoIP.dat");

		try 
		{
			maxMindGeoIPObject = new LookupService(databaseLocation, LookupService.GEOIP_MEMORY_CACHE);
			Loaded = true;
			server.getProperties().setProperty("geoipLocationLoaded", databaseLocation);
			WMSLoggerFactory.getLogger(null).info("ServerListenerGeographicSelector.loadGeoIPDatabase: Loaded requested database from "+databaseLocation);
		} 
		catch (Exception e) 
		{ 
			WMSLoggerFactory.getLogger(null).warn("ServerListenerGeographicSelector.loadGeoIPDatabase: Could not load requested database; reason "+e.toString()+" from location "+databaseLocation);
			Loaded = false; 
		}
		return Loaded;
	}
	
	public static LookupService getGeographicObject()
	{
		return maxMindGeoIPObject;
	}
	
	public static boolean getGeographicReady()
	{
		return geoIPLoaded;
	}
	
	public static boolean reloadGeoDatabase(IServer server)
	{
		if (maxMindGeoIPObject != null && geoIPLoaded == true)
		{
			maxMindGeoIPObject.close();
			maxMindGeoIPObject = null;
			geoIPLoaded = false;
		}
		geoIPLoaded = loadGeoIPDatabase(server);
		return geoIPLoaded;
	}
	
	
}
