/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.livestreamrecord;

import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.http.HTTProvider2Base;
import com.wowza.wms.http.IHTTPRequest;
import com.wowza.wms.http.IHTTPResponse;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.plugin.integration.liverecord.ILiveStreamRecord;
import com.wowza.wms.plugin.integration.liverecord.LiveStreamRecorderFLV;
import com.wowza.wms.plugin.integration.liverecord.LiveStreamRecorderMP4;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.mediacaster.MediaStreamMediaCasterUtils;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.StreamItem;
import com.wowza.wms.vhost.StreamList;
import java.io.File;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HTTPLiveStreamRecord
extends HTTProvider2Base {
    public static final int FORMAT_UNKNOWN = 0;
    public static final int FORMAT_FLV = 1;
    public static final int FORMAT_MP4 = 2;
    private Map<String, ILiveStreamRecord> recorders = new HashMap<String, ILiveStreamRecord>();
    private IApplicationInstance appInstance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onHTTPRequest(IVHost vhost, IHTTPRequest req, IHTTPResponse resp) {
        String report;
        block33: {
            if (!this.doHTTPAuthentication(vhost, req, resp)) {
                return;
            }
            WMSLoggerFactory.getLogger(null).info("ModuleStreamRecord HTTPRequest");
            Map params = req.getParameterMap();
            boolean append = false;
            String outputPath = null;
            int format = 1;
            boolean versionFile = true;
            boolean startOnKeyFrame = false;
            boolean recordData = true;
            String action = "";
            String app = "";
            String streamName = "";
            report = "";
            if (req.getMethod().equalsIgnoreCase("get") || req.getMethod().equalsIgnoreCase("post")) {
                req.parseBodyForParams(true);
                try {
                    if (params.containsKey("action")) {
                        action = (String)((List)params.get("action")).get(0);
                    } else {
                        report = report + "<BR>action is required";
                    }
                    WMSLoggerFactory.getLogger(null).info("ModuleStreamRecord action: " + action);
                    if (params.containsKey("app")) {
                        app = (String)((List)params.get("app")).get(0);
                    } else {
                        report = report + "<BR>app is required";
                    }
                    WMSLoggerFactory.getLogger(null).info("ModuleStreamRecord app: " + app);
                    if (params.containsKey("streamname")) {
                        streamName = (String)((List)params.get("streamname")).get(0);
                    } else {
                        report = report + "<BR>streamname is required";
                    }
                    WMSLoggerFactory.getLogger(null).info("ModuleStreamRecord streamName: " + streamName);
                    if (params.containsKey("output")) {
                        outputPath = (String)((List)params.get("output")).get(0);
                    }
                    if (outputPath != null) {
                        outputPath = outputPath.equalsIgnoreCase("") ? null : outputPath;
                    }
                    WMSLoggerFactory.getLogger(null).info("ModuleStreamRecord outputPath: " + outputPath);
                    if (params.containsKey("append")) {
                        append = Boolean.parseBoolean((String)((List)params.get("append")).get(0));
                    }
                    WMSLoggerFactory.getLogger(null).info("ModuleStreamRecord append: " + append);
                    if (params.containsKey("version")) {
                        versionFile = Boolean.parseBoolean((String)((List)params.get("version")).get(0));
                    }
                    WMSLoggerFactory.getLogger(null).info("ModuleStreamRecord version: " + versionFile);
                    if (params.containsKey("startonkeyframe")) {
                        startOnKeyFrame = Boolean.parseBoolean((String)((List)params.get("startonkeyframe")).get(0));
                    }
                    WMSLoggerFactory.getLogger(null).info("ModuleStreamRecord startOnKeyFrame: " + startOnKeyFrame);
                    if (params.containsKey("recorddata")) {
                        recordData = Boolean.parseBoolean((String)((List)params.get("recorddata")).get(0));
                    }
                    WMSLoggerFactory.getLogger(null).info("ModuleStreamRecord recordData: " + recordData);
                    if (params.containsKey("format")) {
                        format = Integer.parseInt((String)((List)params.get("format")).get(0));
                    }
                    WMSLoggerFactory.getLogger(null).info("ModuleStreamRecord format (1=flv, 2=mp4): " + format);
                }
                catch (Exception ex) {
                    report = "Error: " + ex.getMessage();
                }
            } else {
                report = "Nothing to do.";
            }
            try {
                IApplicationInstance appInstance = vhost.getApplication(app).getAppInstance("_definst_");
                if (!appInstance.getPublishStreamNames().contains(streamName)) {
                    report = "Stream " + streamName + " is not live ";
                }
                if (action.equalsIgnoreCase("startRecording") && report.equalsIgnoreCase("")) {
                    IMediaStream stream;
                    WMSLoggerFactory.getLogger(null).info("ModuleStreamRecord.startRecording");
                    String streamTypeStr = appInstance.getStreamType();
                    boolean isLiveRepeaterEdge = false;
                    StreamList streamDefs = appInstance.getVHost().getStreamTypes();
                    StreamItem streamDef = streamDefs.getStreamDef(streamTypeStr);
                    if (streamDef != null) {
                        isLiveRepeaterEdge = streamDef.getProperties().getPropertyBoolean("isLiveRepeaterEdge", isLiveRepeaterEdge);
                    }
                    if (isLiveRepeaterEdge) {
                        streamName = MediaStreamMediaCasterUtils.mapMediaCasterName((IApplicationInstance)appInstance, null, (String)streamName);
                    }
                    if ((stream = appInstance.getStreams().getStream(streamName)) != null) {
                        this.recordStream(stream, format, append, outputPath, versionFile, startOnKeyFrame, recordData);
                        report = action + " " + streamName;
                    } else {
                        WMSLoggerFactory.getLogger(null).warn("ModuleStreamRecord.startRecording: stream not found: " + streamName);
                        report = "Stream Not Found: " + streamName;
                    }
                    break block33;
                }
                if (!(action.equalsIgnoreCase("stopRecording") & report.equalsIgnoreCase(""))) break block33;
                WMSLoggerFactory.getLogger(null).info("ModuleStreamRecord.stopRecording: " + streamName);
                ILiveStreamRecord recorder = null;
                Map<String, ILiveStreamRecord> isLiveRepeaterEdge = this.recorders;
                synchronized (isLiveRepeaterEdge) {
                    recorder = this.recorders.remove(streamName);
                }
                if (recorder != null) {
                    outputPath = recorder.getFilePath();
                    recorder.stopRecording();
                    report = action + " " + streamName;
                } else {
                    WMSLoggerFactory.getLogger(null).warn("ModuleStreamRecord.stopRecording: stream recorder not found: " + streamName);
                    report = "Stream Recorder Not Found: " + streamName;
                }
            }
            catch (Exception e) {
                report = "Error: " + e.getMessage();
            }
        }
        String retStr = "<html><head><title>HTTProvider LiveRecord</title></head><body><h1>" + report + "</h1></body></html>";
        try {
            OutputStream out = resp.getOutputStream();
            byte[] outBytes = retStr.getBytes();
            out.write(outBytes);
        }
        catch (Exception e) {
            WMSLoggerFactory.getLogger(null).error("HTTPLiveStreamRecord: " + e.toString());
        }
    }

    public void recordStream(String streamName, int format, boolean append, String outputPath, boolean versionFile, boolean startOnKeyFrame, boolean recordData) {
        IMediaStream stream = this.appInstance.getStreams().getStream(streamName);
        if (stream != null) {
            this.recordStream(stream, format, append, outputPath, versionFile, startOnKeyFrame, recordData);
        } else {
            WMSLoggerFactory.getLogger(null).warn("ModuleLiveStreamRecord.recordStream: Stream not found: " + streamName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordStream(IMediaStream stream, int format, boolean append, String outputPath, boolean versionFile, boolean startOnKeyFrame, boolean recordData) {
        String streamName = stream.getName();
        if (format == 0) {
            format = 1;
            String extStr = stream.getExt();
            if (extStr.equals("mp4")) {
                format = 2;
            }
        }
        String params = "stream:" + streamName;
        params = params + " format:" + (format == 2 ? "mp4" : "flv");
        params = params + " append:" + append;
        if (outputPath != null) {
            params = params + " outputPath:" + outputPath;
        } else {
            File writeFile = stream.getStreamFileForWrite(stream.getName(), format == 2 ? "mp4" : "flv", stream.getQueryStr());
            params = params + " outputPath:" + writeFile.getAbsolutePath();
        }
        params = params + " versionFile:" + versionFile;
        params = params + " startOnKeyFrame:" + startOnKeyFrame;
        params = params + " recordData:" + recordData;
        Object recorder = null;
        recorder = format == 2 ? new LiveStreamRecorderMP4() : new LiveStreamRecorderFLV();
        Map<String, ILiveStreamRecord> map = this.recorders;
        synchronized (map) {
            ILiveStreamRecord prevRecorder = this.recorders.get(streamName);
            if (prevRecorder != null) {
                prevRecorder.stopRecording();
            }
            this.recorders.put(streamName, (ILiveStreamRecord)recorder);
        }
        recorder.setRecordData(recordData);
        recorder.setVersionFile(versionFile);
        recorder.setStartOnKeyFrame(startOnKeyFrame);
        recorder.startRecording(stream, outputPath, append);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String stopRecording(String streamName) {
        ILiveStreamRecord recorder = null;
        Map<String, ILiveStreamRecord> map = this.recorders;
        synchronized (map) {
            recorder = this.recorders.remove(streamName);
        }
        String outputPath = null;
        if (recorder != null) {
            outputPath = recorder.getFilePath();
            recorder.stopRecording();
        } else {
            WMSLoggerFactory.getLogger(null).warn("ModuleStreamRecord.stopRecording: stream recorder not found: " + streamName);
        }
        return outputPath;
    }
}

