/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.integration.liverecord;

import com.wowza.util.FLVUtils;
import com.wowza.wms.amf.AMFPacket;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.plugin.integration.liverecord.ILiveStreamRecord;
import com.wowza.wms.plugin.integration.liverecord.LiveStreamRecordActionNotifier;
import com.wowza.wms.plugin.integration.liverecord.LiveStreamRecorderBase;
import com.wowza.wms.plugin.integration.liverecord.LiveStreamRecorderFLV;
import com.wowza.wms.plugin.integration.liverecord.LiveStreamRecorderWorker;
import com.wowza.wms.stream.IMediaStream;
import com.wowza.wms.stream.IMediaStreamActionNotify;
import com.wowza.wms.stream.IMediaWriter;
import com.wowza.wms.stream.MediaWriterFactory;
import com.wowza.wms.stream.MediaWriterList;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiveStreamRecorderMediaWriter
extends LiveStreamRecorderBase
implements ILiveStreamRecord {
    private long startTC = 0L;
    private long timecodeOffset = -1L;
    private boolean waitForKeyFrame = true;
    private long lastSeq = -1L;
    private long lastTC = -1L;
    private int startVideoFrames = 0;
    private int startTotalFrames = 0;
    private boolean isFirstAudio = true;
    private boolean isFirstVideo = true;
    boolean isFirstWrite = true;
    private WriterContext writerContext = null;
    private IMediaWriter mediaWriter = null;
    private String mediaWriterType = null;

    public void setMediaWriterType(String mediaWriterType) {
        this.mediaWriterType = mediaWriterType;
    }

    private void closeFile() {
        this.writerContext.flush(true);
        this.mediaWriter = null;
    }

    private void openFile(boolean append) {
        this.stream.setAppend(append);
        this.mediaWriter = MediaWriterFactory.getInstance((MediaWriterList)this.stream.getStreams().getVHost().getMediaWriters(), (String)this.mediaWriterType, (IMediaStream)this.stream);
        this.mediaWriter.setVersionFile(this.versionFile);
        this.mediaWriter.setWaitForVideoKeyFrame(this.waitForKeyFrame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopWorker(boolean wait) {
        Object object = this.writeLock;
        synchronized (object) {
            if (this.worker != null) {
                this.worker.quit();
            }
        }
        if (this.worker != null && wait) {
            while (this.worker.running()) {
                try {
                    Thread.currentThread();
                    Thread.sleep(1L);
                }
                catch (Exception e) {
                    WMSLoggerFactory.getLogger(LiveStreamRecorderFLV.class).error("LiveStreamRecorder.stopWorker: sleep: " + e.toString());
                }
            }
        }
    }

    @Override
    public void startRecording(IMediaStream stream, boolean append) {
        this.startRecording(stream, null, append, null);
    }

    @Override
    public void startRecording(IMediaStream stream, String filePath, boolean append) {
        this.startRecording(stream, filePath, append, null);
    }

    @Override
    public void startRecording(IMediaStream stream, String filePath, boolean append, Map extraMetadata) {
        try {
            this.stopWorker(false);
            this.worker = null;
            this.closeFile();
            this.stream = stream;
            if (filePath == null) {
                File tmp = stream.getStreamFileForWrite();
                this.filePath = tmp.getAbsolutePath();
            } else {
                this.filePath = filePath;
            }
            this.streamNotifier = new LiveStreamRecordActionNotifier(this);
            this.stream.addClientListener((IMediaStreamActionNotify)this.streamNotifier);
            this.timecodeOffset = -1L;
            this.waitForKeyFrame = true;
            this.lastSeq = -1L;
            this.lastTC = -1L;
            this.startTC = 0L;
            this.startVideoFrames = 0;
            this.startTotalFrames = 0;
            this.openFile(append);
            this.worker = new LiveStreamRecorderWorker(this);
            this.worker.setDaemon(true);
            this.worker.start();
        }
        catch (Exception e) {
            WMSLoggerFactory.getLogger(LiveStreamRecorderFLV.class).error("LiveStreamRecorder.startRecording: " + e.toString());
            e.printStackTrace();
        }
    }

    @Override
    public void stopRecording() {
        try {
            this.stopWorker(true);
            this.worker = null;
        }
        catch (Exception e) {
            WMSLoggerFactory.getLogger(LiveStreamRecorderFLV.class).error("LiveStreamRecorder.stopRecording: " + e.toString());
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetStream() {
        Object object = this.writeLock;
        synchronized (object) {
            if (this.lastTC != -1L) {
                this.startTC = this.lastTC;
            }
            this.timecodeOffset = -1L;
            this.waitForKeyFrame = true;
            this.lastSeq = -1L;
            this.lastTC = -1L;
            this.startVideoFrames = 0;
            this.startTotalFrames = 0;
            this.isFirstAudio = true;
            this.isFirstVideo = true;
            this.isFirstWrite = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPublish() {
        Object object = this.writeLock;
        synchronized (object) {
            this.resetStream();
            this.openFile(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onUnPublish() {
        Object object = this.writeLock;
        synchronized (object) {
            this.closeFile();
            this.resetStream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void workStop() {
        Object object = this.writeLock;
        synchronized (object) {
            this.closeFile();
        }
        if (this.streamNotifier != null) {
            this.stream.removeClientListener((IMediaStreamActionNotify)this.streamNotifier);
            this.streamNotifier = null;
        }
    }

    protected List<AMFPacket> getPlayPackets() {
        return this.stream.getPlayPackets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void work() {
        Object object = this.writeLock;
        synchronized (object) {
            int numPackets;
            List<AMFPacket> packets;
            if (this.stream != null && this.mediaWriter != null && (packets = this.getPlayPackets()) != null && (numPackets = packets.size()) != 0) {
                int startIdx;
                AMFPacket packet = null;
                packet = packets.get(0);
                long startSeq = packet.getSeq();
                int n = startIdx = this.lastSeq == -1L ? 0 : (int)(this.lastSeq - startSeq + 1L);
                if (startIdx < 0) {
                    startIdx = 0;
                }
                if (startIdx < numPackets) {
                    int packetType;
                    int idx;
                    if (this.timecodeOffset == -1L) {
                        for (idx = numPackets - 1; idx >= 0; --idx) {
                            packet = packets.get(idx);
                            packetType = packet.getType();
                            if (packetType != 9 && packetType != 8) continue;
                            ++this.startTotalFrames;
                            if (this.isStartOnKeyFrame()) {
                                if (packetType == 9) {
                                    ++this.startVideoFrames;
                                    if (!FLVUtils.isVideoKeyFrame((AMFPacket)packet)) continue;
                                    startIdx = idx;
                                    this.timecodeOffset = packet.getAbsTimecode();
                                    break;
                                }
                                if (this.startVideoFrames != 0 || this.startTotalFrames <= 20) continue;
                                startIdx = idx;
                                this.timecodeOffset = packet.getAbsTimecode();
                                break;
                            }
                            startIdx = idx;
                            this.timecodeOffset = packet.getAbsTimecode();
                            break;
                        }
                    }
                    if (this.timecodeOffset >= 0L) {
                        block12: for (idx = startIdx; idx < numPackets; ++idx) {
                            AMFPacket newPacket;
                            AMFPacket codecConfigPacket;
                            int codec;
                            long adjTimecode;
                            int secondByte;
                            int firstByte;
                            packet = packets.get(idx);
                            packetType = packet.getType();
                            this.lastSeq = packet.getSeq();
                            int size = packet.getSize();
                            if (!this.isRecordData() && packetType != 9 && packetType != 8) continue;
                            boolean sendFrame = true;
                            if (packetType == 9 && size >= 2) {
                                firstByte = packet.getFirstByte();
                                secondByte = packet.getSecondByte();
                                if (size == 2 && (firstByte & 0x50) == 80 && (secondByte == 0 || secondByte == 1)) {
                                    sendFrame = false;
                                }
                            }
                            if (packetType == 8 && size >= 2) {
                                firstByte = packet.getFirstByte();
                                secondByte = packet.getSecondByte();
                            }
                            if (!sendFrame || (adjTimecode = packet.getAbsTimecode() - this.timecodeOffset) < 0L) continue;
                            this.lastTC = adjTimecode + this.startTC;
                            if (packetType == 8) {
                                if (this.isFirstAudio) {
                                    int firstByte2 = packet.getFirstByte();
                                    codec = FLVUtils.getAudioCodec((int)firstByte2);
                                    if (codec == 10) {
                                        try {
                                            codecConfigPacket = this.stream.getAudioCodecConfigPacket(packet.getAbsTimecode());
                                            if (codecConfigPacket != null) {
                                                this.writerContext.addAudio(codecConfigPacket.getDataBuffer(), this.lastTC);
                                            }
                                        }
                                        catch (Exception e) {
                                            WMSLoggerFactory.getLogger(LiveStreamRecorderFLV.class).error("LiveStreamRecorderFLV.extractAACCodecInfoFromStream: " + e.toString());
                                        }
                                    }
                                    this.isFirstAudio = false;
                                }
                            } else if (packetType == 9 && this.isFirstVideo) {
                                int firstByte3 = packet.getFirstByte();
                                codec = FLVUtils.getVideoCodec((int)firstByte3);
                                if (codec == 7) {
                                    try {
                                        codecConfigPacket = this.stream.getVideoCodecConfigPacket(packet.getAbsTimecode());
                                        if (codecConfigPacket != null) {
                                            this.writerContext.addVideo(codecConfigPacket.getDataBuffer(), this.lastTC);
                                        }
                                    }
                                    catch (Exception e) {
                                        WMSLoggerFactory.getLogger(LiveStreamRecorderFLV.class).error("LiveStreamRecorderFLV.extractH264CodecInfoFromStream: " + e.toString());
                                    }
                                }
                                this.isFirstVideo = false;
                            }
                            if ((packetType == 18 || packetType == 15) && (newPacket = FLVUtils.updateOnCuePointTimecode((AMFPacket)packet, (long)this.lastTC)) != null) {
                                packet = newPacket;
                            }
                            switch (packetType) {
                                case 9: {
                                    this.writerContext.addVideo(packet.getDataBuffer(), this.lastTC);
                                    continue block12;
                                }
                                case 8: {
                                    this.writerContext.addAudio(packet.getDataBuffer(), this.lastTC);
                                    continue block12;
                                }
                                default: {
                                    this.writerContext.addData(packet.getDataBuffer(), this.lastTC);
                                }
                            }
                        }
                    }
                    this.writerContext.flush(false);
                }
            }
        }
    }

    class WriterContext {
        List<ByteBuffer> audioPackets = new ArrayList<ByteBuffer>();
        List<ByteBuffer> videoPackets = new ArrayList<ByteBuffer>();
        List<ByteBuffer> dataPackets = new ArrayList<ByteBuffer>();
        List<Long> audioTCs = new ArrayList<Long>();
        List<Long> videoTCs = new ArrayList<Long>();
        List<Long> dataTCs = new ArrayList<Long>();
        int packetCount = 0;

        WriterContext() {
        }

        public void addAudio(ByteBuffer data, long timecode) {
            this.audioPackets.add(data);
            this.audioTCs.add(new Long(timecode));
            ++this.packetCount;
        }

        public void addVideo(ByteBuffer data, long timecode) {
            this.videoPackets.add(data);
            this.videoTCs.add(new Long(timecode));
            ++this.packetCount;
        }

        public void addData(ByteBuffer data, long timecode) {
            this.dataPackets.add(data);
            this.dataTCs.add(new Long(timecode));
            ++this.packetCount;
        }

        void flush(boolean isLast) {
            if (LiveStreamRecorderMediaWriter.this.mediaWriter != null && (this.packetCount > 0 || isLast)) {
                LiveStreamRecorderMediaWriter.this.mediaWriter.writePackets(this.audioPackets, this.videoPackets, this.dataPackets, this.audioTCs, this.videoTCs, this.dataTCs, null, LiveStreamRecorderMediaWriter.this.isFirstWrite, isLast);
            }
            LiveStreamRecorderMediaWriter.this.isFirstWrite = false;
            this.packetCount = 0;
            this.audioPackets.clear();
            this.videoPackets.clear();
            this.dataPackets.clear();
            this.audioTCs.clear();
            this.videoTCs.clear();
            this.dataTCs.clear();
        }
    }
}

