/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.loadbalancer.encryption;

public class LoadBalancerEncrypterTEA {
    private static final int SUGAR = -1640531527;
    private static final int CUPS = 32;
    private static final int UNSUGAR = -957401312;
    private final int[] S = new int[4];

    public LoadBalancerEncrypterTEA(byte[] byArray) {
        if (byArray == null) {
            throw new RuntimeException("Invalid key: Key was null");
        }
        if (byArray.length < 16) {
            throw new RuntimeException("Invalid key: Length was less than 16 bytes");
        }
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            this.S[i] = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        }
    }

    public byte[] encrypt(byte[] byArray) {
        int n = (byArray.length / 8 + (byArray.length % 8 == 0 ? 0 : 1)) * 2;
        int[] nArray = new int[n + 1];
        nArray[0] = byArray.length;
        this.pack(byArray, nArray, 1);
        this.brew(nArray);
        return this.unpack(nArray, 0, nArray.length * 4);
    }

    public byte[] decrypt(byte[] byArray) {
        assert (byArray != null);
        assert (byArray.length % 4 == 0);
        assert (byArray.length / 4 % 2 != 0);
        int[] nArray = new int[byArray.length / 4];
        this.pack(byArray, nArray, 0);
        this.unbrew(nArray);
        return this.unpack(nArray, 1, nArray[0]);
    }

    void brew(int[] nArray) {
        assert (nArray.length % 2 == 1);
        for (int i = 1; i < nArray.length; i += 2) {
            int n = 32;
            int n2 = nArray[i];
            int n3 = nArray[i + 1];
            int n4 = 0;
            while (n-- > 0) {
                n3 += (((n2 += ((n3 << 4) + this.S[0] ^ n3) + ((n4 -= 1640531527) ^ n3 >>> 5) + this.S[1]) << 4) + this.S[2] ^ n2) + (n4 ^ n2 >>> 5) + this.S[3];
            }
            nArray[i] = n2;
            nArray[i + 1] = n3;
        }
    }

    void unbrew(int[] nArray) {
        assert (nArray.length % 2 == 1);
        for (int i = 1; i < nArray.length; i += 2) {
            int n = 32;
            int n2 = nArray[i];
            int n3 = nArray[i + 1];
            int n4 = -957401312;
            while (n-- > 0) {
                n2 -= (((n3 -= ((n2 << 4) + this.S[2] ^ n2) + (n4 ^ n2 >>> 5) + this.S[3]) << 4) + this.S[0] ^ n3) + (n4 ^ n3 >>> 5) + this.S[1];
                n4 += 1640531527;
            }
            nArray[i] = n2;
            nArray[i + 1] = n3;
        }
    }

    void pack(byte[] byArray, int[] nArray, int n) {
        assert (n + byArray.length / 4 <= nArray.length);
        int n2 = 24;
        int n3 = n;
        nArray[n3] = 0;
        for (int i = 0; i < byArray.length; ++i) {
            int n4 = n3++;
            nArray[n4] = nArray[n4] | (byArray[i] & 0xFF) << n2;
            if (n2 == 0) {
                n2 = 24;
                if (n3 >= nArray.length) continue;
                nArray[n3] = 0;
                continue;
            }
            n2 -= 8;
        }
    }

    byte[] unpack(int[] nArray, int n, int n2) {
        assert (n2 <= (nArray.length - n) * 4);
        byte[] byArray = new byte[n2];
        int n3 = n;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            byArray[i] = (byte)(nArray[n3] >> 24 - 8 * n4 & 0xFF);
            if (++n4 != 4) continue;
            n4 = 0;
            ++n3;
        }
        return byArray;
    }
}

