/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.loadbalancer.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.wowza.wms.plugin.loadbalancer.client.ILoadBalancerClientCommunication;
import com.wowza.wms.plugin.loadbalancer.client.ILoadBalancerClientProcessResponse;
import com.wowza.wms.plugin.loadbalancer.client.LoadBalancerClientCommunicationParameters;
import com.wowza.wms.plugin.loadbalancer.encryption.ILoadBalancerDecrypt;
import com.wowza.wms.plugin.loadbalancer.encryption.ILoadBalancerEncrypt;
import com.wowza.wms.plugin.loadbalancer.utils.ILoadBalancerDataRequester;
import com.wowza.wms.plugin.loadbalancer.utils.ILoadBalancerXMLParser;
import com.wowza.wms.plugin.loadbalancer.utils.Logger;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;

public class LoadBalancerClientCommunication
extends Thread
implements ILoadBalancerClientCommunication {
    private static final Class<LoadBalancerClientCommunication> CLASS = LoadBalancerClientCommunication.class;
    private final boolean sendCommandsAsXML = false;
    private final int failCountLimit = 3;
    private final int communicationTimeout = 10000;
    private final String clientCommunicationXMLClass = "/com/wowza/wms/plugin/loadbalancer/templates/ClientCommandXML.xml";
    public String serverIP = "";
    public String serverPort = "";
    public String serverKey = "";
    public String serverPath = "";
    public String clientName = "";
    public String clientScheme = "";
    private boolean connected = false;
    private boolean logNotConnected = true;
    private boolean active = false;
    private boolean available = true;
    private boolean quit = false;
    private boolean debug = false;
    private SAXParserFactory parserFactor = null;
    private SAXParser parser = null;
    private Logger logger = null;
    private int failCount = 0;
    private int clientContinueRunning = 0;
    private String clientCommsTranslated = "";
    private String encryptorClass = "com.wowza.wms.plugin.loadbalancer.encryption.LoadBalancerEncrypt";
    private String decryptorClass = "com.wowza.wms.plugin.loadbalancer.encryption.LoadBalancerDecrypt";
    private String xmlParserClass = "com.wowza.wms.plugin.loadbalancer.client.LoadBalancerClientXMLParser";
    private String processResponseClass = "com.wowza.wms.plugin.loadbalancer.client.LoadBalancerClientProcessResponse";
    private String dataRequesterClass = "com.wowza.wms.plugin.loadbalancer.utils.LoadBalancerURLRequester";
    private ILoadBalancerEncrypt communicationEncrypter = null;
    private ILoadBalancerDecrypt communicationDecrypter = null;
    private ILoadBalancerXMLParser communicationXMLParser = null;
    private ILoadBalancerDataRequester dataRequester = null;
    private ILoadBalancerClientProcessResponse processResponse = null;
    private LoadBalancerClientCommunicationParameters communicationParams = null;
    private Map<String, String> dataSet = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDataSet(Map<String, String> map) {
        Map<String, String> map2 = this.dataSet;
        synchronized (map2) {
            this.dataSet.clear();
            if (map != null) {
                for (String string : map.keySet()) {
                    this.dataSet.put(string, map.get(string));
                }
            }
        }
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public ILoadBalancerDataRequester getDataRequester() {
        return this.dataRequester;
    }

    @Override
    public ILoadBalancerEncrypt getEncrypter() {
        return this.communicationEncrypter;
    }

    @Override
    public ILoadBalancerDecrypt getDecrypter() {
        return this.communicationDecrypter;
    }

    @Override
    public ILoadBalancerClientProcessResponse getClientProcessResponse() {
        return this.processResponse;
    }

    @Override
    public void setEncrytorClass(String string) {
        this.encryptorClass = string;
    }

    @Override
    public String getEncryptorClass() {
        return this.encryptorClass;
    }

    @Override
    public void setDecrytorClass(String string) {
        this.decryptorClass = string;
    }

    @Override
    public String getDecryptorClass() {
        return this.decryptorClass;
    }

    @Override
    public String getXMLParserClass() {
        return this.xmlParserClass;
    }

    @Override
    public void setXMLParserClass(String string) {
        this.xmlParserClass = string;
    }

    @Override
    public String getProcessResponseClass() {
        return this.processResponseClass;
    }

    @Override
    public void setProcessResponseClass(String string) {
        this.processResponseClass = string;
    }

    @Override
    public String getDataRequesterClass() {
        return this.dataRequesterClass;
    }

    @Override
    public void setDataRequesterClass(String string) {
        this.dataRequesterClass = string;
    }

    @Override
    public String getClientName() {
        return this.clientName;
    }

    @Override
    public void setClientName(String string) {
        this.clientName = string;
    }

    @Override
    public String getServerScheme() {
        return this.clientScheme;
    }

    @Override
    public void setServerScheme(String string) {
        this.clientScheme = string;
    }

    @Override
    public boolean init() {
        Class<?> clazz;
        if (this.getDebug()) {
            this.logger.LogMessageInfo(CLASS.toString(), "Init called");
        }
        try {
            clazz = Class.forName(this.getEncryptorClass());
            this.communicationEncrypter = (ILoadBalancerEncrypt)clazz.newInstance();
        }
        catch (Exception exception) {
            if (this.getDebug()) {
                this.logger.LogMessageInfo(CLASS.toString(), "Encryption class not found, not initialising");
            }
            this.available = false;
        }
        try {
            clazz = Class.forName(this.getDecryptorClass());
            this.communicationDecrypter = (ILoadBalancerDecrypt)clazz.newInstance();
        }
        catch (Exception exception) {
            if (this.getDebug()) {
                this.logger.LogMessageInfo(CLASS.toString(), "Decryption class not found, not initialising");
            }
            this.available = false;
        }
        try {
            clazz = Class.forName(this.getXMLParserClass());
            this.communicationXMLParser = (ILoadBalancerXMLParser)clazz.newInstance();
        }
        catch (Exception exception) {
            if (this.getDebug()) {
                this.logger.LogMessageInfo(CLASS.toString(), "XMLParser class not found, not initialising");
            }
            this.available = false;
        }
        try {
            clazz = Class.forName(this.getProcessResponseClass());
            this.processResponse = (ILoadBalancerClientProcessResponse)clazz.newInstance();
            this.processResponse.setLogger(this.logger);
            this.processResponse.setDebug(this.getDebug());
        }
        catch (Exception exception) {
            if (this.getDebug()) {
                this.logger.LogMessageInfo(CLASS.toString(), "Process Response class not found, not initialising");
            }
            this.available = false;
        }
        try {
            clazz = Class.forName(this.getDataRequesterClass());
            this.dataRequester = (ILoadBalancerDataRequester)clazz.newInstance();
            this.dataRequester.setLogger(this.logger);
            this.dataRequester.setServerScheme(this.clientScheme);
            this.dataRequester.setDebug(this.debug);
        }
        catch (Exception exception) {
            if (this.getDebug()) {
                this.logger.LogMessageInfo(CLASS.toString(), "Data Request class not found, not initialising");
            }
            this.available = false;
        }
        if (!this.available) {
            return false;
        }
        this.communicationEncrypter.setKey(this.getServerKey());
        this.communicationEncrypter.initialiseEncryptor();
        this.communicationDecrypter.setKey(this.getServerKey());
        this.communicationDecrypter.initialiseDecryptor();
        this.parserFactor = SAXParserFactory.newInstance();
        this.dataRequester.setServerIP(this.serverIP);
        this.dataRequester.setServerPath(this.serverPath);
        this.dataRequester.setServerPort(this.serverPort);
        this.dataSet = new HashMap<String, String>();
        this.communicationParams = new LoadBalancerClientCommunicationParameters();
        this.communicationParams.setClientName(this.getClientName());
        this.clientCommsTranslated = this.ReturnFileClass(this.clientCommunicationXMLClass);
        this.active = true;
        if (this.getDebug()) {
            this.logger.LogMessageInfo(CLASS.toString(), "Init finished");
        }
        return this.available;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.available) {
            this.clientContinueRunning = 0;
            Map<String, String> map = this;
            synchronized (map) {
                block23: {
                    try {
                        this.mySleep(5000L);
                    }
                    catch (Exception exception) {
                        if (!this.getDebug()) break block23;
                        this.logger.LogMessageDebug(CLASS.toString(), "Sleep exception");
                    }
                }
            }
            if (!this.getConnected()) {
                if (this.logNotConnected) {
                    this.logger.LogMessageInfo(CLASS.toString(), "Client not connected: " + this.dataRequester.getServerIP() + ":" + this.dataRequester.getServerPort() + "/" + this.dataRequester.getServerPath() + " ID - " + this.getClientName());
                    this.logNotConnected = false;
                }
                map = this.sendCommandJson("Start", null);
                this.clientContinueRunning = this.processResponse.processCommunicationInformation(map, this.communicationParams);
                if (this.clientContinueRunning == 200) {
                    this.setConnected(true);
                }
                if (this.getConnected()) {
                    this.logger.LogMessageInfo(CLASS.toString(), "Client connected: " + this.dataRequester.getServerIP() + ":" + this.dataRequester.getServerPort() + "/" + this.dataRequester.getServerPath() + " ID - " + this.getClientName());
                }
            } else {
                map = this.sendCommandJson("Update", this.dataSet);
                if (map.size() > 0) {
                    if (this.getDebug()) {
                        this.logger.LogMessageInfo(CLASS.toString(), " Sent Result Decrypt " + map);
                    }
                    this.clientContinueRunning = this.processResponse.processCommunicationInformation(map, this.communicationParams);
                } else if (this.getDebug()) {
                    this.logger.LogMessageInfo(CLASS.toString(), " Sent Result Decryption failed for some reason");
                }
                if (this.getDebug()) {
                    this.logger.LogMessageInfo(CLASS.toString(), "Client " + this.dataRequester.getServerIP() + ":" + this.dataRequester.getServerPort() + "/" + this.dataRequester.getServerPath() + " ID - " + this.getClientName());
                    this.logger.LogMessageInfo(CLASS.toString(), "Communication state response: " + this.clientContinueRunning);
                }
            }
            if (this.clientContinueRunning == 200) {
                this.failCount = 0;
            }
            if (this.clientContinueRunning == 1) {
                this.logger.LogMessageInfo(CLASS.toString(), "Client stopped: " + this.dataRequester.getServerIP() + ":" + this.dataRequester.getServerPort() + "/" + this.dataRequester.getServerPath() + " ID - " + this.getClientName());
                this.quit = true;
            }
            if (this.clientContinueRunning == 2) {
                if (this.getDebug()) {
                    this.logger.LogMessageInfo(CLASS.toString(), "Client asked to register: " + this.dataRequester.getServerIP() + ":" + this.dataRequester.getServerPort() + "/" + this.dataRequester.getServerPath() + " ID - " + this.getClientName());
                }
                this.failCount = 0;
                this.communicationParams.setClientID("");
                this.communicationParams.setClientStatus("");
                this.communicationEncrypter.setKey(this.communicationEncrypter.getInitialKey());
                this.communicationEncrypter.initialiseEncryptor();
                this.dataSet.clear();
                this.setConnected(false);
            }
            if (this.clientContinueRunning == 0) {
                if (this.getDebug()) {
                    this.logger.LogMessageInfo(CLASS.toString(), "Client comms state UNKNOWN");
                }
                ++this.failCount;
                if (this.failCount > 3) {
                    this.failCount = 0;
                    this.communicationParams.setClientID("");
                    this.communicationParams.setClientStatus("");
                    this.communicationEncrypter.setKey(this.communicationEncrypter.getInitialKey());
                    this.communicationEncrypter.initialiseEncryptor();
                    this.setConnected(false);
                }
            }
            if (!this.quit) continue;
            break;
        }
    }

    private Map<String, String> sendCommandJson(String string, Map<String, String> map) {
        HashMap hashMap;
        block4: {
            hashMap = new HashMap();
            try {
                String string2 = this.formatJsonCommand(string, map);
                if (this.debug) {
                    this.logger.LogMessageDebug(CLASS.toString(), "Json message\n" + string2);
                }
                String string3 = this.dataRequester.requestData(string2, this.communicationParams.getClientID(), this.communicationTimeout);
                string3 = this.communicationDecrypter.decryptData(string3);
                System.out.println("sendStartJson result = " + string3);
                hashMap = (HashMap)new ObjectMapper().readValue(string3, (TypeReference)new TypeReference<HashMap<String, String>>(){});
            }
            catch (Exception exception) {
                if (!this.getDebug()) break block4;
                if (exception.toString().toLowerCase().contains("content is not allowed in prolog")) {
                    this.logger.LogMessageDebug(CLASS.toString(), "Communications key and Enc/Dec class check required: ClientName: " + this.clientName + " received response failed to decode.");
                }
                this.logger.LogMessageDebug(CLASS.toString(), "Exception for parsing json response is " + exception);
                exception.printStackTrace(System.err);
            }
        }
        return hashMap;
    }

    @Deprecated(forRemoval=true)
    private Map<String, String> sendCommandXML(String string, Map<String, String> map) {
        block4: {
            try {
                this.communicationXMLParser.resetKeys();
                this.parser = this.parserFactor.newSAXParser();
                String string2 = this.formatXMLCommand(this.clientCommsTranslated, string, map);
                if (this.getDebug()) {
                    this.logger.LogMessageDebug(CLASS.toString(), "XML message\n" + string2);
                }
                String string3 = this.dataRequester.requestData(string2, this.communicationParams.getClientID(), this.communicationTimeout);
                this.parser.parse(new InputSource(new ByteArrayInputStream(this.communicationDecrypter.decryptData(string3).getBytes(StandardCharsets.UTF_8))), this.communicationXMLParser.getDefaultHandler());
            }
            catch (Exception exception) {
                if (!this.getDebug()) break block4;
                if (exception.toString().toLowerCase().contains("content is not allowed in prolog")) {
                    this.logger.LogMessageDebug(CLASS.toString(), "Communications key and Enc/Dec class check required: ClientName: " + this.clientName + " received response failed to decode.");
                }
                this.logger.LogMessageDebug(CLASS.toString(), "Exception for parsing XML response is " + exception);
            }
        }
        return this.communicationXMLParser.getData();
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean bl) {
        this.active = bl;
    }

    @Override
    public String getServerIP() {
        return this.serverIP;
    }

    @Override
    public void setServerIP(String string) {
        this.serverIP = string;
    }

    @Override
    public String getServerPort() {
        return this.serverPort;
    }

    @Override
    public void setServerPort(String string) {
        this.serverPort = string;
    }

    @Override
    public String getServerPath() {
        return this.serverPath;
    }

    @Override
    public void setServerPath(String string) {
        this.serverPath = string;
    }

    @Override
    public String getServerKey() {
        return this.serverKey;
    }

    @Override
    public void setServerKey(String string) {
        this.serverKey = string;
    }

    @Override
    public boolean getDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    @Override
    public boolean getConnected() {
        return this.connected;
    }

    @Override
    public void setConnected(boolean bl) {
        this.connected = bl;
        if (bl) {
            this.logNotConnected = true;
        }
    }

    @Override
    public int getConnectionAttempts() {
        return this.failCount;
    }

    public int mySleep(long l) {
        long l2 = System.currentTimeMillis();
        int n = 0;
        while (true) {
            try {
                Thread.currentThread().wait(l - (long)n);
            }
            catch (Exception exception) {
                // empty catch block
            }
            long l3 = System.currentTimeMillis();
            if (l3 - l2 >= l) {
                return (int)(l3 - l2);
            }
            n = (int)(l - (l3 - l2));
        }
    }

    public String ReturnFileClass(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "UTF-8";
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        try {
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new BufferedInputStream(inputStream), string2);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string3 = "";
            while ((string3 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string3 + "\n");
            }
            bufferedReader.close();
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    public String formatXMLCommand(String string, String string2, Map<String, String> map) {
        string = string.replace("ACTION", string2);
        string = string.replace("IPADDRESS", this.serverIP);
        string = string.replace("NAME", this.communicationParams.getClientName());
        string = string.replace("IDENT", this.communicationParams.getClientID());
        Object object = "\n";
        if (map != null) {
            for (String string3 : map.keySet()) {
                String string4 = map.get(string3);
                object = (String)object + "\t<Attribute>\n\t\t<Name>" + string3 + "</Name>\n\t\t<Value>" + string4 + "</Value>\n\t</Attribute>\n";
            }
        }
        string = string.replace("ATTRIBUTELIST", (CharSequence)object);
        string = this.communicationEncrypter.encryptData(string);
        return string;
    }

    public String formatJsonCommand(String string, Map<String, String> map) throws JsonProcessingException {
        if (map == null) {
            map = new HashMap<String, String>();
        }
        map.put("Client-Command", string);
        map.put("Client-ClientIP", this.serverIP);
        map.put("Client-ClientName", this.communicationParams.getClientName());
        map.put("Client-ClientID", this.communicationParams.getClientID());
        String string2 = new ObjectMapper().writeValueAsString(map);
        String string3 = this.communicationEncrypter.encryptData(string2);
        return string3;
    }
}

