/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.loadbalancer.client;

import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.client.IClient;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.plugin.loadbalancer.client.ILoadBalancerClientDataExtension;
import com.wowza.wms.plugin.loadbalancer.utils.Logger;
import com.wowza.wms.rtp.model.RTPSession;
import com.wowza.wms.server.IServer;
import com.wowza.wms.vhost.IVHost;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LoadBalancerClientExtensionBandwidth
implements ILoadBalancerClientDataExtension {
    public static final String LOADBALANCER_EXTENSION_CLIENT_BANDWIDTH = "loadbalanceClientBandwidth";
    public static final String LOADBALANCER_EXTENSION_BANDWIDTH_LIMIT = "loadbalanceBandwidthLimit";
    public static final String LOADBALANCER_EXTENSION_CLIENT_BANDWIDTH_LIMIT = "loadbalanceClientBandwidthLimit";
    public static final String LOADBALANCER_EXTENSION_COUNT_SOURCE_CLIENT = "loadbalanceCountSourceClient";
    public static final String LOADBALANCER_EXTENSION_CLIENT_BANDWIDTH_SOURCE_CLIENT = "loadbalanceClientBandwidthSourceClient";
    public static final String COMPONENT_NAME = "ClientExtensionBandwidth";
    private static final Class<LoadBalancerClientExtensionBandwidth> CLASS = LoadBalancerClientExtensionBandwidth.class;
    private boolean debug = false;
    private boolean active = false;
    private Logger logger = null;

    @Override
    public void init(WMSProperties wMSProperties, IServer iServer, List<IVHost> list) {
        String string = wMSProperties.getPropertyStr("loadbalanceApplicationsExclude", "");
        String string2 = wMSProperties.getPropertyStr("loadbalanceApplicationsInclude", "");
        string = wMSProperties.getPropertyStr("loadbalanceClientApplicationsExclude", string);
        string2 = wMSProperties.getPropertyStr("loadbalanceClientApplicationsInclude", string2);
        String string3 = wMSProperties.getPropertyStr(LOADBALANCER_EXTENSION_BANDWIDTH_LIMIT, "0");
        string3 = wMSProperties.getPropertyStr(LOADBALANCER_EXTENSION_CLIENT_BANDWIDTH_LIMIT, string3);
        boolean bl = wMSProperties.getPropertyBoolean(LOADBALANCER_EXTENSION_COUNT_SOURCE_CLIENT, false);
        bl = wMSProperties.getPropertyBoolean(LOADBALANCER_EXTENSION_CLIENT_BANDWIDTH_SOURCE_CLIENT, bl);
        if (this.getDebug()) {
            this.logger.LogMessageDebug(CLASS.toString(), "ClientExtensionBandwidth Initializing");
            this.logger.LogMessageDebug(CLASS.toString(), "loadbalanceApplicationsExclude " + (string.length() == 0 ? "Unset" : string));
            this.logger.LogMessageDebug(CLASS.toString(), "loadbalanceApplicationsInclude " + (string2.length() == 0 ? "Unset" : string2));
            this.logger.LogMessageDebug(CLASS.toString(), "loadbalanceClientBandwidthLimit " + string3);
            this.logger.LogMessageDebug(CLASS.toString(), "loadbalanceClientBandwidthSourceClient " + (Serializable)(!bl ? "false" : Boolean.valueOf(bl)));
        }
    }

    @Override
    public boolean getDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean bl) {
        this.active = bl;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public String getComponentName() {
        return COMPONENT_NAME;
    }

    @Override
    public Map<String, String> processClientInformation(WMSProperties wMSProperties, IServer iServer, List<IVHost> list) {
        long l = 0L;
        String string = wMSProperties.getPropertyStr("loadbalanceApplicationsExclude", "");
        String string2 = wMSProperties.getPropertyStr("loadbalanceApplicationsInclude", "");
        string = wMSProperties.getPropertyStr("loadbalanceClientApplicationsExclude", string);
        string2 = wMSProperties.getPropertyStr("loadbalanceClientApplicationsInclude", string2);
        String string3 = wMSProperties.getPropertyStr(LOADBALANCER_EXTENSION_BANDWIDTH_LIMIT, "0");
        string3 = wMSProperties.getPropertyStr(LOADBALANCER_EXTENSION_CLIENT_BANDWIDTH_LIMIT, string3);
        boolean bl = wMSProperties.getPropertyBoolean(LOADBALANCER_EXTENSION_COUNT_SOURCE_CLIENT, false);
        bl = wMSProperties.getPropertyBoolean(LOADBALANCER_EXTENSION_CLIENT_BANDWIDTH_SOURCE_CLIENT, bl);
        for (IVHost object2 : list) {
            if (object2 == null) continue;
            string = object2.getProperties().getPropertyStr("loadbalanceApplicationsExclude", string);
            string2 = object2.getProperties().getPropertyStr("loadbalanceApplicationsInclude", string2);
            string3 = object2.getProperties().getPropertyStr(LOADBALANCER_EXTENSION_BANDWIDTH_LIMIT, string3);
            string3 = object2.getProperties().getPropertyStr(LOADBALANCER_EXTENSION_CLIENT_BANDWIDTH_LIMIT, string3);
            bl = wMSProperties.getPropertyBoolean(LOADBALANCER_EXTENSION_COUNT_SOURCE_CLIENT, bl);
            bl = wMSProperties.getPropertyBoolean(LOADBALANCER_EXTENSION_CLIENT_BANDWIDTH_SOURCE_CLIENT, bl);
            for (String string4 : object2.getApplicationNames()) {
                if (string.length() > 0 && this.mapExactName(string, string4) || string2.length() > 0 && !this.mapExactName(string2, string4)) continue;
                Iterator iterator = object2.getApplication(string4).getAppInstanceNames().iterator();
                while (iterator.hasNext()) {
                    List exception;
                    IApplicationInstance iApplicationInstance = object2.getApplication(string4).getAppInstance((String)iterator.next());
                    List list2 = iApplicationInstance.getClients();
                    Iterator iterator2 = list2.iterator();
                    while (iterator2.hasNext()) {
                        try {
                            exception = (IClient)iterator2.next();
                            if (exception == null || !bl && exception.getIp().equalsIgnoreCase("127.0.0.1")) continue;
                            double d = exception.getMediaIOPerformanceCounter().getMessagesOutBytesRate();
                            d = d * 8.0 / 1000.0;
                            l += (long)d;
                        }
                        catch (Exception exception2) {}
                    }
                    exception = iApplicationInstance.getHTTPStreamerSessions();
                    Iterator d = exception.iterator();
                    while (d.hasNext()) {
                        try {
                            IHTTPStreamerSession iHTTPStreamerSession = (IHTTPStreamerSession)d.next();
                            if (iHTTPStreamerSession == null || !bl && iHTTPStreamerSession.getIpAddress().equalsIgnoreCase("127.0.0.1")) continue;
                            double exception3 = iHTTPStreamerSession.getIOPerformanceCounter().getMessagesOutBytesRate();
                            exception3 = exception3 * 8.0 / 1000.0;
                            l += (long)exception3;
                        }
                        catch (Exception exception4) {}
                    }
                    List d2 = iApplicationInstance.getRTPSessions();
                    Iterator iterator3 = d2.iterator();
                    while (iterator3.hasNext()) {
                        try {
                            RTPSession rTPSession = (RTPSession)iterator3.next();
                            if (rTPSession == null || !bl && rTPSession.getIp().equalsIgnoreCase("127.0.0.1")) continue;
                            double exception5 = rTPSession.getIOPerformanceCounter().getMessagesOutBytesRate();
                            exception5 = exception5 * 8.0 / 1000.0;
                            l += (long)exception5;
                        }
                        catch (Exception exception6) {}
                    }
                }
            }
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.getDebug()) {
            this.logger.LogMessageDebug(CLASS.toString(), "Bandwidth Result " + l);
        }
        hashMap.put(LOADBALANCER_EXTENSION_CLIENT_BANDWIDTH_LIMIT, string3);
        hashMap.put(LOADBALANCER_EXTENSION_CLIENT_BANDWIDTH, String.valueOf(l));
        return hashMap;
    }

    private boolean mapExactName(String string, String string2) {
        try {
            String[] stringArray = string.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equalsIgnoreCase(string2)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

