/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.loadbalancer.client;

import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.plugin.loadbalancer.ReleaseInfo;
import com.wowza.wms.plugin.loadbalancer.client.ILoadBalancerClientDataExtension;
import com.wowza.wms.plugin.loadbalancer.utils.Logger;
import com.wowza.wms.server.IServer;
import com.wowza.wms.vhost.IVHost;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LoadBalancerClientExtensionBaseClientProperties
implements ILoadBalancerClientDataExtension {
    public static final String LOADBALANCER_CLIENT_FORCE_IP = "loadbalanceClientForceIP";
    public static final String LOADBALANCER_CLIENT_FORCE_PORT = "loadbalanceClientForcePort";
    public static final String LOADBALANCER_CLIENT_VERSION = "loadbalanceClientVersion";
    public static final String LOADBALANCER_CLIENT_FORCE_SCHEME = "loadbalanceClientForceScheme";
    private static final Class<LoadBalancerClientExtensionBaseClientProperties> CLASS = LoadBalancerClientExtensionBaseClientProperties.class;
    private final String COMPONENT_NAME = "ClientExtensionBaseClientProperties";
    private boolean debug = false;
    private boolean active = false;
    private Logger logger = null;
    private String forceIP = "";
    private String forcePort = "";
    private String forceScheme = "";

    @Override
    public void init(WMSProperties wMSProperties, IServer iServer, List<IVHost> list) {
        this.forceIP = wMSProperties.getPropertyStr(LOADBALANCER_CLIENT_FORCE_IP, "");
        this.forcePort = wMSProperties.getPropertyStr(LOADBALANCER_CLIENT_FORCE_PORT, "");
        this.forceScheme = wMSProperties.getPropertyStr(LOADBALANCER_CLIENT_FORCE_SCHEME, "");
        Iterator<IVHost> iterator = list.iterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                IVHost iVHost = iterator.next();
                if (iVHost == null) continue;
                this.forceIP = iVHost.getProperties().getPropertyStr(LOADBALANCER_CLIENT_FORCE_IP, this.forceIP);
                this.forcePort = iVHost.getProperties().getPropertyStr(LOADBALANCER_CLIENT_FORCE_PORT, this.forcePort);
                this.forceScheme = iVHost.getProperties().getPropertyStr(LOADBALANCER_CLIENT_FORCE_SCHEME, this.forceScheme);
            }
        }
        if (this.getDebug()) {
            this.logger.LogMessageDebug(CLASS.toString(), "ClientExtensionBaseClientProperties Initializing");
            this.logger.LogMessageDebug(CLASS.toString(), "loadbalanceClientForceIP " + (this.forceIP.length() == 0 ? "Unset" : this.forceIP));
            this.logger.LogMessageDebug(CLASS.toString(), "loadbalanceClientForcePort " + (this.forcePort.length() == 0 ? "Unset" : this.forcePort));
            this.logger.LogMessageDebug(CLASS.toString(), "loadbalanceClientForceScheme " + (this.forceScheme.length() == 0 ? "Unset" : this.forceScheme));
        }
    }

    @Override
    public boolean getDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean bl) {
        this.active = bl;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public String getComponentName() {
        return "ClientExtensionBaseClientProperties";
    }

    @Override
    public Map<String, String> processClientInformation(WMSProperties wMSProperties, IServer iServer, List<IVHost> list) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.forceIP.length() > 0) {
            hashMap.put(LOADBALANCER_CLIENT_FORCE_IP, this.forceIP);
        }
        if (this.forcePort.length() > 0) {
            hashMap.put(LOADBALANCER_CLIENT_FORCE_PORT, this.forcePort);
        }
        if (this.forceScheme.length() > 0) {
            hashMap.put(LOADBALANCER_CLIENT_FORCE_SCHEME, this.forceScheme);
        }
        hashMap.put(LOADBALANCER_CLIENT_VERSION, String.valueOf(ReleaseInfo.getBuildNumber()));
        return hashMap;
    }
}

