/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.loadbalancer.client;

import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.plugin.loadbalancer.client.ILoadBalancerClientDataExtension;
import com.wowza.wms.plugin.loadbalancer.utils.Logger;
import com.wowza.wms.server.IServer;
import com.wowza.wms.vhost.IVHost;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LoadBalancerClientExtensionMaxMindGeoIP2City
implements ILoadBalancerClientDataExtension {
    public static final String LOADBALANCER_EXTENSION_CITY_LIST = "loadbalanceGeoIP2CityList";
    public static final String LOADBALANCER_EXTENSION_CLIENT_CITY_LIST = "loadbalanceClientGeoIP2CityList";
    public static final String COMPONENT_NAME = "ClientExtensionGeoIP2City";
    private static final Class<LoadBalancerClientExtensionMaxMindGeoIP2City> CLASS = LoadBalancerClientExtensionMaxMindGeoIP2City.class;
    private boolean debug = false;
    private boolean active = false;
    private Logger logger = null;
    private String cityProperty = "";

    @Override
    public void init(WMSProperties wMSProperties, IServer iServer, List<IVHost> list) {
        this.cityProperty = wMSProperties.getPropertyStr(LOADBALANCER_EXTENSION_CITY_LIST, "");
        this.cityProperty = wMSProperties.getPropertyStr(LOADBALANCER_EXTENSION_CLIENT_CITY_LIST, this.cityProperty);
        for (IVHost iVHost : list) {
            if (iVHost == null) continue;
            this.cityProperty = wMSProperties.getPropertyStr(LOADBALANCER_EXTENSION_CITY_LIST, "");
            this.cityProperty = wMSProperties.getPropertyStr(LOADBALANCER_EXTENSION_CLIENT_CITY_LIST, this.cityProperty);
        }
        if (this.getDebug()) {
            this.logger.LogMessageDebug(CLASS.toString(), "ClientExtensionGeoIP2City Initializing");
            this.logger.LogMessageDebug(CLASS.toString(), "loadbalanceClientGeoIP2CityList " + this.cityProperty);
        }
    }

    @Override
    public boolean getDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean bl) {
        this.active = bl;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public String getComponentName() {
        return COMPONENT_NAME;
    }

    @Override
    public Map<String, String> processClientInformation(WMSProperties wMSProperties, IServer iServer, List<IVHost> list) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.cityProperty.length() > 0) {
            hashMap.put(LOADBALANCER_EXTENSION_CLIENT_CITY_LIST, this.cityProperty);
        }
        return hashMap;
    }
}

