/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.loadbalancer.client;

import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.plugin.loadbalancer.client.ILoadBalancerClientDataExtension;
import com.wowza.wms.plugin.loadbalancer.utils.Logger;
import com.wowza.wms.server.IServer;
import com.wowza.wms.vhost.IVHost;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LoadBalancerClientExtensionMaxMindGeoIP2Country
implements ILoadBalancerClientDataExtension {
    public static final String LOADBALANCER_EXTENSION_COUNTRY_LIST = "loadbalanceGeoIP2CountryList";
    public static final String LOADBALANCER_EXTENSION_CLIENT_COUNTRY_LIST = "loadbalanceClientGeoIP2CountryList";
    public static final String COMPONENT_NAME = "ClientExtensionGeoIP2Country";
    private static final Class<LoadBalancerClientExtensionMaxMindGeoIP2Country> CLASS = LoadBalancerClientExtensionMaxMindGeoIP2Country.class;
    private boolean debug = false;
    private boolean active = false;
    private Logger logger = null;
    private String countryProperty = "";

    @Override
    public void init(WMSProperties wMSProperties, IServer iServer, List<IVHost> list) {
        this.countryProperty = wMSProperties.getPropertyStr(LOADBALANCER_EXTENSION_COUNTRY_LIST, "");
        this.countryProperty = wMSProperties.getPropertyStr(LOADBALANCER_EXTENSION_CLIENT_COUNTRY_LIST, this.countryProperty);
        for (IVHost iVHost : list) {
            if (iVHost == null) continue;
            this.countryProperty = wMSProperties.getPropertyStr(LOADBALANCER_EXTENSION_COUNTRY_LIST, "");
            this.countryProperty = wMSProperties.getPropertyStr(LOADBALANCER_EXTENSION_CLIENT_COUNTRY_LIST, this.countryProperty);
        }
        if (this.getDebug()) {
            this.logger.LogMessageDebug(CLASS.toString(), "ClientExtensionGeoIP2Country Initializing");
            this.logger.LogMessageDebug(CLASS.toString(), "loadbalanceClientGeoIP2CountryList " + this.countryProperty);
        }
    }

    @Override
    public boolean getDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean bl) {
        this.active = bl;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public String getComponentName() {
        return COMPONENT_NAME;
    }

    @Override
    public Map<String, String> processClientInformation(WMSProperties wMSProperties, IServer iServer, List<IVHost> list) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.countryProperty.length() > 0) {
            hashMap.put(LOADBALANCER_EXTENSION_CLIENT_COUNTRY_LIST, this.countryProperty);
        }
        return hashMap;
    }
}

