/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.loadbalancer.http;

import com.wowza.wms.http.IHTTPRequest;
import com.wowza.wms.http.IHTTPResponse;
import com.wowza.wms.plugin.loadbalancer.http.ILoadBalancerHTTPExtension;
import com.wowza.wms.plugin.loadbalancer.http.LoadBalancerHTTPProvider;
import com.wowza.wms.plugin.loadbalancer.server.ILoadBalancerServer;
import com.wowza.wms.plugin.loadbalancer.server.ILoadBalancerServerClient;
import com.wowza.wms.plugin.loadbalancer.utils.Logger;
import com.wowza.wms.vhost.IVHost;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LoadBalancerHTTPF4M
implements ILoadBalancerHTTPExtension {
    private static final Class<LoadBalancerHTTPF4M> CLASS = LoadBalancerHTTPF4M.class;
    private final String COMPONENT_NAME = "F4M";
    private boolean debug = false;
    private boolean active = true;
    private Logger logger = null;

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public boolean getDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean bl) {
        this.active = bl;
    }

    @Override
    public String getComponentName() {
        return "F4M";
    }

    @Override
    public String processHTTPRequest(IVHost iVHost, IHTTPRequest iHTTPRequest, IHTTPResponse iHTTPResponse, String string, ILoadBalancerServer iLoadBalancerServer) {
        Map map = iHTTPRequest.getParameterMap();
        String string2 = iHTTPRequest.getRemoteAddr();
        String string3 = iHTTPRequest.getQueryString();
        if (map.containsKey("IP")) {
            try {
                string2 = (String)((List)map.get("IP")).get(0);
            }
            catch (Exception exception) {
                string2 = "INVALID";
            }
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("ClientIP", string2);
        hashMap.put("ClientStream", string);
        hashMap.put("ClientQueryString", string3);
        hashMap.put("ClientScheme", iHTTPRequest.isSecure() ? "true" : "false");
        hashMap.put("ClientPort", String.valueOf(iHTTPRequest.getServerPort()));
        ILoadBalancerServerClient iLoadBalancerServerClient = iLoadBalancerServer.processServerDataExtensions(hashMap);
        string3 = LoadBalancerHTTPProvider.removeKnownParameters(string3);
        if (iLoadBalancerServerClient != null) {
            String string4 = iLoadBalancerServerClient.getScheme() + "://" + iLoadBalancerServerClient.getClientHost() + string + "/manifest.f4m" + string3;
            if (this.getDebug()) {
                this.logger.LogMessageDebug(CLASS.getName(), "Redirection URL is: " + string4);
            }
            iHTTPResponse.setHeader("Location", string4);
            iHTTPResponse.setResponseCode(302);
            this.incrementConnectionCount(iLoadBalancerServerClient);
        } else if (this.getDebug()) {
            this.logger.LogMessageDebug(CLASS.getName(), "Client is null " + iLoadBalancerServerClient);
        }
        return null;
    }
}

