/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.loadbalancer.http;

import com.wowza.wms.http.IHTTPRequest;
import com.wowza.wms.http.IHTTPResponse;
import com.wowza.wms.plugin.loadbalancer.ReleaseInfo;
import com.wowza.wms.plugin.loadbalancer.http.ILoadBalancerHTTPExtension;
import com.wowza.wms.plugin.loadbalancer.http.LoadBalancerHTTPProvider;
import com.wowza.wms.plugin.loadbalancer.server.ILoadBalancerServer;
import com.wowza.wms.plugin.loadbalancer.server.ILoadBalancerServerClient;
import com.wowza.wms.plugin.loadbalancer.utils.Logger;
import com.wowza.wms.vhost.IVHost;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LoadBalancerHTTPXML
implements ILoadBalancerHTTPExtension {
    private static final Class<LoadBalancerHTTPXML> CLASS = LoadBalancerHTTPXML.class;
    private final String COMPONENT_NAME = "XML";
    private boolean debug = false;
    private boolean active = true;
    private Logger logger = null;

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public boolean getDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean bl) {
        this.active = bl;
    }

    @Override
    public String getComponentName() {
        return "XML";
    }

    @Override
    public String processHTTPRequest(IVHost iVHost, IHTTPRequest iHTTPRequest, IHTTPResponse iHTTPResponse, String string, ILoadBalancerServer iLoadBalancerServer) {
        Map map = iHTTPRequest.getParameterMap();
        String string2 = iHTTPRequest.getRemoteAddr();
        String string3 = iHTTPRequest.getQueryString();
        Object object = "";
        if (map.containsKey("IP")) {
            try {
                string2 = (String)((List)map.get("IP")).get(0);
            }
            catch (Exception exception) {
                string2 = "INVALID";
            }
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("ClientIP", string2);
        hashMap.put("ClientStream", string);
        hashMap.put("ClientQueryString", string3);
        hashMap.put("ClientScheme", iHTTPRequest.isSecure() ? "true" : "false");
        hashMap.put("ClientPort", String.valueOf(iHTTPRequest.getServerPort()));
        ILoadBalancerServerClient iLoadBalancerServerClient = iLoadBalancerServer.processServerDataExtensions(hashMap);
        string3 = LoadBalancerHTTPProvider.removeKnownParameters(string3);
        iHTTPResponse.setHeader("Content-Type", "text/xml");
        object = (String)object + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        object = (String)object + "<loadbalance>\n";
        object = (String)object + "\t<server>\n";
        object = (String)object + "\t\t<version>" + ReleaseInfo.getVersion() + "</version>\n";
        object = (String)object + "\t\t<build>" + ReleaseInfo.getBuildNumber() + "</build>\n";
        object = (String)object + "\t</server>\n";
        if (iLoadBalancerServerClient != null) {
            object = (String)object + "\t<client>\n";
            object = (String)object + "\t\t<scheme>" + iLoadBalancerServerClient.getScheme() + "</scheme>\n";
            object = (String)object + "\t\t<host>" + iLoadBalancerServerClient.getClientHost() + "</host>\n";
            object = (String)object + "\t\t<queryString>" + string3 + "</queryString>\n";
            object = (String)object + "\t\t<clientIP>" + string2 + "</clientIP>\n";
            object = (String)object + "\t\t<assetPath>" + string + "</assetPath>\n";
            object = (String)object + "\t</client>\n";
            if (this.getDebug()) {
                this.logger.LogMessageDebug(CLASS.getName(), "Redirection URL is: " + (String)object);
            }
            this.incrementConnectionCount(iLoadBalancerServerClient);
        }
        object = (String)object + "</loadbalance>\n";
        return object;
    }
}

