/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.loadbalancer.listeners;

import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.plugin.loadbalancer.ReleaseInfo;
import com.wowza.wms.plugin.loadbalancer.client.ILoadBalancerClient;
import com.wowza.wms.plugin.loadbalancer.client.LoadBalancerClient;
import com.wowza.wms.plugin.loadbalancer.server.ILoadBalancerServer;
import com.wowza.wms.plugin.loadbalancer.server.LoadBalancerServer;
import com.wowza.wms.plugin.loadbalancer.server.LoadBalancerServerVHostSetup;
import com.wowza.wms.plugin.loadbalancer.utils.Logger;
import com.wowza.wms.server.Server;
import com.wowza.wms.vhost.IVHost;
import java.util.stream.Stream;

public class VHostListener
extends LoadBalancerServerVHostSetup {
    private static final Class<VHostListener> CLASS = VHostListener.class;
    private ILoadBalancerClient client = null;
    private ILoadBalancerServer server = null;
    private Logger logger = null;
    private String loadBalancerType = "";
    private String decisionOrder = "None Yet";
    private String serverKey = "";
    private String authenticationMethod = "admin-basic";

    public void onVHostCreate(IVHost iVHost) {
        this.configVHostName = iVHost.getName();
        WMSProperties wMSProperties = iVHost.getProperties();
        this.debug = wMSProperties.getPropertyBoolean("loadbalanceDebug", this.debug);
        this.debug = wMSProperties.getPropertyBoolean("loadbalanceDebugClientCommunications", this.debug);
        this.authenticationMethod = wMSProperties.getPropertyStr("loadBalanceAdminAuthenticationMethod", this.authenticationMethod);
        boolean bl = wMSProperties.getPropertyBoolean("loadBalanceUseEncryptedAdminPassword", false);
        if (bl && this.authenticationMethod.equals("admin-digest")) {
            this.authenticationMethod = "admin-file-digest";
        }
        this.commsIp = wMSProperties.getPropertyStr("loadbalanceServerIP", this.commsIp);
        this.commsPort = wMSProperties.getPropertyStr("loadbalanceServerPort", this.commsPort);
        this.commsPath = wMSProperties.getPropertyStr("loadbalanceServerPath", this.commsPath);
        this.redirectIp = wMSProperties.getPropertyStr("loadbalanceServerRedirectIP", this.redirectIp);
        this.redirectPort = wMSProperties.getPropertyStr("loadbalanceServerRedirectPort", this.redirectPort);
        this.redirectPath = wMSProperties.getPropertyStr("loadbalanceServerRedirectPath", this.redirectPath);
        this.infoIp = wMSProperties.getPropertyStr("loadbalanceServerInfoIP", this.infoIp);
        this.infoPort = wMSProperties.getPropertyStr("loadbalanceServerInfoPort", this.infoPort);
        this.infoPath = wMSProperties.getPropertyStr("loadbalanceServerInfoPath", this.infoPath);
        this.appNames = wMSProperties.getPropertyStr("loadbalanceServerListenApplicationNames", this.appNames);
        this.loadBalancerType = wMSProperties.getPropertyStr("loadbalanceServerType", this.loadBalancerType);
        this.debugHTTPExtensions = wMSProperties.getPropertyBoolean("loadbalanceDebugHTTPExtensions", this.debugHTTPExtensions);
        this.decisionOrder = wMSProperties.getPropertyStr("loadbalanceServerDecisionOrder", this.decisionOrder);
        this.serverKey = wMSProperties.getPropertyStr("loadbalanceKey", this.serverKey);
        if (this.logger == null) {
            this.logger = new Logger(WMSLoggerFactory.getLogger(CLASS));
        }
    }

    @Override
    public void onVHostInit(IVHost iVHost) {
        this.logger.LogMessageInfo(CLASS.toString(), "onVHostInit() Version: " + ReleaseInfo.getVersion() + " Build " + ReleaseInfo.getBuildNumber() + " Start");
        this.logger.LogMessageInfo(CLASS.toString(), "onVHostInit() Type is '" + this.loadBalancerType + "'");
        if (Stream.of("Client", "Server").noneMatch(this.loadBalancerType::contains)) {
            this.logger.LogMessageInfo(CLASS.toString(), "onVHostInit() No Type Defined, not starting");
        }
        if (this.serverKey.length() != 16) {
            this.logger.LogMessageInfo(CLASS.toString(), "onVHostInit() loadbalanceKey incorrect length, loadbalancer not starting");
            return;
        }
        if (this.loadBalancerType.contains("Client")) {
            this.client = new LoadBalancerClient();
            this.client.setLogger(this.logger);
            this.client.init(Server.getInstance().getProperties(), null, iVHost);
            this.client.setDebug(this.debug);
            ((Thread)((Object)this.client)).setDaemon(true);
            ((Thread)((Object)this.client)).start();
        }
        if (this.loadBalancerType.contains("Server")) {
            this.logger.LogMessageInfo(CLASS.toString(), "onVHostInit() Decisions set '" + this.decisionOrder + "'");
            this.logger.LogMessageInfo(CLASS.toString(), "onVHostInit() ApplicationNames for redirection: " + this.appNames);
            this.server = new LoadBalancerServer();
            this.server.setLogger(this.logger);
            this.server.init(Server.getInstance().getProperties(), iVHost);
            this.server.setDebug(this.debug);
            ((Thread)((Object)this.server)).setDaemon(true);
            ((Thread)((Object)this.server)).start();
            super.onVHostInit(iVHost);
        }
    }
}

