/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.loadbalancer.server;

import com.wowza.util.HTTPUtils;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.http.IHTTPRequest;
import com.wowza.wms.plugin.loadbalancer.server.ILoadBalancerServer;
import com.wowza.wms.plugin.loadbalancer.server.ILoadBalancerServerClient;
import com.wowza.wms.plugin.loadbalancer.server.ILoadBalancerServerCommunication;
import com.wowza.wms.plugin.loadbalancer.server.ILoadBalancerServerDataExtension;
import com.wowza.wms.plugin.loadbalancer.server.ILoadBalancerServerProcessResponse;
import com.wowza.wms.plugin.loadbalancer.server.LoadBalancerServerClient;
import com.wowza.wms.plugin.loadbalancer.utils.Logger;
import com.wowza.wms.vhost.IVHost;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LoadBalancerServer
extends Thread
implements ILoadBalancerServer {
    private static final Class<LoadBalancerServer> CLASS = LoadBalancerServer.class;
    private final HashMap<String, ILoadBalancerServerClient> loadBalancerClients = new HashMap();
    private final Map<String, ILoadBalancerServerDataExtension> serverDataExtensions = new HashMap<String, ILoadBalancerServerDataExtension>();
    private final ArrayList<String> loadServerExtensions = new ArrayList();
    private final Object lock = new Object();
    private boolean debug = false;
    private boolean active = true;
    private boolean debugExtensions = false;
    private boolean debugServerProcess = false;
    private boolean debugServerDecision = false;
    private boolean returnLastClient = false;
    private String decisionOrder = "None Set";
    private String serverKey = "";
    private IVHost vHost = null;
    private WMSProperties serverProps = null;
    private Logger logger = null;
    private ILoadBalancerServerCommunication serverComms = null;
    private String serverCommunicationClass = "com.wowza.wms.plugin.loadbalancer.server.LoadBalancerServerCommunication";
    private String xmlServerParserClass = "com.wowza.wms.plugin.loadbalancer.server.LoadBalancerServerXMLParser";
    private String serverProcessResponseClass = "com.wowza.wms.plugin.loadbalancer.server.LoadBalancerServerProcessResponse";
    private String serverExtensionClasses = "com.wowza.wms.plugin.loadbalancer.server.LoadBalancerServerExtensionConnectionCounts|com.wowza.wms.plugin.loadbalancer.server.LoadBalancerServerExtensionBandwidth|com.wowza.wms.plugin.loadbalancer.server.LoadBalancerServerExtensionMaxMind|com.wowza.wms.plugin.loadbalancer.server.LoadBalancerServerExtensionPublishedStream|com.wowza.wms.plugin.loadbalancer.server.LoadBalancerServerExtensionMaxMindGeoIP2Country|com.wowza.wms.plugin.loadbalancer.server.LoadBalancerServerExtensionMaxMindGeoIP2City|com.wowza.wms.plugin.loadbalancer.server.LoadBalancerServerExtensionPrivateAddressMap";
    private String decryptorClass = "com.wowza.wms.plugin.loadbalancer.encryption.LoadBalancerDecrypt";
    private String encryptorClass = "com.wowza.wms.plugin.loadbalancer.encryption.LoadBalancerEncrypt";
    private ILoadBalancerServerProcessResponse processResponse = null;
    private List<String> decisionList = new ArrayList<String>();
    private long serverClientTimeout = 30000L;

    @Override
    public String getServerKey() {
        return this.serverKey;
    }

    @Override
    public void setServerKey(String string) {
        this.serverKey = string;
    }

    @Override
    public String getServerXMLParserClass() {
        return this.xmlServerParserClass;
    }

    @Override
    public void setServerXMLParserClass(String string) {
        this.xmlServerParserClass = string;
    }

    @Override
    public String getServerProcessResponseClass() {
        return this.serverProcessResponseClass;
    }

    @Override
    public void setServerProcessResponseClass(String string) {
        this.serverProcessResponseClass = string;
    }

    @Override
    public String getCommunicationClass() {
        return this.serverCommunicationClass;
    }

    @Override
    public void setCommunicationClass(String string) {
        this.serverCommunicationClass = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap<String, ILoadBalancerServerClient> getClients(boolean bl) {
        HashMap<String, ILoadBalancerServerClient> hashMap = new HashMap<String, ILoadBalancerServerClient>();
        HashMap<String, ILoadBalancerServerClient> hashMap2 = this.loadBalancerClients;
        synchronized (hashMap2) {
            for (String string : this.loadBalancerClients.keySet()) {
                if (!this.loadBalancerClients.get(string).getState().equalsIgnoreCase("ok") && !bl) continue;
                hashMap.put(string, this.loadBalancerClients.get(string));
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, ILoadBalancerServerClient> getClientsCopy(boolean bl) {
        HashMap<String, ILoadBalancerServerClient> hashMap = new HashMap<String, ILoadBalancerServerClient>();
        HashMap<String, ILoadBalancerServerClient> hashMap2 = this.loadBalancerClients;
        synchronized (hashMap2) {
            for (String string : this.loadBalancerClients.keySet()) {
                if (!this.loadBalancerClients.get(string).getState().equalsIgnoreCase("ok") && !bl) continue;
                LoadBalancerServerClient loadBalancerServerClient = new LoadBalancerServerClient();
                loadBalancerServerClient.copyServerClient(this.loadBalancerClients.get(string));
                hashMap.put(string, loadBalancerServerClient);
            }
        }
        return hashMap;
    }

    @Override
    public boolean getDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean bl) {
        this.active = bl;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(WMSProperties wMSProperties, IVHost iVHost) {
        Object object;
        Serializable serializable;
        this.vHost = iVHost;
        this.serverProps = wMSProperties;
        String string = "";
        String string2 = "";
        string = this.serverProps.getPropertyStr("loadbalanceServerProcessClasses", "");
        string2 = this.serverProps.getPropertyStr("loadbalanceServerProcessAddClasses", "");
        this.debugExtensions = this.serverProps.getPropertyBoolean("loadbalanceDebugServerExtension", this.debugExtensions);
        this.debugServerProcess = this.serverProps.getPropertyBoolean("loadbalanceDebugServerProcess", this.debugServerProcess);
        this.debugServerDecision = this.serverProps.getPropertyBoolean("loadbalanceDebugServerDecision", this.debugServerDecision);
        this.decryptorClass = this.serverProps.getPropertyStr("loadbalanceDecryptorClass", this.decryptorClass);
        this.encryptorClass = this.serverProps.getPropertyStr("loadbalanceEncryptorClass", this.encryptorClass);
        this.serverCommunicationClass = this.serverProps.getPropertyStr("loadbalanceServerCommunicationClass", this.serverCommunicationClass);
        this.serverProcessResponseClass = this.serverProps.getPropertyStr("loadbalanceServerProcessResponseClass", this.serverProcessResponseClass);
        this.xmlServerParserClass = this.serverProps.getPropertyStr("loadbalanceServerXMLParserClass", this.xmlServerParserClass);
        this.decisionOrder = this.serverProps.getPropertyStr("loadbalanceServerDecisionOrder", this.decisionOrder);
        this.serverKey = this.serverProps.getPropertyStr("loadbalanceKey", this.serverKey);
        this.serverClientTimeout = this.serverProps.getPropertyLong("loadbalanceServerClientTimeout", this.serverClientTimeout);
        this.returnLastClient = this.serverProps.getPropertyBoolean("loadbalanceReturnLastClient", this.returnLastClient);
        if (this.vHost != null) {
            string = this.vHost.getProperties().getPropertyStr("loadbalanceServerProcessClasses", string);
            string2 = this.vHost.getProperties().getPropertyStr("loadbalanceServerProcessAddClasses", string2);
            this.serverCommunicationClass = this.vHost.getProperties().getPropertyStr("loadbalanceServerCommunicationClass", this.serverCommunicationClass);
            this.decryptorClass = this.vHost.getProperties().getPropertyStr("loadbalanceDecryptorClass", this.decryptorClass);
            this.encryptorClass = this.vHost.getProperties().getPropertyStr("loadbalanceEncryptorClass", this.encryptorClass);
            this.decisionOrder = this.vHost.getProperties().getPropertyStr("loadbalanceServerDecisionOrder", this.decisionOrder);
            this.serverKey = this.vHost.getProperties().getPropertyStr("loadbalanceKey", this.serverKey);
            this.serverClientTimeout = this.vHost.getProperties().getPropertyLong("loadbalanceServerClientTimeout", this.serverClientTimeout);
            this.debugExtensions = this.vHost.getProperties().getPropertyBoolean("loadbalanceDebugServerExtension", this.debugExtensions);
            this.debugServerProcess = this.vHost.getProperties().getPropertyBoolean("loadbalanceDebugServerProcess", this.debugServerProcess);
            this.debugServerDecision = this.vHost.getProperties().getPropertyBoolean("loadbalanceDebugServerDecision", this.debugServerDecision);
        }
        if (this.serverKey.contains(",")) {
            this.serverKey = this.serverKey.split(",")[0];
        }
        if (this.serverKey.length() != 16) {
            this.logger.LogMessageInfo(CLASS.getName(), "Server startup failed: Encryption key too short, must be 16 characters.");
            this.active = false;
        }
        if (string != null && string.length() > 0) {
            this.serverExtensionClasses = string;
        }
        if (string2.length() > 0) {
            if (!this.serverExtensionClasses.endsWith("|")) {
                this.serverExtensionClasses = this.serverExtensionClasses + "|";
            }
            this.serverExtensionClasses = this.serverExtensionClasses + string2;
        }
        Map map = HTTPUtils.expandHTTPHeadersStr((String)this.serverExtensionClasses);
        for (Iterator<String> iterator : map.keySet()) {
            this.loadServerExtensions.add((String)((Object)iterator));
        }
        if (string != null) {
            Iterator<String> iterator;
            iterator = HTTPUtils.expandHTTPHeadersStr((String)string);
            Iterator object22 = iterator.keySet().iterator();
            while (object22.hasNext()) {
                serializable = this.loadServerExtensions;
                synchronized (serializable) {
                    object = (String)object22.next();
                    this.loadServerExtensions.add((String)object);
                }
            }
        }
        for (String exception : this.loadServerExtensions) {
            if (exception.length() == 0) continue;
            try {
                serializable = Class.forName(exception);
                object = (ILoadBalancerServerDataExtension)((Class)serializable).newInstance();
                if (object != null) {
                    if (this.getDebug()) {
                        this.logger.LogMessageInfo(CLASS.getName(), "Extension is '" + object.getClass() + "' debug is '" + this.debugServerDecision + "'");
                    }
                    object.setDebug(this.debugServerDecision);
                    object.setLogger(this.logger);
                    object.init(wMSProperties);
                    this.addServerDataExtension((ILoadBalancerServerDataExtension)object);
                    continue;
                }
                this.logger.LogMessageInfo(CLASS.getName(), "Class not found: " + exception);
            }
            catch (Exception exception2) {
                this.logger.LogMessageInfo(CLASS.getName(), "Class failed to load correctly: " + exception + " Exception: " + exception2);
            }
        }
        try {
            Class<?> exception = Class.forName(this.getCommunicationClass());
            this.serverComms = (ILoadBalancerServerCommunication)exception.newInstance();
        }
        catch (Exception exception) {
            this.active = false;
            this.logger.LogMessageInfo(CLASS.getName(), "Server Comms class " + this.getCommunicationClass() + " not found");
        }
        try {
            Class<?> clazz = Class.forName(this.getServerProcessResponseClass());
            this.processResponse = (ILoadBalancerServerProcessResponse)clazz.newInstance();
            if (this.processResponse != null) {
                this.processResponse.setDebug(this.debugServerProcess);
                this.processResponse.setLogger(this.logger);
            }
        }
        catch (Exception exception) {
            this.active = false;
            this.logger.LogMessageInfo(CLASS.getName(), "Server Comms class " + this.getServerProcessResponseClass() + " not found");
        }
        if (this.active) {
            this.setServerKey(this.serverKey);
            this.serverComms.setServerKey(this.getServerKey());
            this.serverComms.setDecrytorClass(this.decryptorClass);
            this.serverComms.setEncrytorClass(this.encryptorClass);
            this.serverComms.setXMLParserClass(this.xmlServerParserClass);
            this.serverComms.setLogger(this.logger);
            this.serverComms.init();
            try {
                String[] stringArray = this.decisionOrder.split(",");
                for (int i = 0; i < stringArray.length; ++i) {
                    object = stringArray[i];
                    object = ((String)object).replaceAll("\\s+", "");
                    object = ((String)object).toLowerCase();
                    this.addServerDecision((String)object);
                }
            }
            catch (Exception exception) {
                this.active = false;
            }
        }
        if (this.getDebug()) {
            this.logger.LogMessageInfo(CLASS.getName(), "serverCommunicationClass: " + this.serverCommunicationClass);
            this.logger.LogMessageInfo(CLASS.getName(), "          decryptorClass: " + this.decryptorClass);
            this.logger.LogMessageInfo(CLASS.getName(), "          encryptorClass: " + this.encryptorClass);
            this.logger.LogMessageInfo(CLASS.getName(), "           decisionOrder: " + this.decisionOrder);
            this.logger.LogMessageInfo(CLASS.getName(), "               serverKey: " + this.serverKey);
            this.logger.LogMessageInfo(CLASS.getName(), "     serverClientTimeout: " + this.serverClientTimeout + " ms");
            this.logger.LogMessageInfo(CLASS.getName(), "         debugExtensions: " + this.debugExtensions);
            this.logger.LogMessageInfo(CLASS.getName(), "      debugServerProcess: " + this.debugServerProcess);
            this.logger.LogMessageInfo(CLASS.getName(), "     debugServerDecision: " + this.debugServerDecision);
            this.logger.LogMessageInfo(CLASS.getName(), "                  active: " + this.active);
        }
    }

    @Override
    public ILoadBalancerServerCommunication getServerCommunication() {
        return this.serverComms;
    }

    @Override
    public boolean getStatus() {
        return this.active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.getStatus()) {
            Object object = this;
            synchronized (object) {
                try {
                    this.mySleep(2000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            object = this.serverDataExtensions;
            synchronized (object) {
                for (String string : this.serverDataExtensions.keySet()) {
                    ILoadBalancerServerDataExtension iLoadBalancerServerDataExtension = this.serverDataExtensions.get(string);
                    iLoadBalancerServerDataExtension.updateComponent(null);
                }
            }
            this.checkTimeoutClients();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkTimeoutClients() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.lock;
        synchronized (iterator) {
            for (String object2 : this.loadBalancerClients.keySet()) {
                ILoadBalancerServerClient iLoadBalancerServerClient = this.loadBalancerClients.get(object2);
                if (System.currentTimeMillis() / 1000L - this.serverClientTimeout / 1000L / 2L > iLoadBalancerServerClient.getLastUpdate()) {
                    iLoadBalancerServerClient.setState("WAITING");
                }
                if (System.currentTimeMillis() / 1000L - this.serverClientTimeout / 1000L <= iLoadBalancerServerClient.getLastUpdate()) continue;
                arrayList.add(object2);
                iLoadBalancerServerClient.setState("EXPIRED");
            }
        }
        if (arrayList.size() > 0) {
            for (Object object : arrayList) {
                ILoadBalancerServerClient iLoadBalancerServerClient = this.removeClient((String)object);
                if (iLoadBalancerServerClient != null) {
                    this.logger.LogMessageInfo(CLASS.getName(), "Remove client: Expire Timeout: " + iLoadBalancerServerClient.getAttribute("Client-ClientName"));
                    continue;
                }
                this.logger.LogMessageInfo(CLASS.getName(), "Remove client: Failed to find client: " + (String)object + " to remove");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addClient(ILoadBalancerServerClient iLoadBalancerServerClient) {
        boolean bl = false;
        Object object = this.lock;
        synchronized (object) {
            this.loadBalancerClients.remove(iLoadBalancerServerClient.getClientID());
            this.loadBalancerClients.put(iLoadBalancerServerClient.getClientID(), iLoadBalancerServerClient);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ILoadBalancerServerClient removeClient(String string) {
        Object object = this.lock;
        synchronized (object) {
            if (this.loadBalancerClients.containsKey(string)) {
                return this.loadBalancerClients.remove(string);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ILoadBalancerServerClient removeClient(ILoadBalancerServerClient iLoadBalancerServerClient) {
        Object object = this.lock;
        synchronized (object) {
            if (this.loadBalancerClients.containsKey(iLoadBalancerServerClient.getClientID())) {
                return this.loadBalancerClients.remove(iLoadBalancerServerClient.getClientID());
            }
        }
        return null;
    }

    public int mySleep(long l) {
        long l2 = System.currentTimeMillis();
        int n = 0;
        while (true) {
            try {
                Thread.currentThread().wait(l - (long)n);
            }
            catch (Exception exception) {
                // empty catch block
            }
            long l3 = System.currentTimeMillis();
            if (l3 - l2 >= l) {
                return (int)(l3 - l2);
            }
            n = (int)(l - (l3 - l2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addServerDataExtension(ILoadBalancerServerDataExtension iLoadBalancerServerDataExtension) {
        Map<String, ILoadBalancerServerDataExtension> map = this.serverDataExtensions;
        synchronized (map) {
            String string = iLoadBalancerServerDataExtension.getComponentName().toLowerCase();
            iLoadBalancerServerDataExtension.setActive(true);
            this.serverDataExtensions.put(string, iLoadBalancerServerDataExtension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServerDataExtension(String string) {
        Map<String, ILoadBalancerServerDataExtension> map = this.serverDataExtensions;
        synchronized (map) {
            for (String string2 : this.serverDataExtensions.keySet()) {
                if (!string2.equalsIgnoreCase(string)) continue;
                this.serverDataExtensions.remove(string2);
            }
        }
    }

    @Override
    public ILoadBalancerServerDataExtension getServerDataExtension(String string) {
        Iterator<String> iterator = this.serverDataExtensions.keySet().iterator();
        if (this.getDebug()) {
            while (iterator.hasNext()) {
                String string2 = iterator.next();
                this.logger.LogMessageDebug(CLASS.getName(), "Debug Extenion search: " + string2);
            }
        }
        if (this.serverDataExtensions.containsKey(string)) {
            return this.serverDataExtensions.get(string);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getServerDataExtensionNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Map<String, ILoadBalancerServerDataExtension> map = this.serverDataExtensions;
        synchronized (map) {
            Iterator<String> iterator = this.serverDataExtensions.keySet().iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addServerDecision(String string) {
        List<String> list = this.decisionList;
        synchronized (list) {
            this.decisionList.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServerDecision(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<String> list = this.decisionList;
        synchronized (list) {
            for (String string2 : this.decisionList) {
                if (string2.equalsIgnoreCase(string)) continue;
                arrayList.add(string2);
            }
        }
        this.decisionList = arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getServerDecisionList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<String> list = this.decisionList;
        synchronized (list) {
            for (String string : this.decisionList) {
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    @Override
    public ILoadBalancerServerClient processServerDataExtensions(Map<String, String> map) {
        HashMap<String, ILoadBalancerServerClient> hashMap = this.getClientsCopy(false);
        List<ILoadBalancerServerClient> list = new ArrayList<ILoadBalancerServerClient>();
        for (String object2 : hashMap.keySet()) {
            list.add(hashMap.get(object2));
        }
        for (String string : this.getServerDecisionList()) {
            ILoadBalancerServerDataExtension iLoadBalancerServerDataExtension;
            if (this.debugServerDecision) {
                this.logger.LogMessageInfo(CLASS.getName(), "Decision: " + string);
            }
            if ((iLoadBalancerServerDataExtension = this.getServerDataExtension(string)) != null) {
                if (this.debugServerDecision) {
                    this.logger.LogMessageInfo(CLASS.getName(), "Decision: " + string + " class is " + iLoadBalancerServerDataExtension);
                }
                list = iLoadBalancerServerDataExtension.processClientInformation(list, map);
            } else if (this.debugServerDecision) {
                this.logger.LogMessageInfo(CLASS.getName(), "Decision: " + string + " has no extension");
            }
            if (this.debugServerDecision) {
                this.logger.LogMessageInfo(CLASS.getName(), "Decision: Results size " + list.size());
            }
            if (list.size() != 1 || !this.returnLastClient) continue;
            ILoadBalancerServerClient iLoadBalancerServerClient = list.get(0);
            this.updateClientPortScheme(iLoadBalancerServerClient, map);
            if (this.debugServerDecision) {
                this.logger.LogMessageInfo(CLASS.getName(), "Decision: Result is 1, last client enabled, no more decisions needed final: " + iLoadBalancerServerClient.getClientHost() + " Client: " + iLoadBalancerServerClient.getAttribute("Client-ClientName"));
            }
            return iLoadBalancerServerClient;
        }
        if (this.debugServerDecision) {
            this.logger.LogMessageInfo(CLASS.getName(), "Decision: Results size after all decisions: " + list.size());
        }
        if (list.size() > 1) {
            ILoadBalancerServerClient iLoadBalancerServerClient = (ILoadBalancerServerClient)list.get(0);
            this.updateClientPortScheme(iLoadBalancerServerClient, map);
            if (this.debugServerDecision) {
                this.logger.LogMessageInfo(CLASS.getName(), "Decision: All decisions made, results > 1, using first result: " + iLoadBalancerServerClient.getClientHost() + " Client: " + iLoadBalancerServerClient.getAttribute("Client-ClientName"));
            }
            return iLoadBalancerServerClient;
        }
        if (list.size() == 1) {
            ILoadBalancerServerClient iLoadBalancerServerClient = (ILoadBalancerServerClient)list.get(0);
            this.updateClientPortScheme(iLoadBalancerServerClient, map);
            if (this.debugServerDecision) {
                this.logger.LogMessageInfo(CLASS.getName(), "Decision: All decisions made, Result is 1, using: " + iLoadBalancerServerClient.getClientHost() + " Client: " + iLoadBalancerServerClient.getAttribute("Client-ClientName"));
            }
            return iLoadBalancerServerClient;
        }
        if (this.debugServerDecision) {
            this.logger.LogMessageInfo(CLASS.getName(), "Decision: All decisions made, no results");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized HashMap<String, String> processClientRequest(IHTTPRequest iHTTPRequest, Map<String, String> map, String string) {
        Object object = this.lock;
        synchronized (object) {
            map.put("Client-SourceIP", iHTTPRequest.getRemoteAddr());
            map.put("Client-DestinPort", String.valueOf(iHTTPRequest.getServerPort()));
            return this.processResponse.processCommunicationInformation(map, this, string);
        }
    }

    private void updateClientPortScheme(ILoadBalancerServerClient iLoadBalancerServerClient, Map<String, String> map) {
        String string = "1935";
        if (map.containsKey("ClientPort")) {
            string = map.get("ClientPort");
        }
        if (string != null && !iLoadBalancerServerClient.getAttributes().containsKey("ClientExtensionBaseClientProperties-loadbalanceClientForcePort")) {
            iLoadBalancerServerClient.addAttribute("ClientExtensionBaseClientProperties-loadbalanceClientForcePort", string);
        }
        String string2 = "http";
        if (map.containsKey("ClientScheme") && map.get("ClientScheme").equalsIgnoreCase("true")) {
            string2 = "https";
        }
        if (string2 != null && !iLoadBalancerServerClient.getAttributes().containsKey("ClientExtensionBaseClientProperties-loadbalanceClientForceScheme")) {
            iLoadBalancerServerClient.addAttribute("ClientExtensionBaseClientProperties-loadbalanceClientForceScheme", string2);
        }
    }
}

