/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.loadbalancer.server;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.wowza.wms.http.IHTTPRequest;
import com.wowza.wms.http.IHTTPResponse;
import com.wowza.wms.plugin.loadbalancer.encryption.ILoadBalancerDecrypt;
import com.wowza.wms.plugin.loadbalancer.encryption.ILoadBalancerEncrypt;
import com.wowza.wms.plugin.loadbalancer.server.ILoadBalancerServerCommunication;
import com.wowza.wms.plugin.loadbalancer.utils.ILoadBalancerXMLParser;
import com.wowza.wms.plugin.loadbalancer.utils.Logger;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;

public class LoadBalancerServerCommunication
implements ILoadBalancerServerCommunication {
    private static final Class<LoadBalancerServerCommunication> CLASS = LoadBalancerServerCommunication.class;
    private final String serverCommunicationResponseXMLClass = "/com/wowza/wms/plugin/loadbalancer/templates/ServerResponseXML.xml";
    private final boolean sendCommandsAsXML = false;
    private final Lock lock = new ReentrantLock();
    private String decryptorClass = "com.wowza.wms.plugin.loadbalancer.encryption.LoadBalancerDecrypt";
    private String encryptorClass = "com.wowza.wms.plugin.loadbalancer.encryption.LoadBalancerEncrypt";
    private String xmlParserClass = "com.wowza.wms.plugin.loadbalancer.server.LoadBalancerServerXMLParser";
    private String clientCommsTranslated = "";
    private Logger logger = null;
    private ILoadBalancerDecrypt communicationDecrypter = null;
    private ILoadBalancerEncrypt communicationEncrypter = null;
    private ILoadBalancerXMLParser communicationXMLParser = null;
    private SAXParserFactory parserFactor = null;
    private String serverKey = "";
    private boolean debug = false;
    private boolean active = true;

    @Override
    public boolean init() {
        Class<?> clazz;
        try {
            clazz = Class.forName(this.getDecryptorClass());
            this.communicationDecrypter = (ILoadBalancerDecrypt)clazz.newInstance();
        }
        catch (Exception exception) {
            this.logger.LogMessageInfo(CLASS.getName(), "Decryption class not found, not initialising");
            this.active = false;
        }
        try {
            clazz = Class.forName(this.getEncryptorClass());
            this.communicationEncrypter = (ILoadBalancerEncrypt)clazz.newInstance();
        }
        catch (Exception exception) {
            this.logger.LogMessageInfo(CLASS.getName(), "Encryption class not found, not initialising");
            this.active = false;
        }
        if (!this.active) {
            return false;
        }
        this.communicationDecrypter.setLogger(this.logger);
        this.communicationDecrypter.setKey(this.getServerKey());
        this.communicationDecrypter.initialiseDecryptor();
        this.communicationEncrypter.setLogger(this.logger);
        this.communicationEncrypter.setKey(this.getServerKey());
        this.communicationEncrypter.initialiseEncryptor();
        this.parserFactor = SAXParserFactory.newInstance();
        this.clientCommsTranslated = this.ReturnFileClass(this.serverCommunicationResponseXMLClass);
        return this.active;
    }

    @Override
    public void setDecrytorClass(String string) {
        this.decryptorClass = string;
    }

    @Override
    public String getDecryptorClass() {
        return this.decryptorClass;
    }

    @Override
    public void setEncrytorClass(String string) {
        this.encryptorClass = string;
    }

    @Override
    public String getEncryptorClass() {
        return this.encryptorClass;
    }

    @Override
    public String getXMLParserClass() {
        return this.xmlParserClass;
    }

    @Override
    public void setXMLParserClass(String string) {
        this.xmlParserClass = string;
    }

    @Override
    public String getServerKey() {
        return this.serverKey;
    }

    @Override
    public void setServerKey(String string) {
        this.serverKey = string;
    }

    @Override
    public boolean getDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean bl) {
        this.active = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> processRequest(IHTTPRequest iHTTPRequest, IHTTPResponse iHTTPResponse, String string, String string2) {
        Map<String, String> map;
        if (!this.getActive()) {
            return null;
        }
        try {
            this.lock.lock();
            String string3 = "";
            try {
                string3 = this.communicationDecrypter.decryptData(string);
            }
            catch (Exception exception) {
                if (this.getDebug()) {
                    this.logger.LogMessageDebug(CLASS.getName(), "Decoded request failed exception was " + exception);
                }
                string3 = "";
            }
            System.out.println("output = " + string3);
            map = this.extractDataFromJson(string3);
        }
        finally {
            this.lock.unlock();
        }
        return map;
    }

    private Map<String, String> extractDataFromJson(String string) {
        Map<String, String> map = new HashMap<String, String>();
        try {
            map = (Map)new ObjectMapper().readValue(string, (TypeReference)new TypeReference<Map<String, String>>(){});
        }
        catch (JsonProcessingException jsonProcessingException) {
            jsonProcessingException.printStackTrace();
        }
        return map;
    }

    @Deprecated(forRemoval=true)
    private Map<String, String> extractDataFromXML(IHTTPRequest iHTTPRequest, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            SAXParser sAXParser = this.parserFactor.newSAXParser();
            sAXParser.parse(new InputSource(new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8))), this.communicationXMLParser.getDefaultHandler());
            hashMap.putAll(this.communicationXMLParser.getData());
        }
        catch (Exception exception) {
            this.logger.LogMessageInfo(CLASS.getName(), "Unable to parse message, perhaps incorrect key for IP: " + iHTTPRequest.getRemoteAddr());
        }
        return hashMap;
    }

    @Override
    public String generateResponse(Map<String, String> map) {
        String string = null;
        string = this.generateResponseJson(map);
        return string;
    }

    private String generateResponseJson(Map<String, String> map) {
        String string = null;
        String string2 = null;
        try {
            string = new ObjectMapper().writeValueAsString(map);
            string2 = this.communicationEncrypter.encryptData(string);
        }
        catch (JsonProcessingException jsonProcessingException) {
            this.logger.LogMessageError(CLASS.getName(), "error processing json response");
        }
        if (this.debug) {
            this.logger.LogMessageDebug(CLASS.getName(), "Response after attributes is " + string);
            this.logger.LogMessageDebug(CLASS.getName(), "Response after encryption is " + string2);
        }
        return string2;
    }

    @Deprecated(forRemoval=true)
    private String generateResponseXML(Map<String, String> map) {
        String string = this.clientCommsTranslated;
        if (this.getDebug()) {
            this.logger.LogMessageDebug(CLASS.getName(), "Response file is " + string);
        }
        Object object = "";
        if (map != null) {
            for (String string2 : map.keySet()) {
                if (!string2.startsWith("Client-") && !string2.startsWith("Server-")) continue;
                String string3 = map.get(string2);
                object = (String)object + "<Attribute>\n<Name>" + string2 + "</Name>\n<Value>" + string3 + "</Value>\n</Attribute>\n";
            }
        }
        string = string.replace("ATTRIBUTELIST", (CharSequence)object);
        if (this.getDebug()) {
            this.logger.LogMessageDebug(CLASS.getName(), "Response after attributes is " + string);
        }
        string = this.communicationEncrypter.encryptData(string);
        if (this.getDebug()) {
            this.logger.LogMessageDebug(CLASS.getName(), "Response after encryption is " + string);
        }
        return string;
    }

    @Deprecated(forRemoval=true)
    public String ReturnFileClass(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "UTF-8";
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        try {
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new BufferedInputStream(inputStream), string2);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string3 = "";
            while ((string3 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string3 + "\n");
            }
            bufferedReader.close();
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringBuffer.toString();
    }
}

