/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.loadbalancer.server;

import com.wowza.wms.http.HTTProvider2Base;
import com.wowza.wms.http.IHTTPRequest;
import com.wowza.wms.http.IHTTPResponse;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.plugin.loadbalancer.server.ILoadBalancerServer;
import com.wowza.wms.plugin.loadbalancer.server.ILoadBalancerServerCommunication;
import com.wowza.wms.plugin.loadbalancer.utils.Logger;
import com.wowza.wms.vhost.HostPort;
import com.wowza.wms.vhost.IVHost;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LoadBalancerServerCommunicationProvider
extends HTTProvider2Base {
    private static final Class<LoadBalancerServerCommunicationProvider> CLASS = LoadBalancerServerCommunicationProvider.class;
    private boolean debug = false;
    private boolean available = false;
    private ILoadBalancerServer loadBalanceServer = null;
    private ILoadBalancerServerCommunication serverComms = null;
    private Logger logger = null;

    public void onBind(IVHost iVHost, HostPort hostPort) {
        super.onBind(iVHost, hostPort);
        this.serverComms = this.loadBalanceServer.getServerCommunication();
        if (this.getDebug()) {
            this.logger.LogMessageInfo(CLASS.getName(), "Server comms object is " + this.serverComms);
        }
        if (this.serverComms != null) {
            this.available = true;
        }
    }

    public void onHTTPRequest(IVHost iVHost, IHTTPRequest iHTTPRequest, IHTTPResponse iHTTPResponse) {
        Map<String, String> map3;
        String string;
        String string2;
        block30: {
            Map map2;
            block29: {
                if (this.getDebug()) {
                    this.logger.LogMessageInfo(CLASS.getName(), "is available '" + this.available + "'");
                }
                if (!this.available) {
                    return;
                }
                string2 = "";
                string = "";
                iHTTPRequest.parseBodyForParams();
                map2 = iHTTPRequest.getParameterMap();
                if (this.getDebug()) {
                    this.logger.LogMessageInfo(CLASS.getName(), "Received data params");
                    for (Map<String, String> map3 : map2.keySet()) {
                        this.logger.LogMessageInfo(CLASS.getName(), "Parameter received is '" + (String)((Object)map3) + "' value '" + (String)((List)map2.get(map3)).get(0) + "'");
                    }
                }
                try {
                    if (map2.containsKey("data")) {
                        string2 = (String)((List)map2.get("data")).get(0);
                    }
                }
                catch (Exception exception) {
                    if (!this.getDebug()) break block29;
                    this.logger.LogMessageInfo(CLASS.getName(), "not received command " + exception);
                    this.logger.LogMessageInfo(CLASS.getName(), "not received command cause: " + exception.getCause());
                }
            }
            try {
                if (map2.containsKey("client")) {
                    string = (String)((List)map2.get("client")).get(0);
                }
            }
            catch (Exception exception) {
                if (!this.getDebug()) break block30;
                this.logger.LogMessageInfo(CLASS.getName(), "noReceivedID " + exception);
                this.logger.LogMessageInfo(CLASS.getName(), "noReceivedID cause: " + exception.getCause());
            }
        }
        if (string2.length() == 0) {
            this.logger.LogMessageInfo(CLASS.getName(), "received command is no length '" + string2 + "'");
            return;
        }
        if (this.getDebug()) {
            this.logger.LogMessageInfo(CLASS.getName(), "HTTP request data is " + string2);
            this.logger.LogMessageInfo(CLASS.getName(), "HTTP request data id " + string);
        }
        Object object = "";
        map3 = null;
        map3 = this.serverComms.processRequest(iHTTPRequest, iHTTPResponse, string2, string);
        if (map3 != null) {
            if (this.getDebug()) {
                for (Object object2 : map3.keySet()) {
                    this.logger.LogMessageInfo(CLASS.getName(), "processRequest attribute is name: " + (String)object2 + " value: " + (String)map3.get(object2));
                }
            }
            if ((map3 = this.loadBalanceServer.processClientRequest(iHTTPRequest, map3, string)) != null) {
                if (this.getDebug()) {
                    for (Object object2 : map3.keySet()) {
                        this.logger.LogMessageInfo(CLASS.getName(), "processClientRequest attribute is Name: " + (String)object2 + " value: " + (String)map3.get(object2));
                    }
                }
                if ((object = this.serverComms.generateResponse(map3)) != null) {
                    if (this.getDebug()) {
                        this.logger.LogMessageInfo(CLASS.getName(), "generateResponse IS NOT NULL");
                    }
                } else {
                    if (this.getDebug()) {
                        this.logger.LogMessageInfo(CLASS.getName(), "generateResponse was null");
                    }
                    object = "";
                }
            } else if (this.getDebug()) {
                this.logger.LogMessageInfo(CLASS.getName(), "HTTP processClientRequest receivedData was null");
            }
        } else if (this.getDebug()) {
            this.logger.LogMessageInfo(CLASS.getName(), "HTTP processRequest receivedData was null");
        }
        if (this.getDebug()) {
            this.logger.LogMessageInfo(CLASS.getName(), "HTTP processRequest sending output");
        }
        try {
            Object object2;
            Iterator iterator = iHTTPResponse.getOutputStream();
            object2 = ((String)object).getBytes();
            ((OutputStream)((Object)iterator)).write((byte[])object2);
            ((OutputStream)((Object)iterator)).flush();
            ((OutputStream)((Object)iterator)).close();
        }
        catch (Exception exception) {
            WMSLoggerFactory.getLogger(null).error("LoadBalancerServerCommunicationProvider: " + exception);
        }
    }

    public void setLoadBalancerServerObject(ILoadBalancerServer iLoadBalancerServer) {
        this.loadBalanceServer = iLoadBalancerServer;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }
}

