/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.loadbalancer.server;

import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.bootstrap.Bootstrap;
import com.wowza.wms.plugin.loadbalancer.server.ILoadBalancerServerClient;
import com.wowza.wms.plugin.loadbalancer.server.ILoadBalancerServerDataExtension;
import com.wowza.wms.plugin.loadbalancer.utils.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LoadBalancerServerExtensionPrivateAddressMap
implements ILoadBalancerServerDataExtension {
    private static final Class<LoadBalancerServerExtensionPrivateAddressMap> CLASS = LoadBalancerServerExtensionPrivateAddressMap.class;
    private final String COMPONENT_NAME = "PrivateAddressSpace";
    private String addressMapLocation = "{com.wowza.wms.context.ServerConfigHome}/privateAddressMap.txt";
    private boolean isReady = false;
    private boolean debug = false;
    private boolean active = false;
    private long lastMapUpdate = 0L;
    private long nextUpdate = 0L;
    private boolean reloadMap = false;
    private PrivateAddressMapLookup addressMapLookup = null;
    private Logger logger = null;

    @Override
    public void init(WMSProperties wMSProperties) {
        this.addressMapLocation = wMSProperties.getPropertyStr("loadbalanceServerPrivateAddressMapFile", this.addressMapLocation);
        this.addressMapLocation = this.addressMapLocation.replace("{com.wowza.wms.context.ServerConfigHome}", Bootstrap.getServerHome((int)2));
        if (this.getDebug()) {
            this.logger.LogMessageDebug(CLASS.getName(), "Private address map location is " + this.addressMapLocation);
        }
        try {
            this.loadDatabase();
        }
        catch (Exception exception) {
            this.isReady = false;
        }
    }

    public boolean reloadDatabase() {
        if (this.clearDatabase()) {
            try {
                this.isReady = this.loadDatabase();
            }
            catch (Exception exception) {
                this.isReady = false;
            }
            return this.isReady;
        }
        return false;
    }

    public boolean loadDatabase() throws IOException {
        try {
            File file = new File(this.addressMapLocation);
            if (file.exists()) {
                this.addressMapLookup = new PrivateAddressMapLookup(this.addressMapLocation);
                this.addressMapLookup.loadDatabase();
                this.lastMapUpdate = file.lastModified();
                this.isReady = true;
                if (this.getDebug()) {
                    this.logger.LogMessageDebug(CLASS.getName(), "PrivateAddressMap Data File " + this.addressMapLocation);
                }
            } else if (this.getDebug()) {
                this.logger.LogMessageInfo(CLASS.getName(), "PrivateAddressMap Data File not found at the following location provided: " + this.addressMapLocation);
            }
        }
        catch (Exception exception) {
            if (this.getDebug()) {
                this.logger.LogMessageDebug(CLASS.getName(), "PrivateAddressMap Data File failed to load due to " + exception + " using file " + this.addressMapLocation);
            }
            this.isReady = false;
            this.addressMapLookup = null;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            if (this.getDebug()) {
                this.logger.LogMessageDebug(CLASS.getName(), "PrivateAddressMap Data File failed to load due to " + noClassDefFoundError + " using file " + this.addressMapLocation);
            }
            this.addressMapLookup = null;
            this.isReady = false;
        }
        return this.isReady;
    }

    public boolean clearDatabase() {
        if (this.addressMapLookup != null && this.isReady) {
            this.addressMapLookup.clearDatabase();
            this.isReady = false;
        }
        return true;
    }

    @Override
    public boolean getDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public boolean getReady() {
        return this.isReady;
    }

    @Override
    public void updateComponent(HashMap<String, String> hashMap) {
        if (System.currentTimeMillis() / 1000L > this.nextUpdate) {
            this.nextUpdate = System.currentTimeMillis() / 1000L + 300L;
            File file = new File(this.addressMapLocation);
            if (file.exists()) {
                long l = file.lastModified();
                if (this.reloadMap) {
                    this.reloadDatabase();
                    this.reloadMap = false;
                }
                if (l != this.lastMapUpdate) {
                    this.lastMapUpdate = l;
                    this.reloadMap = true;
                }
            }
        }
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean bl) {
        this.active = bl;
    }

    @Override
    public String getComponentName() {
        return "PrivateAddressSpace";
    }

    @Override
    public List<ILoadBalancerServerClient> processClientInformation(List<ILoadBalancerServerClient> list, Map<String, String> map) {
        if (!this.getActive()) {
            if (this.getDebug()) {
                this.logger.LogMessageDebug(CLASS.getName(), "PrivateAddressMap not active, returning all client sent in");
            }
            return list;
        }
        if (!this.getReady()) {
            if (this.getDebug()) {
                this.logger.LogMessageDebug(CLASS.getName(), "PrivateAddressMap not ready, returning all client sent in");
            }
            return list;
        }
        if (list == null) {
            return list;
        }
        String string = "";
        String string2 = map.get("ClientIP");
        try {
            string = this.addressMapLookup.getCode(string2);
            if (this.getDebug()) {
                this.logger.LogMessageDebug(CLASS.getName(), "PrivateAddress IP: " + string2 + " found tag value " + string);
            }
        }
        catch (Exception exception) {
            return list;
        }
        if (string == null) {
            if (this.getDebug()) {
                this.logger.LogMessageDebug(CLASS.getName(), "PrivateAddressMap return null, returning all clients into search");
            }
            return list;
        }
        ArrayList<ILoadBalancerServerClient> arrayList = new ArrayList<ILoadBalancerServerClient>();
        if (this.getDebug()) {
            this.logger.LogMessageDebug(CLASS.getName(), "PrivateAddressMap starting search");
        }
        for (int i = 0; i < list.size(); ++i) {
            HashMap<String, String> hashMap;
            ILoadBalancerServerClient iLoadBalancerServerClient = null;
            try {
                iLoadBalancerServerClient = list.get(i);
            }
            catch (Exception exception) {
                continue;
            }
            if (iLoadBalancerServerClient == null || !(hashMap = iLoadBalancerServerClient.getAttributes()).containsKey("ClientPrivateAddressSpace-loadbalanceClientPrivateAddressTagList")) continue;
            String string3 = iLoadBalancerServerClient.getAttribute("ClientPrivateAddressSpace-loadbalanceClientPrivateAddressTagList");
            if (this.getDebug()) {
                this.logger.LogMessageDebug(CLASS.getName(), "Client " + iLoadBalancerServerClient.getClientID() + " Configured Tag(s) found " + string3);
            }
            if (!string3.contains(string) && !string3.contains("*")) continue;
            if (this.getDebug()) {
                this.logger.LogMessageDebug(CLASS.getName(), "Client " + iLoadBalancerServerClient + " tag(s) found " + string3 + " matches " + string);
            }
            arrayList.add(iLoadBalancerServerClient);
        }
        return arrayList;
    }

    public class PrivateAddressMapLookup {
        private final HashMap<Long, String> addressMap = new HashMap();
        private String fileName = "";

        public PrivateAddressMapLookup(String string) {
            this.fileName = string;
        }

        public boolean loadDatabase() {
            boolean bl = false;
            File file = new File(this.fileName);
            if (file.exists()) {
                try {
                    String string;
                    FileInputStream fileInputStream = new FileInputStream(this.fileName);
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
                    while ((string = bufferedReader.readLine()) != null) {
                        System.out.println(string);
                        String[] stringArray = null;
                        stringArray = this.parseLineData(string);
                        if (stringArray != null) {
                            if (LoadBalancerServerExtensionPrivateAddressMap.this.getDebug()) {
                                LoadBalancerServerExtensionPrivateAddressMap.this.getLogger().LogMessageInfo(CLASS.getName(), "Adding into map: Start: " + stringArray[0] + "(" + this.ipToLong(stringArray[0]) + ") End:" + stringArray[1] + "(" + this.ipToLong(stringArray[1]) + ") Code:" + stringArray[2]);
                            }
                            this.addressMap.put(this.ipToLong(stringArray[0]), stringArray[1] + "##MARKER##" + stringArray[2]);
                            continue;
                        }
                        if (!LoadBalancerServerExtensionPrivateAddressMap.this.getDebug()) continue;
                        LoadBalancerServerExtensionPrivateAddressMap.this.getLogger().LogMessageInfo(CLASS.getName(), "Not adding to map, failed to parse line: " + string);
                    }
                    bl = true;
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    bl = false;
                }
            }
            return bl;
        }

        public String getCode(String string) {
            long l = this.ipToLong(string);
            if (LoadBalancerServerExtensionPrivateAddressMap.this.getDebug()) {
                LoadBalancerServerExtensionPrivateAddressMap.this.getLogger().LogMessageInfo(CLASS.getName(), "Looking for value '" + l + "'");
            }
            for (long l2 : this.addressMap.keySet()) {
                if (LoadBalancerServerExtensionPrivateAddressMap.this.getDebug()) {
                    LoadBalancerServerExtensionPrivateAddressMap.this.getLogger().LogMessageInfo(CLASS.getName(), "Start entry point '" + l2 + "'");
                }
                if (l < l2) continue;
                if (LoadBalancerServerExtensionPrivateAddressMap.this.getDebug()) {
                    LoadBalancerServerExtensionPrivateAddressMap.this.getLogger().LogMessageInfo(CLASS.getName(), "IP '" + l + " higher than '" + l2 + "'");
                }
                try {
                    String[] stringArray = this.addressMap.get(l2).split("##MARKER##");
                    if (LoadBalancerServerExtensionPrivateAddressMap.this.getDebug()) {
                        LoadBalancerServerExtensionPrivateAddressMap.this.getLogger().LogMessageInfo(CLASS.getName(), "IP end is '" + stringArray[0] + "'");
                    }
                    long l3 = this.ipToLong(stringArray[0]);
                    if (LoadBalancerServerExtensionPrivateAddressMap.this.getDebug()) {
                        LoadBalancerServerExtensionPrivateAddressMap.this.getLogger().LogMessageInfo(CLASS.getName(), "IP is '" + l + " lower than '" + l3 + "'");
                    }
                    if (l > l3) continue;
                    if (LoadBalancerServerExtensionPrivateAddressMap.this.getDebug()) {
                        LoadBalancerServerExtensionPrivateAddressMap.this.getLogger().LogMessageInfo(CLASS.getName(), "IP was in range returning client");
                    }
                    return stringArray[1];
                }
                catch (Exception exception) {
                }
            }
            return "NOTAGFOUND";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearDatabase() {
            HashMap<Long, String> hashMap = this.addressMap;
            synchronized (hashMap) {
                this.addressMap.clear();
            }
        }

        private String[] parseLineData(String string) {
            String[] stringArray;
            block16: {
                stringArray = null;
                if (string.startsWith("#")) {
                    if (LoadBalancerServerExtensionPrivateAddressMap.this.getDebug()) {
                        LoadBalancerServerExtensionPrivateAddressMap.this.getLogger().LogMessageInfo(CLASS.getName(), "Comment found ignoring: " + string);
                    }
                    return stringArray;
                }
                try {
                    String[] stringArray2 = string.split(",");
                    if (stringArray2.length == 3) {
                        if (LoadBalancerServerExtensionPrivateAddressMap.this.getDebug()) {
                            LoadBalancerServerExtensionPrivateAddressMap.this.getLogger().LogMessageInfo(CLASS.getName(), "Found a three part entry");
                        }
                        stringArray = new String[]{stringArray2[0], stringArray2[1], stringArray2[2]};
                        if (LoadBalancerServerExtensionPrivateAddressMap.this.getDebug()) {
                            LoadBalancerServerExtensionPrivateAddressMap.this.getLogger().LogMessageInfo(CLASS.getName(), "Start IP: " + stringArray[0] + " End IP: " + stringArray[1] + " Code: " + stringArray[2]);
                        }
                        break block16;
                    }
                    if (stringArray2.length == 2) {
                        if (LoadBalancerServerExtensionPrivateAddressMap.this.getDebug()) {
                            LoadBalancerServerExtensionPrivateAddressMap.this.getLogger().LogMessageInfo(CLASS.getName(), "Found a two part entry");
                        }
                        if (stringArray2[0].indexOf("/") <= 0) break block16;
                        try {
                            String[] stringArray3 = stringArray2[0].split("\\/");
                            int n = Integer.valueOf(stringArray3[1]);
                            n = 32 - n;
                            if (n > 0) {
                                n = 1 << n;
                            }
                            if (--n < 0) {
                                n = 0;
                            }
                            long l = this.ipToLong(stringArray3[0]);
                            String string2 = this.intToIp(l += (long)n);
                            if (LoadBalancerServerExtensionPrivateAddressMap.this.getDebug()) {
                                LoadBalancerServerExtensionPrivateAddressMap.this.getLogger().LogMessageInfo(CLASS.getName(), "Start IP: " + stringArray3[0] + " End IP: " + string2 + " Code: " + stringArray2[1]);
                            }
                            stringArray = new String[]{stringArray3[0], string2, stringArray2[1]};
                        }
                        catch (Exception exception) {
                            if (LoadBalancerServerExtensionPrivateAddressMap.this.getDebug()) {
                                LoadBalancerServerExtensionPrivateAddressMap.this.getLogger().LogMessageInfo(CLASS.getName(), "CIDR notation failed with " + exception);
                            }
                            break block16;
                        }
                    }
                    if (LoadBalancerServerExtensionPrivateAddressMap.this.getDebug()) {
                        LoadBalancerServerExtensionPrivateAddressMap.this.getLogger().LogMessageInfo(CLASS.getName(), "Invalid line found: " + string);
                    }
                }
                catch (Exception exception) {
                    return null;
                }
            }
            return stringArray;
        }

        private long ipToLong(String string) {
            long l = 0L;
            String[] stringArray = string.split("\\.");
            for (int i = 3; i >= 0; --i) {
                l |= Long.parseLong(stringArray[3 - i]) << i * 8;
            }
            return l & 0xFFFFFFFFFFFFFFFFL;
        }

        private String intToIp(long l) {
            return (l >> 24 & 0xFFL) + "." + (l >> 16 & 0xFFL) + "." + (l >> 8 & 0xFFL) + "." + (l & 0xFFL);
        }
    }
}

