/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.loadbalancer.server;

import com.wowza.wms.plugin.loadbalancer.ReleaseInfo;
import com.wowza.wms.plugin.loadbalancer.server.ILoadBalancerServer;
import com.wowza.wms.plugin.loadbalancer.server.ILoadBalancerServerClient;
import com.wowza.wms.plugin.loadbalancer.server.ILoadBalancerServerProcessResponse;
import com.wowza.wms.plugin.loadbalancer.server.LoadBalancerServerClient;
import com.wowza.wms.plugin.loadbalancer.utils.Logger;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class LoadBalancerServerProcessResponse
implements ILoadBalancerServerProcessResponse {
    private static final Class<LoadBalancerServerProcessResponse> CLASS = LoadBalancerServerProcessResponse.class;
    private int clientIDs = 0;
    private boolean debug = false;
    private Logger logger = null;
    private Random rand = new Random();

    @Override
    public HashMap<String, String> processCommunicationInformation(Map<String, String> map, ILoadBalancerServer iLoadBalancerServer, String string) {
        if (map == null) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, ILoadBalancerServerClient> hashMap2 = iLoadBalancerServer.getClients(true);
        if (string.length() > 0) {
            if (this.getDebug()) {
                this.logger.LogMessageDebug(CLASS.getName(), "LoadBalancer clientid sent was " + string);
                for (String string2 : map.keySet()) {
                    this.logger.LogMessageDebug(CLASS.getName(), "LoadBalancer attribute is Name " + string2 + " value " + map.get(string2));
                }
            }
            if (map.containsKey("Client-ClientID")) {
                if (this.getDebug()) {
                    this.logger.LogMessageDebug(CLASS.getName(), "LoadBalancer attribute Server-ClientID sent was " + map.get("Client-ClientID"));
                }
                if (string.equalsIgnoreCase(map.get("Client-ClientID"))) {
                    if (this.getDebug()) {
                        this.logger.LogMessageDebug(CLASS.getName(), "LoadBalancer found matching client");
                    }
                    if (hashMap2.containsKey(string) && map.containsKey("Client-ClientName")) {
                        if (this.getDebug()) {
                            this.logger.LogMessageDebug(CLASS.getName(), "LoadBalancer client already found, updating: " + map.get("Client-ClientName"));
                        }
                        ILoadBalancerServerClient iLoadBalancerServerClient = hashMap2.get(string);
                        iLoadBalancerServerClient.setLastUpdate(System.currentTimeMillis() / 1000L);
                        iLoadBalancerServerClient.updateClient(map);
                        if (iLoadBalancerServerClient.getState().equalsIgnoreCase("new")) {
                            this.logger.LogMessageInfo(CLASS.getName(), "Initialization complete client: " + map.get("Client-ClientName"));
                            if (iLoadBalancerServerClient.getAttributes().containsKey("ClientExtensionBaseClientProperties-loadbalanceClientVersion") && !iLoadBalancerServerClient.getAttribute("ClientExtensionBaseClientProperties-loadbalanceClientVersion").equalsIgnoreCase(String.valueOf(ReleaseInfo.getBuildNumber()))) {
                                this.logger.LogMessageInfo(CLASS.getName(), "Warning: Client version: " + iLoadBalancerServerClient.getAttribute("ClientExtensionBaseClientProperties-loadbalanceClientVersion") + " Server version: " + ReleaseInfo.getBuildNumber() + " versions are not equal");
                            }
                        }
                        if (iLoadBalancerServerClient.getState().equalsIgnoreCase("pause")) {
                            if (this.getDebug()) {
                                this.logger.LogMessageDebug(CLASS.getName(), "LoadBalancer client paused: " + map.get("Client-ClientName"));
                            }
                            hashMap.put("Server-Response", "OK");
                            hashMap.put("Server-Status", "OK");
                            hashMap.put("Server-ClientID", string);
                        } else if (iLoadBalancerServerClient.getState().equalsIgnoreCase("stop")) {
                            if (this.getDebug()) {
                                this.logger.LogMessageDebug(CLASS.getName(), "LoadBalancer client stopping: " + map.get("Client-ClientName"));
                            }
                            iLoadBalancerServerClient.setState("STOP");
                            hashMap.put("Server-Status", "STOP");
                        } else {
                            if (this.getDebug()) {
                                this.logger.LogMessageDebug(CLASS.getName(), "LoadBalancer client OK: " + map.get("Client-ClientName"));
                            }
                            iLoadBalancerServerClient.setState("OK");
                            hashMap.put("Server-Response", "OK");
                            hashMap.put("Server-Status", "OK");
                            hashMap.put("Server-ClientID", string);
                        }
                    } else {
                        if (this.getDebug()) {
                            this.logger.LogMessageDebug(CLASS.getName(), "LoadBalancer client REGISTER: " + map.get("Client-ClientName"));
                        }
                        hashMap.put("Server-Response", "REGISTER");
                        hashMap.put("Server-Status", "REGISTER");
                        hashMap.put("Server-ClientID", "");
                    }
                } else {
                    if (this.getDebug()) {
                        this.logger.LogMessageDebug(CLASS.getName(), "LoadBalancer client REGISTER: " + map.get("Client-ClientName"));
                    }
                    hashMap.put("Server-Response", "REGISTER");
                    hashMap.put("Server-Status", "REGISTER");
                    hashMap.put("Server-ClientID", "");
                }
            } else {
                if (this.getDebug()) {
                    this.logger.LogMessageDebug(CLASS.getName(), "LoadBalancer client REGISTER: " + map.get("Client-ClientName"));
                }
                hashMap.put("Server-Response", "REGISTER");
                hashMap.put("Server-Status", "REGISTER");
                hashMap.put("Server-ClientID", "");
            }
        } else if (map.containsKey("Client-ClientName")) {
            LoadBalancerServerClient loadBalancerServerClient = new LoadBalancerServerClient();
            String string3 = this.getNextClientID();
            loadBalancerServerClient.setClientID(string3);
            loadBalancerServerClient.updateClient(map);
            loadBalancerServerClient.setState("NEW");
            loadBalancerServerClient.setLastUpdate(System.currentTimeMillis() / 1000L);
            hashMap.put("Server-Response", "OK");
            hashMap.put("Server-Status", "OK");
            hashMap.put("Server-ClientID", string3);
            this.logger.LogMessageInfo(CLASS.getName(), "Initializing new client: " + map.get("Client-ClientName"));
            iLoadBalancerServer.addClient(loadBalancerServerClient);
        }
        return hashMap;
    }

    public String getNextClientID() {
        ++this.clientIDs;
        return String.valueOf(this.clientIDs) + this.rand.nextInt(50);
    }

    @Override
    public boolean getDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }
}

