/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.loadbalancer.server;

import com.wowza.wms.application.IApplicationNotify;
import com.wowza.wms.http.IHTTPProvider;
import com.wowza.wms.plugin.loadbalancer.application.ApplicationListener;
import com.wowza.wms.plugin.loadbalancer.http.LoadBalancerHTTPProvider;
import com.wowza.wms.plugin.loadbalancer.server.ILoadBalancerServer;
import com.wowza.wms.plugin.loadbalancer.server.LoadBalancerServerCommunicationProvider;
import com.wowza.wms.plugin.loadbalancer.utils.Logger;
import com.wowza.wms.vhost.HostPort;
import com.wowza.wms.vhost.HostPortList;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.VHostNotifyBase;
import java.util.List;
import java.util.stream.Stream;

public class LoadBalancerServerVHostSetup
extends VHostNotifyBase {
    private static final Class<LoadBalancerServerVHostSetup> CLASS = LoadBalancerServerVHostSetup.class;
    protected String configVHostName = "_defaultVHost_";
    protected String commsIp = "*";
    protected String commsPort = "1935";
    protected String commsPath = "loadbalancerinterface";
    protected String redirectIp = "*";
    protected String redirectPort = "1935";
    protected String redirectPath = "redirect";
    protected String infoIp = "*";
    protected String infoPort = "1935";
    protected String infoPath = "loadbalanceinfo";
    protected String appNames = "redirect";
    protected String authenticationMethod = "admin-basic";
    protected ILoadBalancerServer loadBalanceServer = null;
    protected Logger logger = null;
    protected boolean debug = false;
    protected boolean debugHTTPExtensions = false;

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setCommsIP(String string) {
        this.commsIp = string;
    }

    public void setCommsPort(String string) {
        this.commsPort = string;
    }

    public void setCommsPath(String string) {
        this.commsPath = string;
    }

    public void setRedirectIp(String string) {
        this.redirectIp = string;
    }

    public void setRedirectPort(String string) {
        this.redirectPort = string;
    }

    public void setRedirectPath(String string) {
        this.redirectPath = string;
    }

    public void setInfoIp(String string) {
        this.infoIp = string;
    }

    public void setInfoPort(String string) {
        this.infoPort = string;
    }

    public void setInfoPath(String string) {
        this.infoPath = string;
    }

    public void setApplicationNames(String string) {
        this.appNames = string;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public void setDebugHTTPProvider(boolean bl) {
        this.debugHTTPExtensions = bl;
    }

    public void setVHostName(String string) {
        this.configVHostName = string;
    }

    public void setLoadBalancerServerObject(ILoadBalancerServer iLoadBalancerServer) {
        this.loadBalanceServer = iLoadBalancerServer;
    }

    public void onVHostInit(IVHost iVHost) {
        boolean bl = false;
        if (iVHost.getName().equals(this.configVHostName)) {
            HostPortList hostPortList = iVHost.getHostPortsList();
            for (int i = 0; i < hostPortList.size(); ++i) {
                HostPort hostPort = hostPortList.get(i);
                List list = hostPort.getHttpProviders();
                int n = hostPort.getPort();
                String string = String.valueOf(hostPort.getAddressStr());
                if (string.contains("[any]")) {
                    string = "*";
                }
                if (this.testPort(n, this.commsPort) && this.testIp(string, this.commsIp)) {
                    this.addCommsProvider(n, string, list);
                }
                if (this.testPort(n, this.redirectPort) && this.testIp(string, this.redirectIp)) {
                    this.addRedirectProvider(n, string, list);
                }
                if (!this.testPort(n, this.infoPort) || !this.testIp(string, this.infoIp)) continue;
                this.addInfoProvider(n, string, list);
            }
            if (this.appNames.length() > 0) {
                iVHost.addApplicationListener((IApplicationNotify)new ApplicationListener(this.logger, this.appNames));
            }
        }
    }

    private boolean testIp(String string, String string2) {
        return string.equals("*") || string2.equals("*") || string.equalsIgnoreCase(string2);
    }

    private boolean testPort(int n, String string) {
        return Stream.of(string.split(",")).map(String::trim).anyMatch(String.valueOf(n)::equals);
    }

    private void addInfoProvider(int n, String string, List<IHTTPProvider> list) {
        LoadBalancerHTTPProvider loadBalancerHTTPProvider = new LoadBalancerHTTPProvider();
        loadBalancerHTTPProvider.setRequestFilters(this.infoPath + "*");
        loadBalancerHTTPProvider.setAuthenticationMethod(this.authenticationMethod);
        loadBalancerHTTPProvider.setLoadBalancerServerObject(this.loadBalanceServer);
        loadBalancerHTTPProvider.setDebug(this.debugHTTPExtensions);
        loadBalancerHTTPProvider.setDefaultOutput("serverinfo");
        loadBalancerHTTPProvider.setLogger(this.logger);
        list.add(0, (IHTTPProvider)loadBalancerHTTPProvider);
        loadBalancerHTTPProvider.init();
        this.logger.LogMessageInfo(CLASS.getName(), "HTTPProvider: " + string + ":" + n + " ServerInfo path: " + this.infoPath);
    }

    private void addRedirectProvider(int n, String string, List<IHTTPProvider> list) {
        LoadBalancerHTTPProvider loadBalancerHTTPProvider = new LoadBalancerHTTPProvider();
        loadBalancerHTTPProvider.setRequestFilters(this.redirectPath + "*");
        loadBalancerHTTPProvider.setAuthenticationMethod("none");
        loadBalancerHTTPProvider.setLoadBalancerServerObject(this.loadBalanceServer);
        loadBalancerHTTPProvider.setDebug(this.debugHTTPExtensions);
        loadBalancerHTTPProvider.setLogger(this.logger);
        list.add(0, (IHTTPProvider)loadBalancerHTTPProvider);
        loadBalancerHTTPProvider.init();
        this.logger.LogMessageInfo(CLASS.getName(), "HTTPProvider: " + string + ":" + n + " HTTPClientHandler path: " + this.redirectPath);
    }

    private void addCommsProvider(int n, String string, List<IHTTPProvider> list) {
        LoadBalancerServerCommunicationProvider loadBalancerServerCommunicationProvider = new LoadBalancerServerCommunicationProvider();
        loadBalancerServerCommunicationProvider.setRequestFilters(this.commsPath + "*");
        loadBalancerServerCommunicationProvider.setAuthenticationMethod("none");
        loadBalancerServerCommunicationProvider.setLoadBalancerServerObject(this.loadBalanceServer);
        loadBalancerServerCommunicationProvider.setDebug(this.debug);
        loadBalancerServerCommunicationProvider.setLogger(this.logger);
        list.add(0, (IHTTPProvider)loadBalancerServerCommunicationProvider);
        loadBalancerServerCommunicationProvider.init();
        this.logger.LogMessageInfo(CLASS.getName(), "HTTPProvider: " + string + ":" + n + " ServerCommunications path: " + this.commsPath);
    }

    public void setAuthenticationMethod(String string) {
        this.authenticationMethod = string;
    }
}

