package my.domain.test.client.extension;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.plugin.loadbalancer.client.ILoadBalancerClientDataExtension;
import com.wowza.wms.plugin.loadbalancer.utils.Logger;
import com.wowza.wms.server.IServer;
import com.wowza.wms.vhost.IVHost;

public class LoadBalancerClientDummyExtension implements ILoadBalancerClientDataExtension
{
	// The COMPONENET_NAME must be unique, if an extension with the same name is already loaded 
	// the extension is not loaded
	private static final Class<LoadBalancerClientDummyExtension> CLASS = LoadBalancerClientDummyExtension.class;
	private final String COMPONENT_NAME = "ClientExtensionDummy";
	private boolean debug = false;
	private boolean active = false;
	private Logger logger = null;

	public void init(WMSProperties props, IServer iServer, List<IVHost> vHosts)
	{
		// The props contain the properties from the Server or VHost. This allows you to use your own
		// custom properties for your own extensions.

		// The iServer value is null if running as a VHost listener

		// A list of VHosts is passed into the List VHosts. If the server is configured as 
		// a VHost listener then only that VHost is present in the list.

		// The init is called when the extension is loaded

		Iterator<IVHost> useableVHosts = vHosts.iterator();
		while (useableVHosts.hasNext())
		{
			IVHost thisVhost = useableVHosts.next();
			if (getDebug() == true)
			{
				WMSLoggerFactory.getLogger(CLASS).info(CLASS + " Doing Vhost " + thisVhost.getName());
			}
		}
	}

	public boolean getDebug()
	{
		return this.debug;
	}

	public void setDebug(boolean debug)
	{
		this.debug = debug;
	}

	public boolean getActive()
	{
		return this.active;
	}

	public void setActive(boolean active)
	{
		this.active = active;
	}

	public Logger getLogger()
	{
		return this.logger;
	}

	public void setLogger(Logger log)
	{
		this.logger = log;
	}

	public String getComponentName()
	{
		return COMPONENT_NAME;
	}

	public Map<String, String> processClientInformation(WMSProperties props, IServer iServer, List<IVHost> vHosts)
	{
		// This function is called each time the client is polls for information. It must return a name/value map

		Map<String, String> returnMap = new HashMap<String, String>();
		// Do something here
		returnMap.put("dummyName", "dummyInfo");

		return returnMap;
	}

}	
