package my.domain.test.http.extension;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.wowza.wms.http.IHTTPRequest;
import com.wowza.wms.http.IHTTPResponse;
import com.wowza.wms.plugin.loadbalancer.http.ILoadBalancerHTTPExtension;
import com.wowza.wms.plugin.loadbalancer.server.ILoadBalancerServer;
import com.wowza.wms.plugin.loadbalancer.server.ILoadBalancerServerClient;
import com.wowza.wms.plugin.loadbalancer.utils.Logger;
import com.wowza.wms.vhost.IVHost;

public class LoadBalancerHTTPDummy implements ILoadBalancerHTTPExtension
{

	private final String COMPONENT_NAME = "Dummy";
	private boolean debug = false;
	private boolean active = true;

	public boolean getDebug()
	{
		return this.debug;
	}

	public void setDebug(boolean debug)
	{
		this.debug = debug;
	}

	public boolean getActive()
	{
		return this.active;
	}

	public void setActive(boolean active)
	{
		this.active = active;
	}

	public String getComponentName()
	{
		return COMPONENT_NAME;
	}

	public String processHTTPRequest(IVHost inVhost, IHTTPRequest req, IHTTPResponse resp, String assetPath,
			ILoadBalancerServer loadBalancerServer)
	{
		Map<String, List<String>> requestParams = req.getParameterMap();
		String IP = req.getRemoteAddr();
		HashMap<String, String> params = new HashMap<String, String>();
		// If a decision is needed based on the source IP , add the IP to the params list being sent
		// to the decision logic. As this is for M3U8 type we do not need to override the request.
		params.put("ClientIP", IP);
		ILoadBalancerServerClient foundClient = loadBalancerServer.processServerDataExtensions(params);
		String output = “”;
		if (foundClient != null)
		{
			// foundClient.getClientHost() does all the work for client IP or forced IP and also port
			// removing the : if port 80 is provided
			output = req.getType() + "://" + foundClient.getClientHost() + assetPath + "/playlist.m3u8";

			// You could set return headers for a redirect
			// resp.setHeader("Location", output);
			//resp.setResponseCode(302);
		}
		// If you want to return an output you do so here, or return null. If redirecting returning null is important for some clients.
		return output;
	}
}
