/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.loadbalancer.client;

import com.wowza.util.HTTPUtils;
import com.wowza.util.StringUtils;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.plugin.loadbalancer.client.ILoadBalancerClient;
import com.wowza.wms.plugin.loadbalancer.client.ILoadBalancerClientCommunication;
import com.wowza.wms.plugin.loadbalancer.client.ILoadBalancerClientDataExtension;
import com.wowza.wms.plugin.loadbalancer.utils.Logger;
import com.wowza.wms.server.IServer;
import com.wowza.wms.server.Server;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.VHostList;
import com.wowza.wms.vhost.VHostSingleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class LoadBalancerClient
extends Thread
implements ILoadBalancerClient {
    private static final Class<LoadBalancerClient> CLASS = LoadBalancerClient.class;
    private final String loadBalanceServerPath = "loadbalancerinterface";
    private final String clientCommunicationClass = "com.wowza.wms.plugin.loadbalancer.client.LoadBalancerClientCommunication";
    private final String clientExtensionAlways = "com.wowza.wms.plugin.loadbalancer.client.LoadBalancerClientExtensionBaseClientProperties|";
    private final Map<String, ILoadBalancerClientCommunication> clientComms = new HashMap<String, ILoadBalancerClientCommunication>();
    private final Map<String, ILoadBalancerClientDataExtension> clientDataExtensions = new HashMap<String, ILoadBalancerClientDataExtension>();
    private final ArrayList<String> loadClientExtensions = new ArrayList();
    private String serverIP = "";
    private String serverPort = "1935";
    private String serverKey = "";
    private String serverPath = "";
    private String clientName = "";
    private String serverScheme = "http";
    private boolean debugEncrypt = false;
    private boolean debugDecrypt = false;
    private boolean debugHTTPComms = false;
    private boolean debugClientExtension = false;
    private boolean debugClientProcess = false;
    private boolean debugURLRequest = false;
    private int clientCountRun = 0;
    private IVHost vHost = null;
    private boolean debug = false;
    private IServer iServer = null;
    private WMSProperties serverProps = null;
    private Logger logger = null;
    private boolean active = false;
    private String clientExtensionClasses = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(WMSProperties wMSProperties, IServer iServer, IVHost iVHost) {
        Object object;
        Object object2;
        String string;
        String string2;
        String string3;
        String string4;
        this.serverProps = wMSProperties;
        this.iServer = iServer;
        this.vHost = iVHost;
        this.serverIP = this.serverProps.getPropertyStr("loadbalanceServerIP", this.serverIP);
        if (StringUtils.isEmpty((String)this.serverIP) && this.serverProps.getPropertyStr("loadbalanceServerType").contains("Server")) {
            this.serverIP = "localhost";
        }
        this.serverPath = this.serverProps.getPropertyStr("loadbalanceServerPath", this.loadBalanceServerPath);
        this.serverPort = this.serverProps.getPropertyStr("loadbalanceServerPort", this.serverPort);
        this.serverKey = this.serverProps.getPropertyStr("loadbalanceKey", this.serverKey);
        this.clientName = this.serverProps.getPropertyStr("loadbalanceClientName", this.clientName);
        this.debugEncrypt = iServer.getProperties().getPropertyBoolean("loadbalanceDebugEncrypt", this.debugEncrypt);
        this.debugDecrypt = iServer.getProperties().getPropertyBoolean("loadbalanceDebugDecrypt", this.debugDecrypt);
        this.debugHTTPComms = iServer.getProperties().getPropertyBoolean("loadbalanceDebugClientCommunications", this.debugHTTPComms);
        this.debugClientExtension = iServer.getProperties().getPropertyBoolean("loadbalanceDebugClientExtension", this.debugClientExtension);
        this.debugClientProcess = iServer.getProperties().getPropertyBoolean("loadbalanceDebugClientProcess", this.debugClientProcess);
        this.debugURLRequest = iServer.getProperties().getPropertyBoolean("loadbalanceDebugURLRequest", this.debugURLRequest);
        this.serverScheme = iServer.getProperties().getPropertyStr("loadbalanceClientCommunicationScheme", this.serverScheme);
        if (this.vHost != null) {
            this.clientName = this.vHost.getProperties().getPropertyStr("loadbalanceClientName", this.clientName);
            this.serverIP = this.vHost.getProperties().getPropertyStr("loadbalanceServerIP", this.serverIP);
            this.serverPath = this.vHost.getProperties().getPropertyStr("loadbalanceServerPath", this.loadBalanceServerPath);
            this.serverPort = this.vHost.getProperties().getPropertyStr("loadbalanceServerPort", this.serverPort);
            this.serverKey = this.vHost.getProperties().getPropertyStr("loadbalanceKey", this.serverKey);
            this.debugEncrypt = this.vHost.getProperties().getPropertyBoolean("loadbalanceDebugEncrypt", this.debugEncrypt);
            this.debugDecrypt = this.vHost.getProperties().getPropertyBoolean("loadbalanceDebugDecrypt", this.debugDecrypt);
            this.debugHTTPComms = this.vHost.getProperties().getPropertyBoolean("loadbalanceDebugClientCommunications", this.debugHTTPComms);
            this.debugClientExtension = this.vHost.getProperties().getPropertyBoolean("loadbalanceDebugClientExtension", this.debugClientExtension);
            this.debugClientProcess = this.vHost.getProperties().getPropertyBoolean("loadbalanceDebugClientProcess", this.debugClientProcess);
            this.debugURLRequest = this.vHost.getProperties().getPropertyBoolean("loadbalanceDebugURLRequest", this.debugURLRequest);
            this.serverScheme = this.vHost.getProperties().getPropertyStr("loadbalanceClientCommunicationScheme", this.serverScheme);
        }
        this.setClientName(this.clientName);
        String[] stringArray = this.serverIP.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            string4 = stringArray[i];
            string3 = this.getNextFirstArrayLocation(this.serverPort, i);
            string2 = this.getNextFirstArrayLocation(this.serverKey, i);
            string = this.getNextFirstArrayLocation(this.serverPath, i);
            if (string4.length() > 0 && string2.length() == 16) {
                ++this.clientCountRun;
                try {
                    object2 = Class.forName(this.clientCommunicationClass);
                    object = (ILoadBalancerClientCommunication)((Class)object2).newInstance();
                    if (this.getDebug()) {
                        this.logger.logMessageDebug(CLASS.toString(), "Client info destination IP '" + string4 + "'");
                        this.logger.logMessageDebug(CLASS.toString(), "Client info destination port '" + string3 + "'");
                        this.logger.logMessageDebug(CLASS.toString(), "Client info destination key '" + string2 + "'");
                        this.logger.logMessageDebug(CLASS.toString(), "Client info destination path '" + string + "'");
                        this.logger.logMessageDebug(CLASS.toString(), "Client name is '" + this.clientName + "'");
                        this.logger.logMessageDebug(CLASS.toString(), "Client logger '" + this.logger + "'");
                        this.logger.logMessageDebug(CLASS.toString(), "Client scheme '" + this.serverScheme + "'");
                    }
                    object.setLogger(this.logger);
                    object.setServerIP(stringArray[i]);
                    object.setServerPort(string3);
                    object.setServerKey(string2);
                    object.setServerPath(string);
                    object.setClientName(this.clientName);
                    object.setServerScheme(this.serverScheme);
                    object.setDebug(this.debugHTTPComms);
                    boolean bl = object.init();
                    if (this.getDebug()) {
                        this.logger.logMessageDebug(CLASS.toString(), "Initialisation flag is '" + bl + "'");
                    }
                    if (!bl) continue;
                    object.getClientProcessResponse().setDebug(this.debugClientProcess);
                    object.getDataRequester().setDebug(this.debugURLRequest);
                    ((Thread)object).setDaemon(true);
                    ((Thread)object).start();
                    this.clientComms.put(stringArray[i], (ILoadBalancerClientCommunication)object);
                }
                catch (Exception exception) {
                    this.logger.logMessageDebug(CLASS.toString(), "Class exception: " + this.clientCommunicationClass + " exception " + exception);
                }
                continue;
            }
            this.logger.logMessageInfo(CLASS.toString(), "Client IP: '" + string4 + "' or key: '" + string2 + "' invalid. Not communicating with destination.");
        }
        if (this.clientCountRun > 0) {
            String string5 = "";
            string4 = "";
            string3 = "";
            string2 = "";
            string = "";
            object2 = "";
            object = "";
            String string6 = "";
            String string7 = "";
            string5 = this.serverProps.getPropertyStr("loadbalanceConnectionEnable", string5);
            string5 = this.serverProps.getPropertyStr("loadbalanceClientConnectionEnable", "Off");
            string4 = this.serverProps.getPropertyStr("loadbalanceBandwidthEnable", "Off");
            string4 = this.serverProps.getPropertyStr("loadbalanceClientBandwidthEnable", string4);
            string3 = this.serverProps.getPropertyStr("loadbalanceCountryEnable", "Off");
            string3 = this.serverProps.getPropertyStr("loadbalanceClientCountryEnable", string3);
            string2 = this.serverProps.getPropertyStr("loadbalanceClientPublishStreamsEnable", string2);
            string = this.serverProps.getPropertyStr("loadbalanceClientPrivateAddressMapEnable", string);
            object2 = this.serverProps.getPropertyStr("loadbalanceClientGeoIP2CountryEnable", (String)object2);
            object = this.serverProps.getPropertyStr("loadbalanceClientGeoIP2CityEnable", (String)object);
            string6 = this.serverProps.getPropertyStr("loadbalanceClientProcessClasses", "");
            string7 = this.serverProps.getPropertyStr("loadbalanceClientProcessAddClasses", "");
            if (this.vHost != null) {
                string5 = this.vHost.getProperties().getPropertyStr("loadbalanceConnectionEnable", string5);
                string5 = this.vHost.getProperties().getPropertyStr("loadbalanceClientConnectionEnable", string5);
                string4 = this.vHost.getProperties().getPropertyStr("loadbalanceBandwidthEnable", string4);
                string4 = this.vHost.getProperties().getPropertyStr("loadbalanceClientBandwidthEnable", string4);
                string3 = this.vHost.getProperties().getPropertyStr("loadbalanceCountryEnable", string3);
                string3 = this.vHost.getProperties().getPropertyStr("loadbalanceClientCountryEnable", string3);
                string2 = this.vHost.getProperties().getPropertyStr("loadbalanceClientPublishStreamsEnable", string2);
                string = this.vHost.getProperties().getPropertyStr("loadbalanceClientPrivateAddressMapEnable", string);
                object2 = this.vHost.getProperties().getPropertyStr("loadbalanceClientGeoIP2CountryEnable", (String)object2);
                object = this.vHost.getProperties().getPropertyStr("loadbalanceClientGeoIP2CityEnable", (String)object);
                string6 = this.vHost.getProperties().getPropertyStr("loadbalanceClientProcessClasses", string6);
                string7 = this.serverProps.getPropertyStr("loadbalanceClientProcessAddClasses", string7);
            }
            if (string5.equalsIgnoreCase("on")) {
                this.clientExtensionClasses = this.clientExtensionClasses + "com.wowza.wms.plugin.loadbalancer.client.LoadBalancerClientExtensionConnectionCounts|";
            }
            if (string4.equalsIgnoreCase("on")) {
                this.clientExtensionClasses = this.clientExtensionClasses + "com.wowza.wms.plugin.loadbalancer.client.LoadBalancerClientExtensionBandwidth|";
            }
            if (string3.equalsIgnoreCase("on")) {
                this.clientExtensionClasses = this.clientExtensionClasses + "com.wowza.wms.plugin.loadbalancer.client.LoadBalancerClientExtensionMaxMind|";
            }
            if (string2.equalsIgnoreCase("on")) {
                this.clientExtensionClasses = this.clientExtensionClasses + "com.wowza.wms.plugin.loadbalancer.client.LoadBalancerClientExtensionPublishedStreams|";
            }
            if (string.equalsIgnoreCase("on")) {
                this.clientExtensionClasses = this.clientExtensionClasses + "com.wowza.wms.plugin.loadbalancer.client.LoadBalancerClientExtensionPrivateAddressMap|";
            }
            if (((String)object2).equalsIgnoreCase("on")) {
                this.clientExtensionClasses = this.clientExtensionClasses + "com.wowza.wms.plugin.loadbalancer.client.LoadBalancerClientExtensionMaxMindGeoIP2Country|";
            }
            if (((String)object).equalsIgnoreCase("on")) {
                this.clientExtensionClasses = this.clientExtensionClasses + "com.wowza.wms.plugin.loadbalancer.client.LoadBalancerClientExtensionMaxMindGeoIP2City|";
            }
            if (string7.length() > 0) {
                if (!this.clientExtensionClasses.endsWith("|")) {
                    this.clientExtensionClasses = this.clientExtensionClasses + "|";
                }
                this.clientExtensionClasses = this.clientExtensionClasses + string7;
            }
            if (string6.length() > 0) {
                this.clientExtensionClasses = string6;
            }
            this.clientExtensionClasses = this.clientExtensionAlways + this.clientExtensionClasses;
            if (this.getDebug()) {
                this.logger.logMessageDebug(CLASS.toString(), "  Extension classses are " + this.clientExtensionClasses);
            }
            Map map = HTTPUtils.expandHTTPHeadersStr((String)this.clientExtensionClasses);
            for (Object object3 : map.keySet()) {
                this.loadClientExtensions.add((String)object3);
            }
            for (String string8 : this.loadClientExtensions) {
                try {
                    Class<?> clazz = Class.forName(string8);
                    ILoadBalancerClientDataExtension iLoadBalancerClientDataExtension = (ILoadBalancerClientDataExtension)clazz.newInstance();
                    if (iLoadBalancerClientDataExtension != null) {
                        Map<String, ILoadBalancerClientDataExtension> map2 = this.clientDataExtensions;
                        synchronized (map2) {
                            String string9 = iLoadBalancerClientDataExtension.getComponentName().toLowerCase();
                            if (!this.clientDataExtensions.containsKey(string9)) {
                                if (!string9.startsWith("loadbalancerclient")) {
                                    if (this.getDebug()) {
                                        this.logger.logMessageDebug(CLASS.toString(), "Extension initialising: " + string9 + " debug: " + this.debugClientExtension);
                                    }
                                    iLoadBalancerClientDataExtension.setActive(true);
                                    iLoadBalancerClientDataExtension.setLogger(this.logger);
                                    iLoadBalancerClientDataExtension.setDebug(this.debugClientExtension);
                                    iLoadBalancerClientDataExtension.init(this.serverProps, this.iServer, this.getActiveVHosts(this.iServer, this.vHost));
                                    this.clientDataExtensions.put(string9, iLoadBalancerClientDataExtension);
                                } else {
                                    this.logger.logMessageInfo(CLASS.toString(), " Extension Name Not Allowed " + string9 + " can not start with LoadBalancerClient: Class " + string8);
                                }
                            } else {
                                this.logger.logMessageInfo(CLASS.toString(), " Extension Name Already In Use " + string9 + " Class " + string8);
                            }
                            continue;
                        }
                    }
                    this.logger.logMessageInfo(CLASS.toString(), " Class not found: " + string8);
                }
                catch (Exception exception) {
                    this.logger.logMessageInfo(CLASS.toString(), " Class init exception: " + string8 + " exception is '" + exception + "'");
                }
            }
        } else {
            this.logger.logMessageInfo(CLASS.toString(), "No Valid Clients Started, perhaps loadbalanceServerIP is not set");
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                block4: while (true) {
                    Object object;
                    Thread.sleep(2000L);
                    List<IVHost> list = this.getActiveVHosts(this.iServer, this.vHost);
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    for (String string : this.clientDataExtensions.keySet()) {
                        object = this.clientDataExtensions.get(string);
                        if (!object.getActive()) continue;
                        String string2 = object.getComponentName();
                        Map<String, String> map = object.processClientInformation(this.serverProps, this.iServer, list);
                        for (String string3 : map.keySet()) {
                            hashMap.put(string2 + "-" + string3, map.get(string3));
                        }
                    }
                    Iterator<String> iterator = this.clientComms.keySet().iterator();
                    while (true) {
                        String string;
                        if (!iterator.hasNext()) continue block4;
                        string = iterator.next();
                        object = this.clientComms.get(string);
                        if (!object.getActive()) continue;
                        object.updateDataSet(hashMap);
                    }
                    break;
                }
            }
            catch (Exception exception) {
                WMSLoggerFactory.getLoggerObj((IVHost)this.vHost).error(CLASS.getSimpleName() + ".run() exception thrown. ", (Throwable)exception);
                continue;
            }
            catch (Error error) {
                WMSLoggerFactory.getLoggerObj((IVHost)this.vHost).error(CLASS.getSimpleName() + ".run() error thrown. ", (Throwable)error);
                continue;
            }
            break;
        }
    }

    @Override
    public String getClientName() {
        return this.clientName;
    }

    @Override
    public void setClientName(String string) {
        if (string == null || string.length() < 2) {
            string = UUID.randomUUID().toString();
        }
        this.clientName = string;
    }

    @Override
    public boolean getDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean bl) {
        this.active = bl;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public boolean getStatus() {
        return false;
    }

    @Override
    public String getServerPort() {
        return this.serverPort;
    }

    @Override
    public void setServerPort(String string) {
        this.serverPort = string;
    }

    @Override
    public String getServerIP() {
        return this.serverIP;
    }

    @Override
    public void setServerIP(String string) {
        this.serverIP = string;
    }

    @Override
    public String getServerKey() {
        return this.serverKey;
    }

    @Override
    public void setServerKey(String string) {
        this.serverKey = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addClientDataExtension(ILoadBalancerClientDataExtension iLoadBalancerClientDataExtension) {
        Map<String, ILoadBalancerClientDataExtension> map = this.clientDataExtensions;
        synchronized (map) {
            String string = iLoadBalancerClientDataExtension.getComponentName().toLowerCase();
            this.clientDataExtensions.put(string, iLoadBalancerClientDataExtension);
        }
    }

    public List<IVHost> getActiveVHosts(IServer iServer, IVHost iVHost) {
        ArrayList<IVHost> arrayList = new ArrayList<IVHost>();
        if (iServer != null) {
            VHostList vHostList = Server.getInstance().getVHostList();
            for (String string : vHostList.getVHostNames()) {
                IVHost iVHost2 = VHostSingleton.getInstance((String)string);
                arrayList.add(iVHost2);
            }
        } else if (iVHost != null) {
            arrayList.add(iVHost);
        }
        return arrayList;
    }

    private String getNextFirstArrayLocation(String string, int n) {
        String[] stringArray = null;
        try {
            stringArray = string.split(",");
        }
        catch (Exception exception) {
            return string;
        }
        if (n > stringArray.length - 1) {
            return stringArray[0];
        }
        return stringArray[n];
    }
}

