/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.loadbalancer.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.wowza.wms.plugin.loadbalancer.client.ILoadBalancerClientCommunication;
import com.wowza.wms.plugin.loadbalancer.client.ILoadBalancerClientProcessResponse;
import com.wowza.wms.plugin.loadbalancer.client.LoadBalancerClientCommunicationParameters;
import com.wowza.wms.plugin.loadbalancer.encryption.CommunicationEncryptor;
import com.wowza.wms.plugin.loadbalancer.utils.ILoadBalancerDataRequester;
import com.wowza.wms.plugin.loadbalancer.utils.Logger;
import java.util.HashMap;
import java.util.Map;

public class LoadBalancerClientCommunication
extends Thread
implements ILoadBalancerClientCommunication {
    private static final Class<LoadBalancerClientCommunication> CLASS = LoadBalancerClientCommunication.class;
    private final int failCountLimit = 3;
    private final int communicationTimeout = 10000;
    private final String clientCommunicationXMLClass = "/com/wowza/wms/plugin/loadbalancer/templates/ClientCommandXML.xml";
    public String serverIP = "";
    public String serverPort = "";
    public String serverKey = "";
    public String serverPath = "";
    public String clientName = "";
    public String clientScheme = "";
    private boolean connected = false;
    private boolean logNotConnected = true;
    private boolean active = false;
    private boolean available = true;
    private boolean quit = false;
    private boolean debug = false;
    private Logger logger = null;
    private int failCount = 0;
    private int clientContinueRunning = 0;
    private String processResponseClass = "com.wowza.wms.plugin.loadbalancer.client.LoadBalancerClientProcessResponse";
    private String dataRequesterClass = "com.wowza.wms.plugin.loadbalancer.utils.LoadBalancerURLRequester";
    private CommunicationEncryptor communicationEncrypter = null;
    private ILoadBalancerDataRequester dataRequester = null;
    private ILoadBalancerClientProcessResponse processResponse = null;
    private LoadBalancerClientCommunicationParameters communicationParams = null;
    private final Map<String, String> dataSet = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDataSet(Map<String, String> map) {
        Map<String, String> map2 = this.dataSet;
        synchronized (map2) {
            this.dataSet.clear();
            if (map != null) {
                for (String string : map.keySet()) {
                    this.dataSet.put(string, map.get(string));
                }
            }
        }
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public ILoadBalancerDataRequester getDataRequester() {
        return this.dataRequester;
    }

    @Override
    public ILoadBalancerClientProcessResponse getClientProcessResponse() {
        return this.processResponse;
    }

    @Override
    public String getProcessResponseClass() {
        return this.processResponseClass;
    }

    public void setProcessResponseClass(String string) {
        this.processResponseClass = string;
    }

    @Override
    public String getDataRequesterClass() {
        return this.dataRequesterClass;
    }

    public void setDataRequesterClass(String string) {
        this.dataRequesterClass = string;
    }

    @Override
    public String getClientName() {
        return this.clientName;
    }

    @Override
    public void setClientName(String string) {
        this.clientName = string;
    }

    public String getServerScheme() {
        return this.clientScheme;
    }

    @Override
    public void setServerScheme(String string) {
        this.clientScheme = string;
    }

    @Override
    public boolean init() {
        Class<?> clazz;
        if (this.getDebug()) {
            this.logger.logMessageInfo(CLASS.toString(), "Init called");
        }
        try {
            this.communicationEncrypter = new CommunicationEncryptor(this.serverKey);
        }
        catch (Exception exception) {
            if (this.getDebug()) {
                this.logger.logMessageInfo(CLASS.toString(), "Encryption class not found, not initialising");
            }
            this.available = false;
        }
        try {
            clazz = Class.forName(this.getProcessResponseClass());
            this.processResponse = (ILoadBalancerClientProcessResponse)clazz.newInstance();
            this.processResponse.setLogger(this.logger);
            this.processResponse.setDebug(this.getDebug());
        }
        catch (Exception exception) {
            if (this.getDebug()) {
                this.logger.logMessageInfo(CLASS.toString(), "Process Response class not found, not initialising");
            }
            this.available = false;
        }
        try {
            clazz = Class.forName(this.getDataRequesterClass());
            this.dataRequester = (ILoadBalancerDataRequester)clazz.newInstance();
            this.dataRequester.setLogger(this.logger);
            this.dataRequester.setServerScheme(this.clientScheme);
            this.dataRequester.setDebug(this.debug);
        }
        catch (Exception exception) {
            if (this.getDebug()) {
                this.logger.logMessageInfo(CLASS.toString(), "Data Request class not found, not initialising");
            }
            this.available = false;
        }
        if (!this.available) {
            return false;
        }
        this.dataRequester.setServerIP(this.serverIP);
        this.dataRequester.setServerPath(this.serverPath);
        this.dataRequester.setServerPort(this.serverPort);
        this.communicationParams = new LoadBalancerClientCommunicationParameters();
        this.communicationParams.setClientName(this.getClientName());
        this.active = true;
        if (this.getDebug()) {
            this.logger.logMessageInfo(CLASS.toString(), "Init finished");
        }
        return this.available;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.available) {
            this.clientContinueRunning = 0;
            Map<String, String> map = this;
            synchronized (map) {
                block22: {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception exception) {
                        if (!this.getDebug()) break block22;
                        this.logger.logMessageDebug(CLASS.toString(), "Sleep exception");
                    }
                }
            }
            if (!this.getConnected()) {
                if (this.logNotConnected) {
                    this.logger.logMessageInfo(CLASS.toString(), "Client not connected: " + this.dataRequester.getServerIP() + ":" + this.dataRequester.getServerPort() + "/" + this.dataRequester.getServerPath() + " ID - " + this.getClientName());
                    this.logNotConnected = false;
                }
                map = this.sendCommandJson("Start", new HashMap<String, String>());
                this.clientContinueRunning = this.processResponse.processCommunicationInformation(map, this.communicationParams);
                if (this.clientContinueRunning == 200) {
                    this.setConnected(true);
                }
                if (this.getConnected()) {
                    this.logger.logMessageInfo(CLASS.toString(), "Client connected: " + this.dataRequester.getServerIP() + ":" + this.dataRequester.getServerPort() + "/" + this.dataRequester.getServerPath() + " ID - " + this.getClientName());
                }
            } else {
                map = this.sendCommandJson("Update", this.dataSet);
                if (!map.isEmpty()) {
                    this.clientContinueRunning = this.processResponse.processCommunicationInformation(map, this.communicationParams);
                } else if (this.getDebug()) {
                    this.logger.logMessageInfo(CLASS.toString(), " Sent Result Decryption failed for some reason");
                }
                if (this.getDebug()) {
                    this.logger.logMessageInfo(CLASS.toString(), "Client " + this.dataRequester.getServerIP() + ":" + this.dataRequester.getServerPort() + "/" + this.dataRequester.getServerPath() + " ID - " + this.getClientName());
                    this.logger.logMessageInfo(CLASS.toString(), "Communication state response: " + this.clientContinueRunning);
                }
            }
            if (this.clientContinueRunning == 200) {
                this.failCount = 0;
            }
            if (this.clientContinueRunning == 1) {
                this.logger.logMessageInfo(CLASS.toString(), "Client stopped: " + this.dataRequester.getServerIP() + ":" + this.dataRequester.getServerPort() + "/" + this.dataRequester.getServerPath() + " ID - " + this.getClientName());
                this.quit = true;
            }
            if (this.clientContinueRunning == 2) {
                if (this.getDebug()) {
                    this.logger.logMessageInfo(CLASS.toString(), "Client asked to register: " + this.dataRequester.getServerIP() + ":" + this.dataRequester.getServerPort() + "/" + this.dataRequester.getServerPath() + " ID - " + this.getClientName());
                }
                this.failCount = 0;
                this.communicationParams.setClientID("");
                this.communicationParams.setClientStatus("");
                this.setConnected(false);
            }
            if (this.clientContinueRunning == 0) {
                if (this.getDebug()) {
                    this.logger.logMessageInfo(CLASS.toString(), "Client comms state UNKNOWN");
                }
                ++this.failCount;
                if (this.failCount > 3) {
                    this.failCount = 0;
                    this.communicationParams.setClientID("");
                    this.communicationParams.setClientStatus("");
                    this.setConnected(false);
                }
            }
            if (!this.quit) continue;
            break;
        }
    }

    private Map<String, String> sendCommandJson(String string, Map<String, String> map) {
        HashMap hashMap;
        block4: {
            hashMap = new HashMap();
            try {
                String string2 = this.formatJsonCommand(string, map);
                String string3 = this.dataRequester.requestData(string2, this.communicationParams.getClientID(), this.communicationTimeout);
                string3 = this.communicationEncrypter.decrypt(string3);
                if (this.debug) {
                    this.logger.logMessageDebug(CLASS.toString(), "response: " + string3);
                }
                hashMap = (HashMap)new ObjectMapper().readValue(string3, (TypeReference)new TypeReference<HashMap<String, String>>(){});
            }
            catch (Exception exception) {
                if (!this.getDebug()) break block4;
                if (exception.toString().toLowerCase().contains("content is not allowed in prolog")) {
                    this.logger.logMessageDebug(CLASS.toString(), "Communications key and Enc/Dec class check required: ClientName: " + this.clientName + " received response failed to decode.");
                }
                this.logger.logMessageDebug(CLASS.toString(), "Exception for parsing json response is " + exception);
                exception.printStackTrace(System.err);
            }
        }
        return hashMap;
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean bl) {
        this.active = bl;
    }

    @Override
    public String getServerIP() {
        return this.serverIP;
    }

    @Override
    public void setServerIP(String string) {
        this.serverIP = string;
    }

    @Override
    public String getServerPort() {
        return this.serverPort;
    }

    @Override
    public void setServerPort(String string) {
        this.serverPort = string;
    }

    @Override
    public void setServerPath(String string) {
        this.serverPath = string;
    }

    @Override
    public void setServerKey(String string) {
        this.serverKey = string;
    }

    @Override
    public boolean getDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    @Override
    public boolean getConnected() {
        return this.connected;
    }

    @Override
    public void setConnected(boolean bl) {
        this.connected = bl;
        if (bl) {
            this.logNotConnected = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String formatJsonCommand(String string, Map<String, String> map) throws JsonProcessingException {
        String string2;
        Map<String, String> map2 = map;
        synchronized (map2) {
            map.put("Client-Command", string);
            map.put("Client-ServerIP", this.serverIP);
            map.put("Client-ClientName", this.communicationParams.getClientName());
            map.put("Client-ClientID", this.communicationParams.getClientID());
            string2 = new ObjectMapper().writeValueAsString(map);
        }
        if (this.debug) {
            this.logger.logMessageDebug(CLASS.toString(), "command: " + string2);
        }
        return this.communicationEncrypter.encrypt(string2);
    }
}

