/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.loadbalancer.client;

import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.client.IClient;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.plugin.loadbalancer.client.ILoadBalancerClientDataExtension;
import com.wowza.wms.plugin.loadbalancer.utils.Logger;
import com.wowza.wms.rtp.model.RTPSession;
import com.wowza.wms.server.IServer;
import com.wowza.wms.vhost.IVHost;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LoadBalancerClientExtensionConnectionCounts
implements ILoadBalancerClientDataExtension {
    public static final String LOADBALANCER_EXTENSION_CONNECTION_LIMIT = "loadbalanceConnectionLimit";
    public static final String LOADBALANCER_EXTENSION_CLIENT_CONNECTION_LIMIT = "loadbalanceClientConnectionLimit";
    public static final String LOADBALANCER_EXTENSION_CLIENT_CONNECTION_COUNT = "loadbalanceClientConnectionCount";
    public static final String LOADBALANCER_EXTENSION_COUNT_SOURCE_CLIENT = "loadbalanceCountSourceClient";
    public static final String LOADBALANCER_EXTENSION_CLIENT_COUNT_SOURCE_CLIENT = "loadbalanceClientCountSourceClient";
    public static final String COMPONENT_NAME = "ClientExtensionConnectionCounts";
    private static final Class<LoadBalancerClientExtensionConnectionCounts> CLASS = LoadBalancerClientExtensionConnectionCounts.class;
    private boolean debug = false;
    private boolean active = false;
    private Logger logger = null;
    private String applicationsExclude = "";
    private String applicationsInclude = "";
    private String connectionLimit = "0";
    private boolean allowSourceStreams = false;

    @Override
    public void init(WMSProperties wMSProperties, IServer iServer, List<IVHost> list) {
        this.applicationsExclude = wMSProperties.getPropertyStr("loadbalanceApplicationsExclude", this.applicationsExclude);
        this.applicationsInclude = wMSProperties.getPropertyStr("loadbalanceApplicationsInclude", this.applicationsInclude);
        this.connectionLimit = wMSProperties.getPropertyStr(LOADBALANCER_EXTENSION_CONNECTION_LIMIT, this.connectionLimit);
        this.connectionLimit = wMSProperties.getPropertyStr(LOADBALANCER_EXTENSION_CLIENT_CONNECTION_LIMIT, this.connectionLimit);
        this.allowSourceStreams = wMSProperties.getPropertyBoolean(LOADBALANCER_EXTENSION_COUNT_SOURCE_CLIENT, this.allowSourceStreams);
        this.allowSourceStreams = wMSProperties.getPropertyBoolean(LOADBALANCER_EXTENSION_CLIENT_COUNT_SOURCE_CLIENT, this.allowSourceStreams);
        if (this.getDebug()) {
            this.logger.logMessageDebug(CLASS.toString(), "ClientExtensionConnectionCounts Initializing");
            this.logger.logMessageDebug(CLASS.toString(), "loadbalanceApplicationsExclude " + (this.applicationsExclude.length() == 0 ? "Unset" : this.applicationsExclude));
            this.logger.logMessageDebug(CLASS.toString(), "loadbalanceApplicationsInclude " + (this.applicationsInclude.length() == 0 ? "Unset" : this.applicationsInclude));
            this.logger.logMessageDebug(CLASS.toString(), "loadbalanceClientConnectionLimit " + (this.connectionLimit.length() == 0 ? "Unset" : this.connectionLimit));
            this.logger.logMessageDebug(CLASS.toString(), "loadbalanceClientCountSourceClient " + (Serializable)(!this.allowSourceStreams ? "false" : Boolean.valueOf(this.allowSourceStreams)));
        }
    }

    @Override
    public boolean getDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean bl) {
        this.active = bl;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public String getComponentName() {
        return COMPONENT_NAME;
    }

    @Override
    public Map<String, String> processClientInformation(WMSProperties wMSProperties, IServer iServer, List<IVHost> list) {
        int n = 0;
        for (IVHost object2 : list) {
            if (object2 == null) continue;
            for (String string : object2.getApplicationNames()) {
                if (this.applicationsExclude.length() > 0 && this.mapExactName(this.applicationsExclude, string) || this.applicationsInclude.length() > 0 && !this.mapExactName(this.applicationsInclude, string)) continue;
                Iterator iterator = object2.getApplication(string).getAppInstanceNames().iterator();
                while (iterator.hasNext()) {
                    List exception;
                    IApplicationInstance iApplicationInstance = object2.getApplication(string).getAppInstance((String)iterator.next());
                    List list2 = iApplicationInstance.getClients();
                    Iterator iterator2 = list2.iterator();
                    while (iterator2.hasNext()) {
                        try {
                            exception = (IClient)iterator2.next();
                            if (exception == null || !this.allowSourceStreams && exception.getIp().equalsIgnoreCase("127.0.0.1")) continue;
                            ++n;
                        }
                        catch (Exception exception2) {}
                    }
                    exception = iApplicationInstance.getHTTPStreamerSessions();
                    Iterator iterator3 = exception.iterator();
                    while (iterator3.hasNext()) {
                        try {
                            IHTTPStreamerSession iHTTPStreamerSession = (IHTTPStreamerSession)iterator3.next();
                            if (iHTTPStreamerSession == null || !this.allowSourceStreams && iHTTPStreamerSession.getIpAddress().equalsIgnoreCase("127.0.0.1")) continue;
                            ++n;
                        }
                        catch (Exception exception3) {}
                    }
                    exception = iApplicationInstance.getRTPSessions();
                    Iterator iterator4 = exception.iterator();
                    while (iterator4.hasNext()) {
                        try {
                            RTPSession rTPSession = (RTPSession)iterator4.next();
                            if (rTPSession == null || !this.allowSourceStreams && rTPSession.getIp().equalsIgnoreCase("127.0.0.1")) continue;
                            ++n;
                        }
                        catch (Exception exception4) {}
                    }
                }
            }
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(LOADBALANCER_EXTENSION_CLIENT_CONNECTION_LIMIT, this.connectionLimit);
        hashMap.put(LOADBALANCER_EXTENSION_CLIENT_CONNECTION_COUNT, String.valueOf(n));
        return hashMap;
    }

    private boolean mapExactName(String string, String string2) {
        try {
            String[] stringArray = string.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equalsIgnoreCase(string2)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

