/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.loadbalancer.client;

import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.plugin.loadbalancer.client.ILoadBalancerClientDataExtension;
import com.wowza.wms.plugin.loadbalancer.utils.Logger;
import com.wowza.wms.server.IServer;
import com.wowza.wms.vhost.IVHost;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LoadBalancerClientExtensionPrivateAddressMap
implements ILoadBalancerClientDataExtension {
    public static final String LOADBALANCER_EXTENSION_PRIVATETAG_LIST = "loadbalancePrivateAddressTagList";
    public static final String LOADBALANCER_EXTENSION_CLIENT_PRIVATETAG_LIST = "loadbalanceClientPrivateAddressTagList";
    public static final String COMPONENT_NAME = "ClientPrivateAddressSpace";
    private static final Class<LoadBalancerClientExtensionPrivateAddressMap> CLASS = LoadBalancerClientExtensionPrivateAddressMap.class;
    private boolean debug = false;
    private boolean active = false;
    private Logger logger = null;
    private String privateAddressSpaceTagProperty = "";

    @Override
    public void init(WMSProperties wMSProperties, IServer iServer, List<IVHost> list) {
        this.privateAddressSpaceTagProperty = wMSProperties.getPropertyStr(LOADBALANCER_EXTENSION_PRIVATETAG_LIST, "");
        this.privateAddressSpaceTagProperty = wMSProperties.getPropertyStr(LOADBALANCER_EXTENSION_CLIENT_PRIVATETAG_LIST, this.privateAddressSpaceTagProperty);
        for (IVHost iVHost : list) {
            if (iVHost == null) continue;
            this.privateAddressSpaceTagProperty = wMSProperties.getPropertyStr(LOADBALANCER_EXTENSION_PRIVATETAG_LIST, "");
            this.privateAddressSpaceTagProperty = wMSProperties.getPropertyStr(LOADBALANCER_EXTENSION_CLIENT_PRIVATETAG_LIST, this.privateAddressSpaceTagProperty);
        }
        if (this.getDebug()) {
            this.logger.logMessageDebug(CLASS.toString(), "ClientPrivateAddressSpace Initializing");
            this.logger.logMessageDebug(CLASS.toString(), "loadbalanceClientPrivateAddressTagList " + this.privateAddressSpaceTagProperty);
        }
    }

    @Override
    public boolean getDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean bl) {
        this.active = bl;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public String getComponentName() {
        return COMPONENT_NAME;
    }

    @Override
    public Map<String, String> processClientInformation(WMSProperties wMSProperties, IServer iServer, List<IVHost> list) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.privateAddressSpaceTagProperty.length() > 0) {
            hashMap.put(LOADBALANCER_EXTENSION_CLIENT_PRIVATETAG_LIST, this.privateAddressSpaceTagProperty);
        }
        return hashMap;
    }
}

