/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.loadbalancer.client;

import com.wowza.wms.application.IApplication;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.plugin.loadbalancer.client.ILoadBalancerClientDataExtension;
import com.wowza.wms.plugin.loadbalancer.utils.Logger;
import com.wowza.wms.server.IServer;
import com.wowza.wms.vhost.IVHost;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LoadBalancerClientExtensionPublishedStreams
implements ILoadBalancerClientDataExtension {
    public static final String COMPONENT_NAME = "ClientExtensionPublishedStreams";
    private static final Class<LoadBalancerClientExtensionPublishedStreams> CLASS = LoadBalancerClientExtensionPublishedStreams.class;
    private boolean debug = false;
    private boolean active = false;
    private Logger logger = null;
    private boolean applicationsInstanceNameInclude = false;

    @Override
    public boolean getDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean bl) {
        this.active = bl;
    }

    @Override
    public String getComponentName() {
        return COMPONENT_NAME;
    }

    @Override
    public void init(WMSProperties wMSProperties, IServer iServer, List<IVHost> list) {
        this.applicationsInstanceNameInclude = wMSProperties.getPropertyBoolean("loadbalanceApplicationInstanceNameInclude", this.applicationsInstanceNameInclude);
        String string = wMSProperties.getPropertyStr("loadbalanceApplicationsExclude", "");
        String string2 = wMSProperties.getPropertyStr("loadbalanceApplicationsInclude", "");
        string = wMSProperties.getPropertyStr("loadbalanceClientApplicationsExclude", string);
        string2 = wMSProperties.getPropertyStr("loadbalanceClientApplicationsInclude", string2);
        if (this.getDebug()) {
            this.logger.logMessageDebug(CLASS.toString(), "ClientExtensionPublishedStreamsClient Initializing");
            this.logger.logMessageDebug(CLASS.toString(), "loadbalanceApplicationsExclude " + (string.length() == 0 ? "Unset" : string));
            this.logger.logMessageDebug(CLASS.toString(), "loadbalanceApplicationsInclude " + (string2.length() == 0 ? "Unset" : string2));
            this.logger.logMessageDebug(CLASS.toString(), "loadbalanceApplicationInstanceNameInclude " + (Serializable)(!this.applicationsInstanceNameInclude ? "false" : Boolean.valueOf(this.applicationsInstanceNameInclude)));
        }
    }

    @Override
    public Map<String, String> processClientInformation(WMSProperties wMSProperties, IServer iServer, List<IVHost> list) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Object object = "";
        String string = wMSProperties.getPropertyStr("loadbalanceApplicationsExclude", "");
        String string2 = wMSProperties.getPropertyStr("loadbalanceApplicationsInclude", "");
        string = wMSProperties.getPropertyStr("loadbalanceClientApplicationsExclude", string);
        string2 = wMSProperties.getPropertyStr("loadbalanceClientApplicationsInclude", string2);
        for (IVHost iVHost : list) {
            if (iVHost == null) continue;
            string = iVHost.getProperties().getPropertyStr("loadbalanceApplicationsExclude", string);
            string2 = iVHost.getProperties().getPropertyStr("loadbalanceApplicationsInclude", string2);
            List list2 = iVHost.getApplicationNames();
            for (String string3 : list2) {
                if (string.length() > 0 && this.mapExactName(string, string3) || string2.length() > 0 && !this.mapExactName(string2, string3)) continue;
                IApplication iApplication = null;
                try {
                    iApplication = iVHost.getApplication(string3);
                    for (String string4 : iApplication.getAppInstanceNames()) {
                        IApplicationInstance iApplicationInstance = null;
                        try {
                            iApplicationInstance = iApplication.getAppInstance(string4);
                            for (String string5 : iApplicationInstance.getPublishStreamNames()) {
                                if (this.applicationsInstanceNameInclude) {
                                    object = (String)object + string3 + "/" + iApplicationInstance.getName() + "/" + string5 + ",";
                                }
                                if (this.applicationsInstanceNameInclude) continue;
                                object = (String)object + string3 + "/" + string5 + ",";
                            }
                        }
                        catch (Exception exception) {
                        }
                    }
                }
                catch (Exception exception) {
                }
            }
        }
        hashMap.put("publishedStreams", (String)object);
        return hashMap;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    private boolean mapExactName(String string, String string2) {
        try {
            String[] stringArray = string.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equalsIgnoreCase(string2)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

