/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.plugin.loadbalancer.http;

import com.wowza.wms.http.IHTTPRequest;
import com.wowza.wms.http.IHTTPResponse;
import com.wowza.wms.plugin.loadbalancer.http.ILoadBalancerHTTPExtension;
import com.wowza.wms.plugin.loadbalancer.http.LoadBalancerHTTPProvider;
import com.wowza.wms.plugin.loadbalancer.server.ILoadBalancerServer;
import com.wowza.wms.plugin.loadbalancer.server.ILoadBalancerServerClient;
import com.wowza.wms.plugin.loadbalancer.utils.Logger;
import com.wowza.wms.vhost.IVHost;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LoadBalancerHTTPDASH
implements ILoadBalancerHTTPExtension {
    private static final Class<LoadBalancerHTTPDASH> CLASS = LoadBalancerHTTPDASH.class;
    private final String COMPONENT_NAME = "DASH";
    private final String DEFAULT_MANIFEST_TYPE = "manifest.mpd";
    String[] mpegDashExtensions = new String[]{"manifest_mpm4sav_mvlist.mpd", "manifest_mvlist.mpd", "manifest_mpm4sav_mvtime.mpd", "manifest_mvtime.mpd", "manifest.mpd", "manifest_mpm4sav_mvnumber.mpd", "manifest_mvnumber.mpd"};
    private boolean debug = false;
    private boolean active = true;
    private Logger logger = null;

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public boolean getDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean bl) {
        this.active = bl;
    }

    @Override
    public String getComponentName() {
        return "DASH";
    }

    @Override
    public String processHTTPRequest(IVHost iVHost, IHTTPRequest iHTTPRequest, IHTTPResponse iHTTPResponse, String string, ILoadBalancerServer iLoadBalancerServer) {
        Map map = iHTTPRequest.getParameterMap();
        String string2 = iHTTPRequest.getRemoteAddr();
        String string3 = iHTTPRequest.getQueryString();
        String string4 = "manifest.mpd";
        if (map.containsKey("IP")) {
            try {
                string2 = (String)((List)map.get("IP")).get(0);
            }
            catch (Exception exception) {
                string2 = "INVALID";
            }
        }
        if (map.containsKey("manifestType")) {
            try {
                string4 = (String)((List)map.get("manifestType")).get(0);
                if (this.getDebug()) {
                    this.logger.logMessageDebug(CLASS.getName(), "Manifest type set to: " + string4);
                }
            }
            catch (Exception exception) {
                string4 = "manifest.mpd";
            }
        }
        if (string4 == null) {
            string4 = "manifest.mpd";
        }
        string4 = string4.toLowerCase();
        boolean bl = false;
        for (int i = 0; i < this.mpegDashExtensions.length; ++i) {
            if (!this.mpegDashExtensions[i].equalsIgnoreCase(string4)) continue;
            bl = true;
            if (!this.getDebug()) continue;
            this.logger.logMessageDebug(CLASS.getName(), "Manifest checked as valid: " + string4);
        }
        if (!bl) {
            string4 = "manifest.mpd";
            if (this.getDebug()) {
                this.logger.logMessageDebug(CLASS.getName(), "Manifest found as  invalid restting to default: " + string4);
            }
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("ClientIP", string2);
        hashMap.put("ClientStream", string);
        hashMap.put("ClientQueryString", string3);
        hashMap.put("ClientScheme", iHTTPRequest.isSecure() ? "true" : "false");
        hashMap.put("ClientPort", String.valueOf(iHTTPRequest.getServerPort()));
        ILoadBalancerServerClient iLoadBalancerServerClient = iLoadBalancerServer.processServerDataExtensions(hashMap);
        string3 = LoadBalancerHTTPProvider.removeKnownParameters(string3);
        if (iLoadBalancerServerClient != null) {
            String string5 = iLoadBalancerServerClient.getScheme() + "://" + iLoadBalancerServerClient.getClientHost() + string + "/" + string4 + string3;
            if (this.getDebug()) {
                this.logger.logMessageDebug(CLASS.getName(), "Redirection URL is: " + string5);
            }
            iHTTPResponse.setHeader("Location", string5);
            iHTTPResponse.setResponseCode(302);
            this.incrementConnectionCount(iLoadBalancerServerClient);
        } else if (this.getDebug()) {
            this.logger.logMessageDebug(CLASS.getName(), "Client list is empty");
        }
        return null;
    }
}

